/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class IndexWhere
extends SystemFunction {
    @Override
    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.PLUS_ONE, Expression.MAX_SEQUENCE_LENGTH};
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        SequenceIterator seq = arguments[0].iterate();
        FunctionItem predicate = (FunctionItem)arguments[1].head();
        IndexIterator iter = new IndexIterator(seq, context, predicate);
        return new LazySequence(iter);
    }

    private static class IndexIterator
    implements SequenceIterator {
        private int index = 0;
        private final SequenceIterator base;
        private final FunctionItem predicate;
        private final XPathContext context;

        public IndexIterator(SequenceIterator base, XPathContext context, FunctionItem predicate) {
            this.base = base;
            this.context = context;
            this.predicate = predicate;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public Int64Value next() {
            Item baseItem;
            while ((baseItem = this.base.next()) != null) {
                ++this.index;
                try {
                    Sequence result = SystemFunction.dynamicCall(this.predicate, this.context, baseItem);
                    BooleanValue val = (BooleanValue)result.head();
                    if (val == null || !val.getBooleanValue()) continue;
                    return new Int64Value(this.index);
                }
                catch (XPathException e) {
                    throw new UncheckedXPathException(e);
                }
            }
            return null;
        }
    }
}

