/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.saxon.Version;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UnicodeChar;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class CharFn
extends SystemFunction {
    private static HashMap<UnicodeString, UnicodeString> ENTITIES = null;
    public static UnicodeString NewLineName = BMPString.of("NewLine");

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue name = (StringValue)arguments[0].head();
        UnicodeString uName = name.getUnicodeStringValue();
        if (!uName.isEmpty()) {
            int lead = uName.codePointAt(0L);
            if (lead == 92 && uName.length() == 2L) {
                switch (uName.codePointAt(1L)) {
                    case 110: {
                        return new StringValue(new UnicodeChar(10));
                    }
                    case 116: {
                        return new StringValue(new UnicodeChar(9));
                    }
                    case 114: {
                        return new StringValue(new UnicodeChar(13));
                    }
                }
                return this.invalid(uName);
            }
            if (lead == 35 && uName.length() >= 2L) {
                try {
                    int cp = uName.codePointAt(1L) == 120 ? Integer.parseInt(uName.substring(2L).toString(), 16) : Integer.parseInt(uName.substring(1L).toString(), 10);
                    if (!context.getConfiguration().getValidCharacterChecker().test(cp)) {
                        throw new XPathException("Character supplied to fn:char is not a valid XML character: " + uName, "FOCH0005");
                    }
                    return new StringValue(new UnicodeChar(cp));
                }
                catch (NumberFormatException e) {
                    this.invalid(uName);
                }
            } else {
                return new StringValue(this.readEntity(uName));
            }
        }
        return this.invalid(uName);
    }

    public Sequence invalid(UnicodeString name) throws XPathException {
        throw new XPathException("Invalid argument to fn:char(): " + Err.wrap(name.toString()), "FOCH0005");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnicodeString readEntity(UnicodeString name) throws XPathException {
        Class<CharFn> clazz = CharFn.class;
        synchronized (CharFn.class) {
            if (ENTITIES == null) {
                CharFn.build();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            UnicodeString value = ENTITIES.get(name);
            if (value == null) {
                this.invalid(name);
            }
            return value;
        }
    }

    static void build() {
        ENTITIES = new HashMap(2500);
        ENTITIES.put(NewLineName, new UnicodeChar(10));
        InputStream in = Version.platform.locateResource("entities.txt", new ArrayList<String>());
        if (in == null) {
            throw new RuntimeException("Unable to read entities.txt file");
        }
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, StandardCharsets.UTF_8), 2048);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int eq = line.indexOf(61);
                String key = line.substring(0, eq);
                String value = line.substring(eq + 1);
                UnicodeString uValue = StringTool.fromCharSequence(value);
                if (uValue.length() == 1L) {
                    uValue = new UnicodeChar(uValue.codePointAt(0L));
                }
                ENTITIES.put(new Twine8(key), uValue);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read entities.txt file", e);
        }
    }
}

