/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Base64BinaryValue;

public class ReadBinaryResource
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        try {
            byte[] buffer;
            int b;
            InputStream stream;
            String arg = arguments[0].head().getStringValue();
            try {
                stream = ResourceLoader.urlStream(context.getConfiguration(), arg);
            }
            catch (RuntimeException e) {
                throw new XPathException("saxon:read-binary-resource - invalid or inaccessible URL " + arg, "SXJE0053");
            }
            ArrayList<byte[]> buffers = new ArrayList<byte[]>();
            int len = 0;
            while (!this.isFinished(b = stream.read(buffer = new byte[4096]))) {
                if (b < 4096) {
                    buffer = Arrays.copyOf(buffer, b);
                }
                buffers.add(buffer);
                len += b;
            }
            byte[] result = new byte[len];
            int offset = 0;
            for (byte[] buffer2 : buffers) {
                System.arraycopy(buffer2, 0, result, offset, buffer2.length);
                offset += buffer2.length;
            }
            return new Base64BinaryValue(result);
        }
        catch (IOException e) {
            throw new XPathException("saxon:read-binary-resource: I/O error: " + e.getMessage(), "SXJE0053");
        }
    }

    private boolean isFinished(int indicator) {
        return indicator < 0;
    }
}

