/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.StringReader;
import java.util.HashMap;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Doc_2;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.value.AtomicValue;

public class Parse
extends SystemFunction {
    @Override
    public NodeInfo call(XPathContext context, Sequence[] arguments) throws XPathException {
        ParseOptions parseOptions;
        HashMap<String, GroundedValue> checkedOptions;
        Controller controller = context.getController();
        Configuration config = controller.getConfiguration();
        AtomicValue content = (AtomicValue)arguments[0].head();
        StringReader sr = new StringReader(content.getStringValue());
        StreamSource source = new StreamSource(sr, this.getStaticBaseUriString());
        if (arguments.length == 1) {
            checkedOptions = new HashMap();
            parseOptions = new ParseOptions();
        } else {
            checkedOptions = this.getDetails().optionDetails.processSuppliedOptions((MapItem)arguments[1].head(), context);
            parseOptions = Doc_2.setParseOptions(this.getRetainedStaticContext(), checkedOptions, context);
        }
        Sequence suppliedBaseUriVal = (Sequence)checkedOptions.get("base-uri");
        if (suppliedBaseUriVal == null || suppliedBaseUriVal.head() == null) {
            source.setSystemId(this.getStaticBaseUriString());
        } else {
            source.setSystemId(suppliedBaseUriVal.head().getStringValue());
        }
        Builder b = controller.makeBuilder();
        if (b instanceof TinyBuilder) {
            ((TinyBuilder)b).setStatistics(config.getTreeStatistics().FN_PARSE_STATISTICS);
        }
        Receiver s = b;
        PackageData pd = this.getRetainedStaticContext().getPackageData();
        if (checkedOptions.get("strip-space") == null) {
            if (pd instanceof StylesheetPackage) {
                parseOptions = parseOptions.withSpaceStrippingRule(((StylesheetPackage)pd).getSpaceStrippingRule());
                if (((StylesheetPackage)pd).isStripsTypeAnnotations()) {
                    s = config.getAnnotationStripper(s);
                }
            } else {
                parseOptions = parseOptions.withSpaceStrippingRule(IgnorableSpaceStrippingRule.getInstance());
            }
        }
        parseOptions = parseOptions.withErrorReporter(context.getController().getErrorReporter());
        parseOptions = this.setXMLReader(config, parseOptions);
        s.setPipelineConfiguration(b.getPipelineConfiguration());
        Sender.send(source, s, parseOptions);
        NodeInfo node = b.getCurrentRoot();
        b.reset();
        return node;
    }

    protected ParseOptions setXMLReader(Configuration config, ParseOptions source) throws XPathException {
        return source;
    }
}

