/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;

public class NewAttribute
extends SystemFunction {
    @Override
    public NodeInfo call(XPathContext context, Sequence[] arguments) throws XPathException {
        StructuredQName name;
        Orphan orphan = new Orphan(context.getConfiguration());
        orphan.setNodeKind((short)2);
        AtomicValue nameArg = (AtomicValue)arguments[0].head();
        if (nameArg instanceof QNameValue) {
            name = ((QNameValue)nameArg).getStructuredQName();
        } else {
            String s = nameArg.getStringValue();
            name = StructuredQName.fromLexicalQName(s, false, true, this.getRetainedStaticContext());
        }
        String prefix = name.getPrefix();
        String local = name.getLocalPart();
        NamespaceUri uri = name.getNamespaceUri();
        if (local.equals("xmlns") && uri.isEmpty()) {
            throw new XPathException("Invalid attribute name: xmlns", "XQDY0044");
        }
        if (uri.isEmpty() && !prefix.isEmpty()) {
            prefix = "";
        }
        if (prefix.equals("xmlns")) {
            prefix = "";
        }
        if (prefix.isEmpty() && !uri.isEmpty() && (prefix = context.getNamePool().suggestPrefixForURI(uri)) == null) {
            prefix = "ns0";
        }
        if (uri.equals(NamespaceUri.XML) != "xml".equals(prefix)) {
            throw new XPathException("The xml prefix and namespace can only be used together", "XTDE0835");
        }
        name = new StructuredQName(prefix, uri, local);
        orphan.setNodeName(new FingerprintedQName(name, context.getNamePool()));
        Item first = arguments[1].head();
        orphan.setStringValue(first == null ? EmptyUnicodeString.getInstance() : first.getUnicodeStringValue());
        return orphan;
    }
}

