/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn.EXPathArchive;

import com.saxonica.functions.extfn.EXPathArchive.Entry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.One;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ZeroOrMore;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.sapling.SaplingElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;

public class Archive {
    public static final BigDecimalValue VERSION = new BigDecimalValue(new BigDecimal("0.1"));
    public static final NamespaceUri NAMESPACE;
    public static final String PREFIX = "arch";
    public static final NamespaceUri ERROR_NAMESPACE;
    public static final String ERROR_PREFIX = "arch";
    private static final boolean USE_ELEMENTS = false;
    private static final String ERROR_UNKNOWN_ENTRY = "unknown-entry";
    private static final String ERROR_ENTRY_DATA_MISMATCH = "entry-data-mismatch";
    private static final String ERROR_UNKNOWN_ENCODING = "unknown-encoding";
    private static final String ERROR_DECODING = "decoding-error";
    private static final String ERROR_OPTION = "option-error";
    private static final HashMap<ArchiveType, String> archiveTypes;
    private static final HashMap<CompressionType, String> compressionTypes;
    private static final HashMap<String, CharsetDecoder> decoders;

    public static BigDecimalValue version() {
        return VERSION;
    }

    private static void error(String message, String code) throws XPathException {
        XPathException e = new XPathException(message);
        e.setErrorCodeQName(new StructuredQName("arch", ERROR_NAMESPACE, code));
        throw e;
    }

    private static CompressionType stringToCompressionType(String s) {
        for (CompressionType c : compressionTypes.keySet()) {
            if (!compressionTypes.get((Object)c).equals(s)) continue;
            return c;
        }
        return null;
    }

    private static CompressionType zipCompressions(int c) {
        if (c == 8) {
            return CompressionType.DEFLATE;
        }
        if (c == 0) {
            return CompressionType.STORED;
        }
        return CompressionType.UNKNOWN;
    }

    private static One<Base64BinaryValue> one(byte[] result) {
        return new One<Base64BinaryValue>(new Base64BinaryValue(result));
    }

    private static NodeName qname(String s) {
        return new NoNamespaceName(s);
    }

    private static QName qnameNS(String s) {
        return new QName("arch", NAMESPACE.toString(), s);
    }

    private static void attribute(Outputter r, NodeName name, String value) throws XPathException {
        r.attribute(name, BuiltInAtomicType.UNTYPED_ATOMIC, value, Loc.NONE, 0);
    }

    private static void attribute(Outputter r, NodeName name, long value) throws XPathException {
        r.attribute(name, BuiltInAtomicType.UNTYPED_ATOMIC, Long.valueOf(value).toString(), Loc.NONE, 0);
    }

    private static void startElement(Outputter r, NodeName name) throws XPathException {
        r.startElement(name, Untyped.getInstance(), Loc.NONE, 0);
    }

    private static ArrayList<Entry> toExtractionEntries(Sequence entries) {
        return Archive.toExtractionEntries(entries, null);
    }

    private static ArrayList<Entry> toExtractionEntries(Sequence entries, Entry entryDefault) {
        Item item;
        ArrayList<Entry> requested = new ArrayList<Entry>();
        if (entries == null) {
            return requested;
        }
        SequenceIterator iter = entries.iterate();
        while ((item = iter.next()) != null) {
            if (item instanceof MapItem) {
                AtomicValue av;
                AtomicIterator ui = ((MapItem)item).keys();
                while ((av = ui.next()) != null) {
                    requested.add(new Entry(entryDefault, av.getStringValue()));
                }
                continue;
            }
            requested.add(new Entry(entryDefault, item.getStringValue()));
        }
        return requested;
    }

    private static ArrayList<Entry> toInsertionEntries(ZeroOrMore<StringValue> entries, ZeroOrMore<Base64BinaryValue> values) throws XPathException {
        ArrayList<Entry> m = new ArrayList<Entry>();
        SequenceIterator entryIter = entries.iterate();
        SequenceIterator valueIter = values.iterate();
        while (true) {
            Base64BinaryValue value;
            StringValue entry;
            if ((entry = (StringValue)entryIter.next()) == null != ((value = (Base64BinaryValue)valueIter.next()) == null)) {
                Archive.error("Entry name and value sequences have different lengths", ERROR_ENTRY_DATA_MISMATCH);
            }
            if (entry == null) break;
            m.add(new Entry(entry.getStringValue(), value));
        }
        return m;
    }

    private static ArrayList<Entry> toInsertionEntries(MapItem entries, Entry defaultEntry) throws XPathException {
        AtomicValue av;
        AtomicIterator ui = entries.keys();
        ArrayList<Entry> result = new ArrayList<Entry>();
        Entry first = null;
        StringValue content = StringValue.bmp("content");
        StringValue compressionKey = StringValue.bmp("compression");
        StringValue positionKey = StringValue.bmp("position");
        while ((av = ui.next()) != null) {
            MapItem entry = (MapItem)entries.get(av).iterate().next();
            Entry e = new Entry(av.getStringValue(), (Base64BinaryValue)entry.get(content).iterate().next());
            e.setCompression(defaultEntry.compression);
            GroundedValue s = entry.get(compressionKey);
            if (s != null) {
                String compressionValue = s.iterate().next().getStringValue();
                e.setCompression(Archive.stringToCompressionType(compressionValue));
            }
            if ((s = entry.get(positionKey)) != null) {
                try {
                    long position = ((Int64Value)s.iterate().next()).longValue();
                }
                catch (Exception ex) {
                    Archive.error("The value of 'position' property must be an integer", ERROR_OPTION);
                }
                if (first != null) {
                    Archive.error("Only one entry can be declared as position:1", ERROR_OPTION);
                }
                first = e;
                continue;
            }
            result.add(e);
        }
        if (first != null) {
            result.add(0, first);
        }
        return result;
    }

    public static ArchiveType archiveType(Base64BinaryValue in) throws XPathException {
        byte[] supplied = in.getBinaryValue();
        byte[] zipID = new byte[]{80, 75, 3, 4};
        if (Archive.arraysEqual(supplied, 0, 4, zipID, 0, 4)) {
            return ArchiveType.ZIP;
        }
        byte[] gzipID = new byte[]{31, -117};
        if (Archive.arraysEqual(supplied, 0, 2, gzipID, 0, 2)) {
            return ArchiveType.GZIP;
        }
        return ArchiveType.UNKNOWN;
    }

    private static boolean arraysEqual(byte[] a, int aFrom, int aTo, byte[] b, int bFrom, int bTo) {
        if (aTo - aFrom != bTo - bFrom) {
            return false;
        }
        int i = aFrom;
        int j = bFrom;
        while (i < aTo) {
            if (a[i++] == b[j++]) continue;
            return false;
        }
        return true;
    }

    public static CompressionType compressionType(Base64BinaryValue in) throws XPathException {
        return CompressionType.UNKNOWN;
    }

    private static HashTrieMap add(HashTrieMap map, String key, HashTrieMap val) {
        return map.addEntry(new StringValue(key), val);
    }

    public static HashTrieMap add(HashTrieMap map, String key, AtomicValue val) throws XPathException {
        return map.addEntry(new StringValue(key), val);
    }

    public static HashTrieMap add(HashTrieMap map, String key, String val) throws XPathException {
        return Archive.add(map, key, new StringValue(val));
    }

    public static HashTrieMap add(HashTrieMap map, String key, long val) throws XPathException {
        return Archive.add(map, key, new Int64Value(val));
    }

    private static ArrayList<ZipEntry> getEntries(ZipInputStream in) throws IOException {
        ZipEntry next;
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        while ((next = in.getNextEntry()) != null) {
            entries.add(next);
            in.closeEntry();
        }
        in.close();
        return entries;
    }

    private static CompressionType compressionMethods(Base64BinaryValue in) throws IOException {
        CompressionType ct = CompressionType.UNKNOWN;
        for (ZipEntry ze : Archive.getEntries(new ZipInputStream(new ByteArrayInputStream(in.getBinaryValue())))) {
            CompressionType t = Archive.zipCompressions(ze.getMethod());
            if (ct == CompressionType.UNKNOWN) {
                ct = t;
                continue;
            }
            if (ct == t) continue;
            return CompressionType.MIXED;
        }
        return ct;
    }

    public static ZeroOrMore<? extends StringValue> entryNames(Base64BinaryValue in) throws IOException, XPathException, URISyntaxException {
        ArrayList<StringValue> names = new ArrayList<StringValue>();
        ZipInputStream stream = new ZipInputStream(new ByteArrayInputStream(in.getBinaryValue()));
        for (ZipEntry ze : Archive.getEntries(stream)) {
            names.add(new StringValue(ze.getName()));
        }
        return new ZeroOrMore(names);
    }

    public static ArrayList<NodeInfo> entries(XPathContext context, Base64BinaryValue in) throws IOException, XPathException, URISyntaxException {
        QName archEntry = Archive.qnameNS("entry");
        QName archDir = Archive.qnameNS("dir");
        ZipInputStream zi = new ZipInputStream(new ByteArrayInputStream(in.getBinaryValue()));
        ArrayList<ZipEntry> entries = Archive.getEntries(zi);
        ArrayList<NodeInfo> results = new ArrayList<NodeInfo>();
        for (ZipEntry ze : entries) {
            SaplingElement elem = new SaplingElement(ze.isDirectory() ? archDir : archEntry);
            long val = ze.getSize();
            if (val != -1L) {
                elem = elem.withAttr("size", "" + val);
            }
            if ((val = ze.getCompressedSize()) != -1L) {
                elem = elem.withAttr("compressed-size", val + "");
            }
            if ((val = ze.getTime()) != -1L) {
                elem = elem.withAttr("last-modified", DateTimeValue.fromJavaTime(val).getStringValue());
            }
            elem = elem.withAttr("compression", compressionTypes.get((Object)Archive.zipCompressions(ze.getMethod())));
            elem = elem.withText(ze.getName());
            results.add(elem.toNodeInfo(context.getConfiguration()));
        }
        return results;
    }

    public static MapItem entriesMap(XPathContext context, Base64BinaryValue in) throws IOException, XPathException {
        return Archive.entriesMap(context, in, BooleanValue.FALSE);
    }

    public static MapItem entriesMap(XPathContext context, Base64BinaryValue in, BooleanValue returnContent) throws IOException, XPathException {
        ZipEntry next;
        HashTrieMap result = new HashTrieMap();
        ZipInputStream zi = new ZipInputStream(new ByteArrayInputStream(in.getBinaryValue()));
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int position = 1;
        while ((next = zi.getNextEntry()) != null) {
            HashTrieMap properties = new HashTrieMap();
            properties = Archive.add(properties, "position", position++);
            long val = next.getSize();
            if (val != -1L) {
                properties = Archive.add(properties, "size", val);
            }
            if ((val = next.getCompressedSize()) != -1L) {
                properties = Archive.add(properties, "compressed-size", val);
            }
            if ((val = next.getTime()) != -1L) {
                properties = Archive.add(properties, "last-modified", DateTimeValue.fromJavaTime(val).getStringValue());
            }
            properties = Archive.add(properties, "compression", compressionTypes.get((Object)Archive.zipCompressions(next.getMethod())));
            if (returnContent.getBooleanValue()) {
                int len;
                while ((len = zi.read(buffer)) > 0) {
                    output.write(buffer, 0, len);
                }
                properties = Archive.add(properties, "content", new Base64BinaryValue(output.toByteArray()));
                output.reset();
            }
            result = Archive.add(result, next.getName(), properties);
            zi.closeEntry();
        }
        zi.close();
        return result;
    }

    public static MapItem optionsMap(XPathContext context, Base64BinaryValue in) throws IOException, XPathException {
        HashTrieMap result = new HashTrieMap();
        result = Archive.add(result, "format", archiveTypes.get((Object)Archive.archiveType(in)));
        result = Archive.add(result, "compression", compressionTypes.get((Object)Archive.compressionMethods(in)));
        return result;
    }

    public static NodeInfo options(XPathContext context, Base64BinaryValue in) throws XPathException {
        SaplingElement elem = new SaplingElement(Archive.qnameNS("options"));
        elem = elem.withAttr("format", archiveTypes.get((Object)Archive.archiveType(in))).withAttr("compression", compressionTypes.get((Object)Archive.compressionType(in)));
        return elem.toNodeInfo(context.getConfiguration());
    }

    private static void checkUnfound(ArrayList<Entry> entries) throws XPathException {
        if (!entries.isEmpty()) {
            StringBuilder e = new StringBuilder("No entr").append(entries.size() == 1 ? "y" : "ies");
            for (int i = 0; i < entries.size(); ++i) {
                e.append(" ").append(entries.get((int)i).name);
                if (i == entries.size() - 1) continue;
                e.append(",");
            }
            e.append(" found in archive");
            Archive.error(e.toString(), ERROR_UNKNOWN_ENTRY);
        }
    }

    private static ArrayList<Entry> extractEntries(Base64BinaryValue in, ArrayList<Entry> entries) throws IOException, XPathException {
        ZipEntry next;
        ArrayList requested = (ArrayList)entries.clone();
        ArrayList<Entry> result = new ArrayList<Entry>();
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ZipInputStream zi = new ZipInputStream(new ByteArrayInputStream(in.getBinaryValue()));
        HashMap<String, Entry> found = new HashMap<String, Entry>();
        while ((next = zi.getNextEntry()) != null && !entries.isEmpty()) {
            String name = next.getName();
            Entry e = new Entry(name);
            if (entries.contains(e)) {
                int len;
                while ((len = zi.read(buffer)) > 0) {
                    output.write(buffer, 0, len);
                }
                found.put(name, new Entry(entries.get(entries.indexOf(e)), new Base64BinaryValue(output.toByteArray())));
                output.reset();
                while (entries.remove(e)) {
                }
            }
            zi.closeEntry();
        }
        zi.close();
        Archive.checkUnfound(entries);
        for (Entry e : requested) {
            result.add((Entry)found.get(e.name));
        }
        return result;
    }

    public static ZeroOrMore<Base64BinaryValue> extractBinary(One<Base64BinaryValue> in, ZeroOrMore<StringValue> entries) throws IOException, XPathException {
        ArrayList<Base64BinaryValue> result = new ArrayList<Base64BinaryValue>();
        for (Entry e : Archive.extractEntries((Base64BinaryValue)in.head(), Archive.toExtractionEntries(entries))) {
            result.add(e.content);
        }
        return new ZeroOrMore<Base64BinaryValue>(result);
    }

    public static ZeroOrMore<Base64BinaryValue> extractBinaryMap(One<Base64BinaryValue> in, One<MapItem> entries) throws IOException, XPathException {
        ArrayList<Base64BinaryValue> result = new ArrayList<Base64BinaryValue>();
        for (Entry e : Archive.extractEntries((Base64BinaryValue)in.head(), Archive.toExtractionEntries(entries.head()))) {
            result.add(e.content);
        }
        return new ZeroOrMore<Base64BinaryValue>(result);
    }

    public static ZeroOrMore<? extends StringValue> extractText(One<Base64BinaryValue> in, ZeroOrMore<StringValue> entries) throws IOException, XPathException, URISyntaxException {
        return Archive.extractText(in, entries, new One<StringValue>(StringValue.bmp("UTF-8")));
    }

    public static ZeroOrMore<? extends StringValue> extractText(One<Base64BinaryValue> in, ZeroOrMore<StringValue> entries, One<StringValue> encoding) throws IOException, XPathException, URISyntaxException {
        Entry def = new Entry();
        def.setEncoding(((StringValue)encoding.head()).getStringValue().toUpperCase());
        return Archive.extractText((Base64BinaryValue)in.head(), Archive.toExtractionEntries(entries, def));
    }

    private static ZeroOrMore<? extends StringValue> extractText(Base64BinaryValue in, ArrayList<Entry> entries) throws IOException, XPathException {
        ArrayList<StringValue> result = new ArrayList<StringValue>();
        for (Entry b : Archive.extractEntries(in, entries)) {
            CharsetDecoder decoder = decoders.get(b.encoding);
            if (decoder == null) {
                Archive.error("Unsupported encoding in text encode/decode:" + b.encoding, ERROR_UNKNOWN_ENCODING);
            }
            decoder.reset();
            byte[] bytes = b.content.getBinaryValue();
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            char[] outChars = new char[bytes.length];
            CharBuffer out = CharBuffer.wrap(outChars);
            CoderResult res = decoder.decode(bb, out, true);
            if (res.isError()) {
                if (res.isMalformed()) {
                    Archive.error("Malformed input in decoding", ERROR_DECODING);
                }
                if (res.isUnmappable()) {
                    Archive.error("Unmappable input in decoding", ERROR_DECODING);
                }
                Archive.error("Other error in decoding", ERROR_DECODING);
            }
            char[] resChars = new char[out.position()];
            System.arraycopy(outChars, 0, resChars, 0, out.position());
            result.add(new StringValue(new String(resChars)));
        }
        return new ZeroOrMore(result);
    }

    public static AtomicValue[] extractMap(One<Base64BinaryValue> in, One<MapItem> entries) throws IOException, XPathException {
        return Archive._extractMap((Base64BinaryValue)in.head(), Archive.toExtractionEntries(entries.head()));
    }

    private static AtomicValue[] _extractMap(Base64BinaryValue in, ArrayList<Entry> entries) throws IOException, XPathException {
        ArrayList<AtomicValue> result = new ArrayList<AtomicValue>();
        for (Entry b : Archive.extractEntries(in, entries)) {
            if (b.encoding != null) {
                CharsetDecoder decoder = decoders.get(b.encoding);
                if (decoder == null) {
                    Archive.error("Unsupported encoding in text encode/decode:" + b.encoding, ERROR_UNKNOWN_ENCODING);
                }
                decoder.reset();
                byte[] bytes = b.content.getBinaryValue();
                ByteBuffer bb = ByteBuffer.wrap(bytes);
                char[] outChars = new char[bytes.length];
                CharBuffer out = CharBuffer.wrap(outChars);
                CoderResult res = decoder.decode(bb, out, true);
                if (res.isError()) {
                    if (res.isMalformed()) {
                        Archive.error("Malformed input in decoding", ERROR_DECODING);
                    }
                    if (res.isUnmappable()) {
                        Archive.error("Unmappable input in decoding", ERROR_DECODING);
                    }
                    Archive.error("Other error in decoding", ERROR_DECODING);
                }
                char[] resChars = new char[out.position()];
                System.arraycopy(outChars, 0, resChars, 0, out.position());
                result.add(new StringValue(new String(resChars)));
                continue;
            }
            result.add(b.content);
        }
        return result.toArray(new AtomicValue[0]);
    }

    public static ZeroOrMore<? extends StringValue> extractTextMap(One<Base64BinaryValue> in, One<MapItem> entries) throws IOException, XPathException {
        return Archive.extractTextMap(in, entries, One.string("UTF-8"));
    }

    public static ZeroOrMore<? extends StringValue> extractTextMap(One<Base64BinaryValue> in, One<MapItem> entries, One<StringValue> encoding) throws IOException, XPathException {
        Entry def = new Entry();
        def.setEncoding(((StringValue)encoding.head()).getStringValue().toUpperCase());
        return Archive.extractText((Base64BinaryValue)in.head(), Archive.toExtractionEntries(entries, def));
    }

    public static One<Base64BinaryValue> delete(One<Base64BinaryValue> in, ZeroOrMore<StringValue> entries) throws IOException, XPathException {
        if (entries.head() == null) {
            return in;
        }
        return Archive.delete(in, Archive.toExtractionEntries(entries));
    }

    public static One<Base64BinaryValue> deleteMap(One<Base64BinaryValue> in, One<MapItem> entries) throws IOException, XPathException {
        if (entries.head() == null) {
            return in;
        }
        return Archive.delete(in, Archive.toExtractionEntries(entries));
    }

    private static One<Base64BinaryValue> delete(One<Base64BinaryValue> in, ArrayList<Entry> entries) throws IOException, XPathException {
        ByteArrayOutputStream full;
        block6: {
            ZipEntry next;
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            full = new ByteArrayOutputStream();
            ZipOutputStream zo = new ZipOutputStream(full);
            ZipInputStream zi = new ZipInputStream(new ByteArrayInputStream(((Base64BinaryValue)in.head()).getBinaryValue()));
            while ((next = zi.getNextEntry()) != null) {
                String name = next.getName();
                Entry e = new Entry(name);
                if (!entries.contains(e)) {
                    int len;
                    while ((len = zi.read(buffer)) > 0) {
                        output.write(buffer, 0, len);
                    }
                    ZipEntry nze = new ZipEntry(next.getName());
                    nze.setMethod(next.getMethod());
                    nze.setSize(next.getSize());
                    nze.setCrc(next.getCrc());
                    nze.setTime(next.getTime());
                    zo.putNextEntry(nze);
                    zo.write(output.toByteArray());
                    zo.closeEntry();
                    output.reset();
                } else {
                    entries.remove(e);
                }
                zi.closeEntry();
            }
            zi.close();
            try {
                zo.close();
            }
            catch (ZipException e) {
                if (e.getMessage().equals("ZIP file must have at least one entry")) break block6;
                throw e;
            }
        }
        Archive.checkUnfound(entries);
        return Archive.one(full.toByteArray());
    }

    public static Base64BinaryValue update(One<Base64BinaryValue> in, ZeroOrMore<StringValue> entries, ZeroOrMore<Base64BinaryValue> values) throws IOException, XPathException {
        return Archive.updateFromEntries((Base64BinaryValue)in.head(), Archive.toInsertionEntries(entries, values));
    }

    public static Base64BinaryValue updateMap(One<Base64BinaryValue> in, One<MapItem> entries) throws IOException, XPathException {
        return Archive.updateFromEntries((Base64BinaryValue)in.head(), Archive.toInsertionEntries((MapItem)entries.head(), new Entry()));
    }

    private static Base64BinaryValue updateFromEntries(Base64BinaryValue in, ArrayList<Entry> entries) throws IOException {
        Base64BinaryValue b;
        ZipEntry nze;
        ZipEntry next;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream full = new ByteArrayOutputStream();
        ZipOutputStream zo = new ZipOutputStream(full);
        ZipInputStream zi = new ZipInputStream(new ByteArrayInputStream(in.getBinaryValue()));
        CRC32 crc = new CRC32();
        while ((next = zi.getNextEntry()) != null) {
            String name = next.getName();
            Entry e = new Entry(name);
            nze = new ZipEntry(name);
            nze.setMethod(next.getMethod());
            if (entries.contains(e)) {
                b = entries.get((int)entries.indexOf((Object)e)).content;
                nze.setSize(b.getLengthInOctets());
                crc.reset();
                crc.update(b.getBinaryValue());
                nze.setCrc(crc.getValue());
                zo.putNextEntry(nze);
                zo.write(b.getBinaryValue());
                zo.closeEntry();
                entries.remove(e);
            } else {
                int len;
                while ((len = zi.read(buffer)) > 0) {
                    output.write(buffer, 0, len);
                }
                nze.setSize(next.getSize());
                nze.setCrc(next.getCrc());
                nze.setTime(next.getTime());
                zo.putNextEntry(nze);
                zo.write(output.toByteArray());
                zo.closeEntry();
                output.reset();
            }
            zi.closeEntry();
        }
        zi.close();
        for (Entry e : entries) {
            nze = new ZipEntry(e.name);
            b = e.content;
            nze.setSize(b.getLengthInOctets());
            crc.reset();
            crc.update(b.getBinaryValue());
            nze.setCrc(crc.getValue());
            zo.putNextEntry(nze);
            zo.write(b.getBinaryValue());
            zo.closeEntry();
        }
        zo.close();
        return new Base64BinaryValue(full.toByteArray());
    }

    public static Base64BinaryValue create(ZeroOrMore<StringValue> entries, ZeroOrMore<Base64BinaryValue> values) throws IOException, XPathException {
        return Archive.createFromEntries(Archive.toInsertionEntries(entries, values));
    }

    public static Base64BinaryValue createMap(One<MapItem> entries) throws IOException, XPathException {
        return Archive.createFromEntries(Archive.toInsertionEntries((MapItem)entries.head(), new Entry()));
    }

    public static Base64BinaryValue createMap(One<MapItem> entries, One<MapItem> options) throws IOException, XPathException {
        Entry defaultEntry = new Entry();
        GroundedValue s = ((MapItem)options.head()).get(StringValue.bmp("compression"));
        if (s != null) {
            defaultEntry.setCompression(Archive.stringToCompressionType(s.iterate().next().getStringValue()));
        }
        return Archive.createFromEntries(Archive.toInsertionEntries((MapItem)entries.head(), defaultEntry));
    }

    private static Base64BinaryValue createFromEntries(ArrayList<Entry> entries) throws IOException {
        ByteArrayOutputStream full = new ByteArrayOutputStream();
        ZipOutputStream zo = new ZipOutputStream(full);
        CRC32 crc = new CRC32();
        for (Entry e : entries) {
            ZipEntry nze = new ZipEntry(e.name);
            Base64BinaryValue b = e.content;
            if (e.isDir()) {
                nze.setSize(0L);
                nze.setCrc(0L);
                zo.putNextEntry(nze);
            } else {
                nze.setMethod(e.compression == CompressionType.STORED ? 0 : 8);
                nze.setSize(b.getLengthInOctets());
                crc.reset();
                crc.update(b.getBinaryValue());
                nze.setCrc(crc.getValue());
                zo.putNextEntry(nze);
                zo.write(b.getBinaryValue());
            }
            zo.closeEntry();
        }
        zo.close();
        return new Base64BinaryValue(full.toByteArray());
    }

    static {
        ERROR_NAMESPACE = NAMESPACE = NamespaceUri.of("http://expath.org/ns/archive");
        archiveTypes = new HashMap<ArchiveType, String>(){
            {
                this.put(ArchiveType.ZIP, "zip");
                this.put(ArchiveType.GZIP, "gzip");
                this.put(ArchiveType.UNKNOWN, "unknown");
            }
        };
        compressionTypes = new HashMap<CompressionType, String>(){
            {
                this.put(CompressionType.STORED, "stored");
                this.put(CompressionType.DEFLATE, "deflate");
                this.put(CompressionType.UNKNOWN, "unknown");
                this.put(CompressionType.MIXED, "mixed");
            }
        };
        decoders = new HashMap();
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoders.put("UTF-8", decoder);
        decoder = StandardCharsets.UTF_16.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoders.put("UTF-16", decoder);
        decoder = StandardCharsets.US_ASCII.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoders.put("US-ASCII", decoder);
        decoder = StandardCharsets.US_ASCII.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoders.put("ASCII", decoder);
        decoder = StandardCharsets.ISO_8859_1.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoders.put("ISO-8859-1", decoder);
    }

    public static enum CompressionType {
        STORED,
        DEFLATE,
        UNKNOWN,
        MIXED;

    }

    public static enum ArchiveType {
        UNKNOWN,
        ZIP,
        GZIP;

    }
}

