/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.BooleanFnFeed;
import com.saxonica.ee.stream.feed.SinkFeed;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.validate.AssertionTreeBuilder;
import com.saxonica.ee.validate.ComplexContentValidator;
import com.saxonica.ee.validate.ConstraintChecker;
import com.saxonica.ee.validate.ContentValidator;
import com.saxonica.ee.validate.EmptyContentValidator;
import com.saxonica.ee.validate.LaxValidator;
import com.saxonica.ee.validate.SimpleContentValidator;
import com.saxonica.ee.validate.SkipValidator;
import com.saxonica.ee.validate.ValidatingFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Durability;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Whitespace;

public class ValidationStack
extends ValidatingFilter {
    private final Stack<ContentValidator> stack = new Stack();
    private final Stack<Location> locationStack = new Stack();
    private final Receiver outputReceiver;
    private ContentValidator initialValidator;
    private List<ValidationFailure> xsiValidationErrors;
    private final int initialValidationMode;
    private final SchemaType initialType;
    private boolean isNilled = false;
    private NodeName topLevelElement = null;
    private final AssertionTreeBuilder assertionBuilder;
    private final WatchManager watchManager;
    private TinyBuilder builder;
    private int builderDepth;
    private Map<SchemaComponent, Integer> statistics;

    public ValidationStack(Receiver next, int initialValidationMode, SchemaType initialType) {
        super(next);
        this.outputReceiver = next;
        this.initialValidationMode = initialValidationMode;
        this.initialType = initialType;
        PipelineConfiguration pipe = next.getPipelineConfiguration();
        this.setPipelineConfiguration(pipe);
        this.assertionBuilder = (AssertionTreeBuilder)pipe.getComponent("com.saxonica.ee.validate.AssertionTreeBuilder");
        this.watchManager = (WatchManager)pipe.getComponent("com.saxonica.ee.stream.watch.WatchManager");
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        if (pipe.getController() == null) {
            Controller controller = new Controller(pipe.getConfiguration());
            controller.getExecutable().setSchemaAware(true);
            pipe.setController(controller);
        }
        if (pipe.getParseOptions().getValidationStatisticsRecipient() != null) {
            this.setKeepStatistics(true);
        }
    }

    public void setTopLevelElement(NodeName name) {
        this.topLevelElement = name;
    }

    public NodeName getTopLevelElement() {
        return this.topLevelElement;
    }

    @Override
    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
        super.setUnparsedEntity(name, uri, publicId);
        ConstraintChecker cc = this.getConstraintChecker();
        if (cc != null) {
            cc.setUnparsedEntity(name, uri, publicId);
        }
    }

    public void setIsNilled(boolean nilled) {
        this.isNilled = nilled;
    }

    public void setXsiValidationErrors(List<ValidationFailure> errors) {
        this.xsiValidationErrors = errors;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        block41: {
            this.locationStack.push(location.saveLocation());
            SchemaType xsiType = this.getValidationContext().getXSIType();
            if (this.isNilled) {
                properties |= 0x10;
            }
            PipelineConfiguration pipe = this.getPipelineConfiguration();
            try {
                int fp = elemName.obtainFingerprint(this.getNamePool());
                if (this.stack.isEmpty()) {
                    ElementDecl element;
                    ConstraintChecker constraintChecker;
                    ContentValidator initial;
                    if (this.initialValidator != null && xsiType == null) {
                        initial = this.initialValidator;
                    } else {
                        ElementDecl decl;
                        if (this.topLevelElement != null && !this.topLevelElement.equals(elemName)) {
                            String actual;
                            String required = Err.wrap(this.topLevelElement.getDisplayName(), 1);
                            if (required.equals(actual = Err.wrap(elemName.getDisplayName(), 1))) {
                                required = this.topLevelElement.getStructuredQName().getEQName();
                                actual = elemName.getStructuredQName().getEQName();
                            }
                            ValidationFailure ve = new ValidationFailure("Top-level element name is " + actual + ", required name is " + required);
                            this.reportValidationError(ve, false, location);
                        }
                        Receiver initialReceiver = this.getNextReceiver();
                        ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>(1);
                        if (xsiType != null) {
                            SchemaType type;
                            if (initialReceiver instanceof EmptyContentValidator || initialReceiver instanceof LaxValidator) {
                                initial = ContentValidator.makeValidatorForType(null, xsiType, pipe, this.outputReceiver, failures);
                            } else if (initialReceiver instanceof SimpleContentValidator) {
                                type = ((SimpleContentValidator)initialReceiver).getSchemaType();
                                try {
                                    this.getConfiguration().checkTypeDerivationIsOK(xsiType, type, 0);
                                }
                                catch (SchemaException e) {
                                    throw new XPathException(e);
                                }
                                ((SimpleContentValidator)initialReceiver).setSchemaType(xsiType);
                                initial = (ContentValidator)this.getNextReceiver();
                            } else if (initialReceiver instanceof ComplexContentValidator) {
                                type = ((ComplexContentValidator)initialReceiver).getSchemaType();
                                try {
                                    this.getConfiguration().checkTypeDerivationIsOK(xsiType, type, 0);
                                }
                                catch (SchemaException e) {
                                    throw new XPathException(e);
                                }
                                ((ComplexContentValidator)initialReceiver).setSchemaType((UserComplexType)xsiType);
                                initial = (ContentValidator)this.getNextReceiver();
                            } else {
                                decl = (ElementDecl)this.getConfiguration().getElementDeclaration(fp);
                                initial = ContentValidator.makeValidator(decl, elemName.getStructuredQName(), location, this.getValidationContext(), xsiType, this.initialValidationMode, pipe, this.outputReceiver, (List<ValidationFailure>)failures);
                            }
                        } else if (initialReceiver instanceof ContentValidator) {
                            initial = (ContentValidator)this.getNextReceiver();
                        } else if (this.initialType != null) {
                            initial = ContentValidator.makeValidatorForType(null, this.initialType, pipe, this.outputReceiver, failures);
                        } else {
                            decl = (ElementDecl)this.getConfiguration().getElementDeclaration(fp);
                            initial = ContentValidator.makeValidator(decl, elemName.getStructuredQName(), location, this.getValidationContext(), null, this.initialValidationMode, pipe, this.outputReceiver, (List<ValidationFailure>)failures);
                            if (decl != null && !decl.isNillable() && attributes.get(NamespaceUri.SCHEMA_INSTANCE, "nil") != null) {
                                String message = "The element is not nillable, so xsi:nil must not be present";
                                ValidationFailure ve = new ValidationFailure(message);
                                ve.setConstraintReference(1, "cvc-elt", "3.1");
                                this.xsiValidationErrors.add(ve);
                            }
                        }
                        if (!failures.isEmpty()) {
                            this.reportValidationError((ValidationFailure)failures.get(0), false, location);
                            initial = new LaxValidator(this.getNextReceiver());
                        }
                        assert (initial != null);
                        initial.setValidationContext(this.getValidationContext());
                    }
                    SchemaType annotation = initial.getAnnotation();
                    initial.setConstraintChecker(this.getConstraintChecker());
                    initial.setNamespaceResolver(namespaces);
                    initial.setNilled(this.isNilled);
                    if (!(initial instanceof SkipValidator) && !this.xsiValidationErrors.isEmpty()) {
                        for (ValidationFailure err : this.xsiValidationErrors) {
                            this.reportValidationError(err, false, location);
                        }
                    }
                    SchemaType initialSchemaType = initial.getSchemaType();
                    ArrayList<NamespaceBinding> additionalNamespaces = new ArrayList<NamespaceBinding>();
                    AttributeMap validatedAttributes = initial.validateAttributes(attributes, additionalNamespaces);
                    for (NamespaceBinding ns : additionalNamespaces) {
                        namespaces = namespaces.put(ns.getPrefix(), ns.getNamespaceUri());
                    }
                    if (initial instanceof SimpleContentValidator && initialSchemaType.isIdType()) {
                        pipe.getErrorReporter().report(new XmlProcessingIncident("During validation, using an ID element at the outermost level has no effect", "SXWN9048").asWarning());
                    }
                    if ((constraintChecker = this.getConstraintChecker()) != null && (element = initial.getElementDeclaration()) != null) {
                        constraintChecker.setElementDeclaration(element);
                    }
                    this.outputReceiver.startElement(elemName, annotation, validatedAttributes, namespaces, location, properties);
                    if (initialSchemaType instanceof UserComplexType && ((UserComplexType)initialSchemaType).hasAssertions()) {
                        this.prepareForAssertions(elemName, initialSchemaType, validatedAttributes, namespaces, location, properties, pipe);
                    }
                    this.stack.push(initial);
                } else {
                    SchemaType type;
                    ContentValidator v0 = this.stack.peek();
                    v0.startElement(elemName, typeCode, attributes, namespaces, location, properties);
                    ContentValidator v1 = v0.getChildValidator();
                    v1.setValidationContext(this.getValidationContext());
                    v1.setUnderlyingReceiver(this.outputReceiver);
                    v1.setNamespaceResolver(namespaces);
                    if (this.statistics != null) {
                        this.incrementStatistics(v1.getElementDeclaration());
                        this.incrementStatistics(v1.getSchemaType());
                    }
                    this.setUnderlyingReceiver(v1);
                    this.stack.push(v1);
                    if (!(v1 instanceof SkipValidator) && !this.xsiValidationErrors.isEmpty()) {
                        for (ValidationFailure err : this.xsiValidationErrors) {
                            this.reportValidationError(err, false, location);
                        }
                    }
                    if ((type = v1.getSchemaType()) instanceof UserComplexType && ((UserComplexType)type).hasAssertions()) {
                        ArrayList<NamespaceBinding> additionalNamespaces = new ArrayList<NamespaceBinding>();
                        AttributeMap validatedAtts = v1.validateAttributes(attributes, additionalNamespaces);
                        for (NamespaceBinding ns : additionalNamespaces) {
                            namespaces = namespaces.put(ns.getPrefix(), ns.getNamespaceUri());
                        }
                        this.prepareForAssertions(elemName, type, validatedAtts, namespaces, location, properties, pipe);
                    }
                }
                if (this.builder != null) {
                    ++this.builderDepth;
                }
            }
            catch (ValidationException ve) {
                if (!ve.hasBeenReported()) {
                    this.reportValidationError(ve.getValidationFailure(), true, location);
                    ve.setHasBeenReported(true);
                }
                if (pipe.isRecoverFromValidationErrors()) break block41;
                throw ve;
            }
        }
    }

    private void prepareForAssertions(NodeName elemName, SchemaType type, AttributeMap validatedAttributes, NamespaceMap namespaces, Location location, int properties, PipelineConfiguration pipe) throws XPathException {
        Set<Assertion> assertions = ((UserComplexType)type).getAssertions();
        boolean buildTree = false;
        ElementImpl stub = null;
        for (Assertion a : assertions) {
            Object context;
            Controller controller;
            if (a.getSweep() == Sweep.MOTIONLESS) {
                boolean ok;
                if (stub == null) {
                    LinkedTreeBuilder stubBuilder = new LinkedTreeBuilder(pipe, Durability.TEMPORARY);
                    stubBuilder.open();
                    stubBuilder.startElement(elemName, Untyped.INSTANCE, validatedAttributes, namespaces, location, properties);
                    stubBuilder.endElement();
                    stubBuilder.close();
                    stub = (ElementImpl)stubBuilder.getCurrentRoot();
                }
                controller = this.getValidationContext().getController();
                context = a.getCondition().createDynamicContext(controller, stub);
                try {
                    ok = a.getCondition().effectiveBooleanValue((XPathDynamicContext)context);
                }
                catch (XPathException err) {
                    ok = false;
                }
                if (ok) continue;
                String message = "Element " + elemName + " does not satisfy assertion";
                message = a.getMessage() != null ? message + ". " + a.getMessage() : message + " " + Whitespace.collapseWhitespace(StringView.of(a.getConditionText()).tidy());
                ValidationFailure error = new ValidationFailure(message);
                error.setLocator(location);
                error.setConstraintReference(1, "sec-cvc-assertion", "0");
                this.reportValidationError(error, true, location);
                continue;
            }
            if (a.getSweep() == Sweep.CONSUMING && this.builder == null) {
                controller = this.getValidationContext().getController();
                context = controller.newXPathContext();
                context.setCurrentIterator(new ManualIterator(this.watchManager.getCurrentNode()));
                Inversion inversion = Inversion.invertExpression(a.getCondition().getInternalExpression(), false);
                AssertionResultHandler assertionResultHandler = new AssertionResultHandler(this, a, elemName, (XPathContext)context);
                assertionResultHandler.setPipelineConfiguration(pipe);
                BooleanFnFeed.Positive booleanCapture = new BooleanFnFeed.Positive(this.watchManager, null, assertionResultHandler, (XPathContext)context);
                Trigger assertionWatch = inversion.getWatch(this.watchManager, booleanCapture, (XPathContext)context);
                this.watchManager.addWatch(assertionWatch, true);
                this.watchManager.restartElement(assertionWatch);
                continue;
            }
            buildTree = true;
        }
        if (buildTree && this.builder == null) {
            this.builder = new TinyBuilder(pipe);
            this.builder.setStatistics(pipe.getConfiguration().getTreeStatistics().ASSERTION_TREE_STATISTICS);
            this.builder.setSystemId(location.getSystemId());
            this.builder.setBaseURI(location.getSystemId());
            this.builder.open();
            this.builder.startElement(elemName, Untyped.INSTANCE, validatedAttributes, namespaces, location, properties);
            this.builderDepth = 0;
            this.assertionBuilder.activate(this.builder);
        }
    }

    public void setInitialValidator(ContentValidator validator) {
        this.initialValidator = validator;
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        ContentValidator v0 = this.stack.peek();
        v0.characters(chars, locationId, properties);
    }

    @Override
    public void endElement() throws XPathException {
        Location location = this.locationStack.pop();
        ContentValidator v0 = this.stack.pop();
        v0.endElement();
        if (this.builder != null) {
            --this.builderDepth;
            SchemaType type = v0.getSchemaType();
            if (type instanceof UserComplexType && ((UserComplexType)type).hasAssertions()) {
                NodeInfo root = this.builder.getLastCompletedElement();
                if (this.builderDepth != 0) {
                    root = VirtualCopy.makeVirtualCopy(root);
                }
                this.testAssertions(root, (UserComplexType)type, location);
            }
            if (this.builderDepth == 0) {
                this.builder.close();
                this.assertionBuilder.deactivate();
                this.builder = null;
            }
        }
        if (!this.stack.isEmpty()) {
            this.setUnderlyingReceiver(this.stack.peek());
        } else {
            this.setUnderlyingReceiver(this.outputReceiver);
            this.reportIfInvalid();
        }
    }

    @Override
    public void endDocument() throws XPathException {
        try {
            this.nextReceiver.endDocument();
            this.reportIfInvalid();
            if (this.statistics != null) {
                this.getPipelineConfiguration().getParseOptions().getValidationStatisticsRecipient().notifyValidationStatistics(this.statistics);
            }
        }
        catch (SaxonApiException e) {
            throw XPathException.makeXPathException(e);
        }
    }

    private void testAssertions(NodeInfo root, UserComplexType type, Location location) throws XPathException {
        Set<Assertion> assertions = type.getAssertions();
        AtomicSequence value = null;
        if (type.isSimpleContent()) {
            UnicodeString s = root.getUnicodeStringValue();
            SimpleType st = type.getSimpleContentType();
            NamespaceMap ns = st.isNamespaceSensitive() ? root.getAllNamespaces() : null;
            value = st.getTypedValue(s, ns, this.getConfiguration().getConversionRules());
        }
        for (Assertion assertion : assertions) {
            if (assertion.getSweep() == Sweep.MOTIONLESS) continue;
            this.testAssertion(assertion, root, value, location);
        }
    }

    private void testAssertion(Assertion assertion, NodeInfo root, AtomicSequence value, Location location) throws XPathException {
        List<NodeInfo> offendingItems = assertion.testComplex(root, value, this.getValidationContext());
        if (!offendingItems.isEmpty()) {
            String message = "Element " + root.getDisplayName() + " does not satisfy assertion";
            message = assertion.getMessage() != null ? message + ". " + assertion.getMessage() : message + " " + Whitespace.collapseWhitespace(StringView.tidy(assertion.getConditionText()));
            ValidationFailure error = new ValidationFailure(message);
            error.setLocator(location);
            error.setConstraintReference(1, "sec-cvc-assertion", "0");
            for (NodeInfo item : offendingItems) {
                if (item == root) continue;
                error.addOffendingNode(item);
            }
            this.reportValidationError(error, true, location);
        }
    }

    private void incrementStatistics(SchemaComponent component) {
        this.statistics.merge(component, 1, (a, b) -> a + b);
    }

    public void setKeepStatistics(boolean keep) {
        this.statistics = keep ? new HashMap<SchemaComponent, Integer>() : null;
    }

    public Map<SchemaComponent, Integer> getCoverageStatistics() {
        return this.statistics;
    }

    private static class AssertionResultHandler
    extends SinkFeed {
        private final ValidationStack validationStack;
        private final Assertion assertion;
        private final NodeName elementName;

        public AssertionResultHandler(ValidationStack validationStack, Assertion assertion, NodeName elementName, XPathContext context) {
            super(context);
            this.validationStack = validationStack;
            this.assertion = assertion;
            this.elementName = elementName;
        }

        @Override
        public void append(Item item) throws XPathException {
            if (item instanceof BooleanValue && !((BooleanValue)item).getBooleanValue()) {
                String message = "Element " + this.elementName + " does not satisfy assertion";
                message = this.assertion.getMessage() != null ? message + ". " + this.assertion.getMessage() : message + " " + Whitespace.collapseWhitespace(StringView.of(this.assertion.getConditionText()).tidy());
                ValidationFailure error = new ValidationFailure(message);
                error.setLocator(this.assertion);
                error.setConstraintReference(1, "sec-cvc-assertion", "0");
                this.validationStack.reportValidationError(error, true, this.assertion);
            }
        }

        @Override
        public boolean handlesAppend() {
            return true;
        }
    }
}

