/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.validate.ConstraintChecker;
import com.saxonica.ee.validate.ContentValidator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;

public class SkipValidator
extends ContentValidator {
    private boolean stripIdProperty = false;

    public SkipValidator(Receiver next) {
        super(next);
        this.setPipelineConfiguration(next.getPipelineConfiguration());
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.stripIdProperty = pipe.getHostLanguage() == HostLanguage.XQUERY;
    }

    @Override
    public SchemaType getSchemaType() {
        return null;
    }

    @Override
    protected ConstraintChecker getConstraintChecker() {
        return null;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        AttributeMap atts2;
        int p2 = properties;
        if (!this.stripIdProperty && type != Untyped.getInstance() && !ReceiverOption.contains(properties, 8192)) {
            if (type.isIdType()) {
                p2 |= 0x800;
            } else if (type.isIdRefType()) {
                p2 |= 0x1000;
            }
            p2 |= 0x2000;
        }
        p2 &= 0xFFFFFFEF;
        try {
            atts2 = attributes.apply(att -> {
                int prop = att.getProperties();
                if (!this.stripIdProperty && !ReceiverOption.contains(properties, 8192)) {
                    SimpleType attType = att.getType();
                    if (attType.isIdType()) {
                        prop |= 0x800;
                    } else if (attType.isIdRefType()) {
                        prop |= 0x1000;
                    }
                    prop |= 0x2000;
                }
                if (this.stripIdProperty) {
                    prop &= 0xFFFFE7FF;
                    prop |= 0x2000;
                }
                return new AttributeInfo(att.getNodeName(), BuiltInAtomicType.UNTYPED_ATOMIC, att.getValue(), att.getLocation(), prop);
            });
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
        this.getNextReceiver().startElement(elemName, Untyped.getInstance(), atts2, namespaces, location, p2);
    }

    @Override
    protected ContentValidator getChildValidator() {
        return this;
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (item instanceof NodeInfo) {
            this.decompose(item, locationId, copyNamespaces);
        } else {
            this.nextReceiver.append(item, locationId, copyNamespaces);
        }
    }
}

