/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SchemaType;

public class InSituValidator {
    private final MutableNodeInfo[] nodeBuffer = new MutableNodeInfo[16];
    private final MutableNodeInfo root;
    private final int validationMode;

    public InSituValidator(MutableNodeInfo root, int validationMode) {
        this.root = root;
        this.validationMode = validationMode;
    }

    public void validate() throws XPathException {
        Receiver validator;
        Configuration config = this.root.getConfiguration();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        pipe.setHostLanguage(HostLanguage.XML_SCHEMA);
        NodeUpdater endPoint = new NodeUpdater(this.nodeBuffer, pipe);
        ParseOptions options = new ParseOptions().withSchemaValidationMode(this.validationMode).withSpaceStrippingRule(null);
        if (this.root.getNodeKind() == 9) {
            validator = config.getDocumentValidator(endPoint, this.root.getSystemId(), options, null);
        } else {
            options = options.withTopLevelElement(NameOfNode.makeName(this.root).getStructuredQName());
            validator = config.getElementValidator(endPoint, options, Loc.NONE);
        }
        NodeCounter nodeCounter = new NodeCounter(this.nodeBuffer);
        pipe.setCopyInformee(CSharp.methodRef(nodeCounter::notifyElementNode));
        this.root.copy(validator, 2, Loc.NONE);
    }

    private static class NodeUpdater
    extends ProxyReceiver {
        private MutableNodeInfo currentElement;
        final MutableNodeInfo[] nodeBuffer;

        public NodeUpdater(MutableNodeInfo[] nodeBuffer, PipelineConfiguration pipe) {
            super(new Sink(pipe));
            this.nodeBuffer = nodeBuffer;
        }

        @Override
        public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
            MutableNodeInfo node = this.nodeBuffer[location.getLineNumber() % 16];
            node.setTypeAnnotation(type);
            this.currentElement = node;
            node.setAttributes(attributes);
        }

        @Override
        public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
            if (ReceiverOption.contains(properties, 8)) {
                Orphan child = new Orphan(this.getConfiguration());
                child.setNodeKind((short)3);
                child.setStringValue(chars.tidy());
                this.currentElement.insertChildren(new NodeInfo[]{child}, true, true);
            }
            super.characters(chars, locationId, properties);
        }

        @Override
        public boolean usesTypeAnnotations() {
            return true;
        }
    }

    private static class NodeCounter
    implements CopyInformee {
        int counter = 0;
        final MutableNodeInfo[] nodeBuffer;

        public NodeCounter(MutableNodeInfo[] nodeBuffer) {
            this.nodeBuffer = nodeBuffer;
        }

        @Override
        public Location notifyElementNode(NodeInfo element) {
            this.nodeBuffer[this.counter % 16] = (MutableNodeInfo)element;
            return new Loc(element.getSystemId(), this.counter++, 998877);
        }
    }
}

