/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.EnumerationFacetSet;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.validate.AbstractReceiver;
import com.saxonica.ee.validate.SelectorWatch;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.StringValue;

public class FieldChecker
extends AbstractReceiver {
    private final SelectorWatch parentWatch;
    private NamespaceResolver namespaceResolver;
    private final AtomicSequence[] currentRow;
    private final int column;
    private final boolean matchElements;
    private boolean active = false;
    private boolean nillableElement = false;
    private NodeName elementName;
    private SchemaType elementType;
    private final UnicodeBuilder buffer = new UnicodeBuilder();
    private Location textLocationId = null;
    int depth = 0;

    public FieldChecker(SelectorWatch parentWatch, Pattern selection, AtomicSequence[] currentRow, int column) {
        this.parentWatch = parentWatch;
        this.currentRow = currentRow;
        this.column = column;
        this.matchElements = selection.getUType().overlaps(UType.ELEMENT);
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.nillableElement = false;
        if (this.matchElements) {
            if (this.depth > 0) {
                ValidationFailure ve = new ValidationFailure("An element participating as a field in a constraint cannot have child elements");
                ve.setConstraintReference(1, "cvc-identity-constraint", "3");
                throw ve.makeException();
            }
            this.elementType = typeCode;
            this.elementName = nameCode;
            this.active = true;
            this.buffer.clear();
        }
        ++this.depth;
    }

    public void notifySelectedAttribute(FleetingNode attribute, Location locationId) throws XPathException {
        Configuration config = this.getConfiguration();
        ConversionRules rules = config.getConversionRules();
        SimpleType type = (SimpleType)attribute.getSchemaType();
        UnicodeString value = attribute.getUnicodeStringValue();
        if (!type.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            AtomicSequence val;
            try {
                if (type.isNamespaceSensitive()) {
                    try {
                        val = type.getTypedValue(value, this.namespaceResolver, rules);
                    }
                    catch (ValidationException e) {
                        val = null;
                    }
                } else if (type.isAtomicType()) {
                    EnumerationFacetSet en;
                    AtomicType prim = ((AtomicType)type).getPrimitiveItemType();
                    StringConverter converter = prim.getStringConverter(this.getConfiguration().getConversionRules());
                    ConversionResult result = converter.convertString(value);
                    val = result instanceof ValidationFailure ? null : result.asAtomic();
                    if (type instanceof UserAtomicType && (en = (EnumerationFacetSet)((UserAtomicType)type).getFacet(EnumerationFacetSet.class)) != null) {
                        val = en.getSharedInstance(val);
                    }
                } else {
                    try {
                        val = type.getTypedValue(value, this.namespaceResolver, rules);
                    }
                    catch (ValidationException e) {
                        val = null;
                    }
                }
            }
            catch (XPathException e) {
                throw new ValidationException(e);
            }
            if (val != null) {
                this.parentWatch.addFieldValue(this.currentRow, this.column, val, false, locationId);
            }
        }
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (this.active && this.matchElements && this.depth == 1) {
            this.buffer.accept(chars);
        }
        this.nillableElement = ReceiverOption.contains(properties, 512);
        this.textLocationId = locationId;
    }

    @Override
    public void endElement() throws XPathException {
        if (this.active && this.matchElements && this.depth == 1) {
            AtomicSequence val;
            SchemaType eltype = this.elementType;
            UnicodeString fieldVal = this.buffer.toUnicodeString();
            if (eltype == null || eltype instanceof AnySimpleType) {
                val = StringValue.makeUntypedAtomic(fieldVal);
            } else {
                SchemaType contentType = eltype;
                if (eltype instanceof ComplexType) {
                    if (((ComplexType)eltype).isSimpleContent()) {
                        contentType = ((ComplexType)eltype).getSimpleContentType();
                    } else {
                        ValidationFailure err = new ValidationFailure("The value of a field participating in an identity constraint must have a simple type, or a complex type with simple content. Element " + this.elementName.getDisplayName() + " has type " + eltype.getDescription());
                        err.setConstraintReference(1, "cvc-identity-constraint", "3");
                        throw err.makeException();
                    }
                }
                assert (contentType != null);
                if (contentType.getFingerprint() == 513) {
                    val = StringValue.makeStringValue(this.buffer.toString());
                } else if (((SimpleType)contentType).isNamespaceSensitive()) {
                    try {
                        val = ((SimpleType)contentType).getTypedValue(fieldVal, this.namespaceResolver, this.getConfiguration().getConversionRules());
                    }
                    catch (ValidationException e) {
                        val = null;
                    }
                } else if (contentType.isAtomicType()) {
                    EnumerationFacetSet en;
                    AtomicType prim = ((AtomicType)contentType).getPrimitiveItemType();
                    StringConverter converter = prim.getStringConverter(this.getConfiguration().getConversionRules());
                    ConversionResult result = converter.convertString(fieldVal);
                    val = result instanceof ValidationFailure ? null : result.asAtomic();
                    if (contentType instanceof UserAtomicType && (en = (EnumerationFacetSet)((UserAtomicType)contentType).getFacet(EnumerationFacetSet.class)) != null) {
                        val = en.getSharedInstance(val);
                    }
                } else {
                    try {
                        val = ((SimpleType)contentType).getTypedValue(fieldVal, this.namespaceResolver, this.getConfiguration().getConversionRules());
                    }
                    catch (ValidationException e) {
                        val = null;
                    }
                }
            }
            if (val != null) {
                this.parentWatch.addFieldValue(this.currentRow, this.column, val, this.nillableElement, this.textLocationId);
            }
        }
        --this.depth;
    }

    @Override
    public void close() {
        this.active = false;
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }
}

