/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserUnionType;
import com.saxonica.ee.validate.ValidatingFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class EntityValidator
extends ValidatingFilter {
    private final Set<String> declaredEntities = new HashSet<String>(10);
    private EntityChecker currentElementChecker = null;
    private final UnicodeBuilder buffer = new UnicodeBuilder();
    private Location textLocationId = Loc.NONE;
    private final Map<SchemaType, EntityChecker> checkerMap = new HashMap<SchemaType, EntityChecker>(10);
    private static final EntityChecker SimpleEntityChecker = (validator, value, locationId) -> {
        String id = Whitespace.trim(value).toString();
        validator.processEntityRef(id, locationId);
    };
    private static final EntityChecker EntityListChecker = (validator, value, locationId) -> {
        String ids = value.toString();
        StringTokenizer tok = new StringTokenizer(ids, " \t\n\r", false);
        while (tok.hasMoreTokens()) {
            String id = tok.nextToken();
            validator.processEntityRef(id, locationId);
        }
    };
    private static final EntityChecker NonEntityChecker = (validator, value, locationId) -> {};

    public EntityValidator(Receiver next) {
        super(next);
    }

    @Override
    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
        this.declaredEntities.add(name);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.currentElementChecker = this.checkerMap.get(type);
        if (this.currentElementChecker == null) {
            this.currentElementChecker = this.allocateChecker(type);
            this.checkerMap.put(type, this.currentElementChecker);
        }
        if (this.currentElementChecker == NonEntityChecker) {
            this.currentElementChecker = null;
        }
        for (AttributeInfo att : attributes) {
            SimpleType typeCode = att.getType();
            EntityChecker checker = this.checkerMap.get(typeCode);
            if (checker == null) {
                checker = this.allocateChecker(typeCode);
                this.checkerMap.put(typeCode, checker);
            }
            checker.checkValue(this, StringView.of(att.getValue()).tidy(), att.getLocation());
        }
        this.nextReceiver.startElement(elemName, type, attributes, namespaces, location, properties);
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (this.currentElementChecker != null) {
            this.buffer.accept(chars);
        }
        this.nextReceiver.characters(chars, locationId, properties);
        this.textLocationId = locationId.saveLocation();
    }

    @Override
    public void endElement() throws XPathException {
        if (this.currentElementChecker != null) {
            this.currentElementChecker.checkValue(this, this.buffer.toUnicodeString(), this.textLocationId);
        }
        this.buffer.clear();
        this.currentElementChecker = null;
        this.nextReceiver.endElement();
    }

    private EntityChecker allocateChecker(SchemaType type) throws MissingComponentException {
        int fingerprint = type.getFingerprint();
        switch (fingerprint) {
            case 563: {
                return SimpleEntityChecker;
            }
            case 564: {
                return EntityListChecker;
            }
        }
        if (fingerprint < 1023) {
            return NonEntityChecker;
        }
        Configuration config = this.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        if (type.isComplexType()) {
            return NonEntityChecker;
        }
        SimpleType stype = (SimpleType)type;
        if (type.isAtomicType()) {
            if (th.isSubType((AtomicType)type, BuiltInAtomicType.ENTITY)) {
                return SimpleEntityChecker;
            }
            return NonEntityChecker;
        }
        if (stype.isListType()) {
            if (EntityValidator.isEntityType(stype, th)) {
                return EntityListChecker;
            }
            return NonEntityChecker;
        }
        if (EntityValidator.isEntityType(stype, th)) {
            return this.getUnionChecker(stype);
        }
        return NonEntityChecker;
    }

    private static boolean isEntityType(SimpleType type, TypeHierarchy th) throws MissingComponentException {
        if (type.isAtomicType()) {
            return th.isSubType((AtomicType)type, BuiltInAtomicType.ENTITY);
        }
        if (type.isListType()) {
            return EntityValidator.isEntityType(((ListType)type).getItemType(), th);
        }
        if (type.isUnionType()) {
            UserUnionType union = (UserUnionType)type;
            for (TypeReference ref : union.getMemberTypeReferences()) {
                SimpleType mem = (SimpleType)ref.getTarget();
                if (!EntityValidator.isEntityType(mem, th)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    private void processEntityRef(String eref, Location locationId) throws XPathException {
        if (!this.declaredEntities.contains(eref)) {
            ValidationFailure ve = new ValidationFailure("Value '" + eref + "' is not declared in the DTD as an unparsed entity name");
            ve.setConstraintReference(1, "cvc-simple-type", "3");
            this.reportValidationError(ve, false, locationId);
        }
    }

    private EntityChecker getUnionChecker(SimpleType type) {
        return (validator, value, locationId) -> {
            AtomicValue val;
            Configuration config = this.getConfiguration();
            TypeHierarchy th = config.getTypeHierarchy();
            AtomicIterator iter = type.getTypedValue(value, DummyNamespaceResolver.getInstance(), config.getConversionRules()).iterate();
            while ((val = (AtomicValue)iter.next()) != null) {
                AtomicType itemType = val.getItemType();
                if (!EntityValidator.isEntityType(itemType, th)) continue;
                validator.processEntityRef(val.getStringValue(), locationId);
            }
        };
    }

    @FunctionalInterface
    private static interface EntityChecker {
        public void checkValue(EntityValidator var1, UnicodeString var2, Location var3) throws XPathException;
    }
}

