/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import java.util.Stack;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.util.IndexedStack;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public class AttributeInheritor
extends ProxyReceiver {
    private AttributeMap bufferedAttributes;
    private final IndexedStack<AttributeMap> inheritedAttributeStack = new IndexedStack();
    private final Stack<NodeName> elementNameStack = new Stack();
    private final Stack<NamespaceMap> namespaceMapStack = new Stack();
    private boolean empty = true;
    private NodeInfo elementNode;

    public AttributeInheritor(Receiver next) {
        super(next);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.bufferedAttributes = attributes;
        this.inheritedAttributeStack.push(EmptyAttributeMap.getInstance());
        this.elementNameStack.push(elemName);
        this.namespaceMapStack.push(namespaces);
        this.elementNode = null;
        super.startElement(elemName, type, attributes, namespaces, location, properties);
    }

    @Override
    public void endElement() throws XPathException {
        this.inheritedAttributeStack.pop();
        this.elementNameStack.pop();
        this.namespaceMapStack.pop();
        super.endElement();
    }

    public void notifyInheritableAttribute(NodeName nameCode, String value, Location location, int properties) {
        AttributeMap atts = this.inheritedAttributeStack.pop();
        atts = atts.put(new AttributeInfo(nameCode, BuiltInAtomicType.UNTYPED_ATOMIC, value, location, properties));
        this.inheritedAttributeStack.push(atts);
        this.empty = false;
    }

    public AttributeMap gatherInheritedAttributes(AttributeMap initialAtts) {
        for (int i = this.inheritedAttributeStack.size() - 1; i >= 0; --i) {
            AttributeMap ac = this.inheritedAttributeStack.get(i);
            for (AttributeInfo att : ac) {
                NodeName nc = att.getNodeName();
                if (initialAtts.get(nc) != null) continue;
                AttributeInfo newAtt = new AttributeInfo(nc, BuiltInAtomicType.UNTYPED_ATOMIC, att.getValue(), att.getLocation(), att.getProperties());
                initialAtts = initialAtts.put(newAtt);
            }
        }
        return initialAtts;
    }

    public boolean hasInheritedAttributes() {
        return !this.empty;
    }

    NodeInfo createSkeletonElementNode() throws XPathException {
        if (this.elementNode == null) {
            int len = this.bufferedAttributes.size();
            TinyBuilder builder = new TinyBuilder(this.getPipelineConfiguration());
            builder.setSystemId(this.systemId);
            Statistics stats = new Statistics(2, len + 2, 20, 16);
            builder.setStatistics(stats);
            builder.open();
            AttributeMap allAttributes = this.bufferedAttributes;
            if (this.hasInheritedAttributes()) {
                allAttributes = this.gatherInheritedAttributes(allAttributes);
            }
            builder.startElement(this.elementNameStack.peek(), Untyped.getInstance(), allAttributes, this.namespaceMapStack.peek(), Loc.NONE, 0);
            builder.endElement();
            this.elementNode = builder.getCurrentRoot();
        }
        return this.elementNode;
    }
}

