/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.ItemFeed;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.AbstractUniStringConsumer;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;

public class SimpleNodeConstructorFeed
extends ItemFeed {
    private UnicodeBuilder buffer = new UnicodeBuilder();
    private final boolean disableOutputEscaping;
    private boolean isSimpleText;

    public SimpleNodeConstructorFeed(Expression expr, ItemFeed result, XPathContext context) {
        super(expr, result, context);
        this.disableOutputEscaping = expr instanceof ValueOf && ((ValueOf)expr).isDisableOutputEscaping();
        SimpleNodeConstructor constructor = (SimpleNodeConstructor)this.getExpression();
        int kind = constructor.getItemType().getPrimitiveType();
        if (kind == 3 && !this.disableOutputEscaping) {
            this.isSimpleText = true;
        }
    }

    @Override
    public void append(Item item) throws XPathException {
        if (!this.hasFailed()) {
            if (this.isSimpleText) {
                try {
                    this.getNextOutputter().characters(item.getUnicodeStringValue(), Loc.NONE, 0);
                }
                catch (XPathException e) {
                    this.dynamicError(e);
                }
            } else {
                this.buffer.accept(item.getUnicodeStringValue());
            }
        }
    }

    @Override
    public UniStringConsumer getStringReceiver(boolean asTextNode, final Location loc) {
        if (this.isSimpleText) {
            return new AbstractUniStringConsumer(){

                @Override
                public UniStringConsumer accept(UnicodeString chars) throws XPathException {
                    try {
                        SimpleNodeConstructorFeed.this.getNextOutputter().characters(chars, loc, 0);
                    }
                    catch (XPathException e) {
                        SimpleNodeConstructorFeed.this.dynamicError(e);
                    }
                    return this;
                }
            };
        }
        return super.getStringReceiver(asTextNode, loc);
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            SimpleNodeConstructor constructor = (SimpleNodeConstructor)this.getExpression();
            int kind = constructor.getItemType().getPrimitiveType();
            switch (kind) {
                case 2: {
                    try {
                        this.getNextOutputter().attribute(constructor.evaluateNodeName(this.getContext()), BuiltInAtomicType.UNTYPED_ATOMIC, this.buffer.toString(), Loc.NONE, 0);
                    }
                    catch (XPathException e) {
                        this.dynamicError(e);
                    }
                    break;
                }
                case 3: {
                    if (this.isSimpleText) break;
                    try {
                        int options = this.disableOutputEscaping ? 1 : 0;
                        this.getNextOutputter().characters(this.buffer.toUnicodeString(), Loc.NONE, options);
                    }
                    catch (XPathException e) {
                        this.dynamicError(e);
                    }
                    break;
                }
                case 8: {
                    try {
                        this.getNextOutputter().comment(this.buffer.toUnicodeString(), Loc.NONE, 0);
                    }
                    catch (XPathException e) {
                        this.dynamicError(e);
                    }
                    break;
                }
                case 7: {
                    try {
                        this.getNextOutputter().processingInstruction(constructor.evaluateNodeName(this.getContext()).getLocalPart(), this.buffer.toUnicodeString(), Loc.NONE, 0);
                    }
                    catch (XPathException e) {
                        this.dynamicError(e);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown node kind " + kind);
                }
            }
            this.buffer.clear();
            super.close();
        }
    }
}

