/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;

public class MotionlessFeed
extends ItemFeed {
    private final Expression expression;
    private boolean selected;

    public MotionlessFeed(Expression expression, ItemFeed result, XPathContext context) {
        super(expression, result, context);
        this.expression = expression;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        Item item;
        SequenceIterator iter = this.expression.iterate(this.getContext());
        while ((item = iter.next()) != null) {
            if (item instanceof FleetingParentNode) {
                this.selected = true;
                return this.getResultFeed().startSelectedParentNode((FleetingParentNode)item, locationId);
            }
            this.getResultFeed().append(item);
        }
        return null;
    }

    @Override
    public void append(Item item) throws XPathException {
        SequenceIterator iter = this.expression.iterate(this.getContext());
        MotionlessFeed.processItems(iter, this.getNextOutputter());
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (this.selected) {
            this.getResultFeed().endSelectedParentNode(locationId);
            this.selected = false;
        }
    }
}

