/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.GroundedItemFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;

public class ItemMappingFeed
extends GroundedItemFeed {
    private final ItemMappingFunction function;

    public ItemMappingFeed(Expression expr, ItemFeed result, XPathContext context, ItemMappingFunction function) {
        super(expr, result, context);
        this.function = function;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (!this.hasFailed()) {
            Item mapped = null;
            try {
                mapped = this.function.mapItem(node);
            }
            catch (XPathException err) {
                this.dynamicError(err);
            }
            if (mapped != null) {
                if (mapped instanceof FleetingParentNode) {
                    return this.getResultFeed().startSelectedParentNode((FleetingParentNode)mapped, locationId);
                }
                throw new AssertionError((Object)"Item mapping feed must map events to events");
            }
        }
        return null;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (!this.hasFailed()) {
            this.getResultFeed().endSelectedParentNode(locationId);
        }
    }

    @Override
    public void append(Item item) throws XPathException {
        if (!this.hasFailed()) {
            Item mapped = null;
            try {
                mapped = this.function.mapItem(item);
            }
            catch (XPathException err) {
                this.dynamicError(err);
            }
            if (mapped != null) {
                this.getResultFeed().append(mapped);
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            super.close();
        }
    }
}

