/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.adjunct.TryCatchAdjunct;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.ProxyOutputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;

public abstract class ItemFeed
extends ProxyOutputter {
    private Terminator terminator;
    private Expression expression;
    private final XPathContext context;
    private boolean failed = false;

    public ItemFeed(ItemFeed result, XPathContext context) {
        super(result);
        this.context = context;
    }

    public ItemFeed(Expression exp, ItemFeed result, XPathContext context) {
        super(result);
        this.expression = exp;
        this.context = context;
    }

    public ItemFeed(Outputter result, XPathContext context, boolean thisIsAnExceptionalCase) {
        super(result);
        this.context = context;
    }

    public static void processItems(SequenceIterator iter, Outputter result) throws XPathException {
        try {
            SequenceTool.supply(iter, result::append);
        }
        catch (UncheckedXPathException unxe) {
            XPathException xe = unxe.getXPathException();
            if (xe instanceof QuitParsingException) {
                throw xe;
            }
            if (result instanceof ItemFeed) {
                ((ItemFeed)result).dynamicError(xe);
            }
            throw xe;
        }
    }

    public void setExpression(Expression exp) {
        this.expression = exp;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setTerminator(Terminator terminator) {
        this.terminator = terminator;
    }

    public void setHasFailed() {
        this.failed = true;
    }

    public Terminator getTerminator() {
        return this.terminator;
    }

    public ItemFeed getResultFeed() {
        return (ItemFeed)this.getNextOutputter();
    }

    public XPathContext getContext() {
        return this.context;
    }

    public void open(Terminator terminator) throws XPathException {
        this.terminator = terminator;
        this.getResultFeed().open(terminator);
    }

    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        this.append(node);
        return null;
    }

    @Override
    public abstract void append(Item var1) throws XPathException;

    @Override
    public final void append(Item item, Location locationId, int properties) throws XPathException {
        this.append(item);
    }

    public void endSelectedParentNode(Location locationId) throws XPathException {
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.getNextOutputter().close();
            }
            catch (XPathException e) {
                if (this.expression != null) {
                    throw e.maybeWithLocation(this.expression.getLocation());
                }
                throw e;
            }
        }
    }

    public void dynamicError(XPathException error) throws XPathException {
        this.setHasFailed();
        if (this.expression != null) {
            error.maybeSetLocation(this.expression.getLocation());
        }
        ItemFeed next = this.getResultFeed();
        while (true) {
            if (next instanceof TryCatchAdjunct.TryCatchFeed) {
                next.dynamicError(error);
                return;
            }
            next.setHasFailed();
            Outputter result = next.getNextOutputter();
            if (!(result instanceof ItemFeed)) break;
            next = (ItemFeed)result;
        }
        if (error instanceof ValidationException) {
            XPathException xe = new XPathException(error);
            xe.setErrorCodeQName(error.getErrorCodeQName());
            throw xe;
        }
        throw error;
    }

    public boolean hasFailed() {
        return this.failed;
    }
}

