/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.GroundedItemFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;

public class FilteringFeed
extends GroundedItemFeed {
    private WatchManager watchManager;
    private final Filter filter;
    private int position;
    private final Stack<Boolean> matchStack = new Stack();
    private boolean terminated;
    private boolean closed;
    public static FilterLambda TransparentFilter = new FilterLambda((item, position) -> FilterResult.MATCHES);
    public static FilterLambda OpaqueFilter = new FilterLambda((item, position) -> FilterResult.DONE);

    public FilteringFeed(WatchManager watchManager, ItemFeed nextFeed, XPathContext context, Filter filter) {
        super(nextFeed, context);
        this.watchManager = watchManager;
        this.filter = filter;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        this.getResultFeed().open(terminator);
        this.position = 0;
        this.terminated = false;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (!this.terminated) {
            FilterResult match;
            this.matchStack.push((match = this.filter.matches(node, ++this.position)) == FilterResult.MATCHES);
            if (match == FilterResult.MATCHES) {
                return this.getResultFeed().startSelectedParentNode(node, locationId);
            }
            if (match == FilterResult.DONE && this.getTerminator() != null) {
                this.terminated = true;
                if (this.watchManager.allowsEarlyExit()) {
                    this.closed = true;
                    this.getNextOutputter().close();
                    this.getTerminator().terminate();
                }
            }
        }
        return null;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        boolean matches;
        if (!this.terminated && (matches = this.matchStack.pop().booleanValue())) {
            this.getResultFeed().endSelectedParentNode(locationId);
        }
    }

    @Override
    public void append(Item item) throws XPathException {
        if (!this.terminated && !this.hasFailed()) {
            try {
                FilterResult match = this.filter.matches(item, ++this.position);
                if (match == FilterResult.MATCHES) {
                    this.getNextOutputter().append(item);
                } else if (match == FilterResult.DONE && this.getTerminator() != null) {
                    this.terminated = true;
                    if (this.watchManager.allowsEarlyExit()) {
                        this.closed = true;
                        this.getNextOutputter().close();
                        this.getTerminator().terminate();
                    }
                }
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.terminated && !this.hasFailed() || !this.closed) {
            this.getNextOutputter().close();
        }
    }

    public static class FilterLambda
    implements Filter {
        private final FilterDelegate delegate;

        public FilterLambda(FilterDelegate delegate) {
            this.delegate = delegate;
        }

        @Override
        public FilterResult matches(Item item, int position) throws XPathException {
            return this.delegate.matches(item, position);
        }
    }

    @FunctionalInterface
    public static interface FilterDelegate {
        public FilterResult matches(Item var1, int var2) throws XPathException;
    }

    @FunctionalInterface
    public static interface Filter {
        public FilterResult matches(Item var1, int var2) throws XPathException;
    }

    public static enum FilterResult {
        SKIP,
        MATCHES,
        DONE;

    }
}

