/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.UType;

public class RootExpressionAdjunct
extends StreamingAdjunct {
    @Override
    public Pattern toStreamingPattern(Configuration config) {
        return new NodeTestPattern(NodeKindTest.DOCUMENT);
    }

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        Posture contextItemPosture = contextInfo.getContextItemPosture();
        if (contextItemPosture == Posture.GROUNDED) {
            return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
        }
        if (contextInfo.getItemType().getUType().equals(UType.DOCUMENT)) {
            return new PostureAndSweep(contextItemPosture, Sweep.MOTIONLESS);
        }
        if (reasons != null) {
            reasons.add("Expression " + this.getExpression().toShortString() + " is free-ranging");
        }
        return PostureAndSweep.CLIMBING_AND_MOTIONLESS;
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        throw new XPathException("Streaming is not supported for expression " + this.getExpression().toShortString()).withErrorCode("SXST0060").withLocation(this.getExpression().getLocation());
    }
}

