/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;

public abstract class InspectionAdjunct
extends StreamingAdjunct {
    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Operand consumer = null;
        for (Operand o : this.getExpression().operands()) {
            if (Streamability.getSweep(o.getChildExpression()) != Sweep.CONSUMING) continue;
            consumer = o;
            break;
        }
        if (consumer == null) {
            throw new XPathException("No consuming operand found");
        }
        Expression select = consumer.getChildExpression();
        if (Streamability.isIncrementalPosture(Streamability.getPosture(select))) {
            return this.getInspectionWatchMaker(this.getExpression(), select, forGrouping);
        }
        return null;
    }

    protected final WatchMaker getInspectionWatchMaker(Expression parent, Expression select, boolean forGrouping) throws XPathException {
        Pattern selection = Streamability.toStreamingPattern(select, this.getConfiguration());
        FeedMaker feedMaker = this.getFeedMaker(0);
        if (selection != null) {
            return (watchManager, out, context) -> {
                ItemFeed feed = feedMaker.makeItemFeed(watchManager, out, context);
                return new Trigger(selection, feed, context);
            };
        }
        StreamingAdjunct adjunct = StreamingAdjunct.makeStreamingAdjunct(this.getConfiguration(), select);
        WatchMaker selectWM = adjunct.getWatchMaker(forGrouping);
        if (selectWM == null) {
            throw new XPathException("No watch found for " + select.toShortString());
        }
        return (watchManager, out, context) -> {
            ItemFeed feed = feedMaker.makeItemFeed(watchManager, out, context);
            return selectWM.makeWatch(watchManager, feed, context);
        };
    }
}

