/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.HashSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.DistinctValues;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class DistinctValuesStreamer
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public FeedMaker getFeedMaker(int arg) {
        return arg == 0 ? this : this.getDefaultFeedMaker(arg);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new DistinctValuesFeed(this.getExpression(), out, context);
    }

    private static class DistinctValuesFeed
    extends ItemFeed {
        private StringCollator collator;
        private HashSet<AtomicMatchKey> lookup;
        private final int implicitTimezone;

        DistinctValuesFeed(Expression expr, ItemFeed result, XPathContext context) {
            super(expr, result, context);
            this.implicitTimezone = context.getImplicitTimezone();
            SystemFunctionCall call = (SystemFunctionCall)expr;
            SystemFunction fn = call.getTargetFunction();
            if (fn instanceof DistinctValues) {
                this.collator = ((DistinctValues)fn).getStringCollator();
            }
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            this.lookup = new HashSet(40);
            if (this.collator == null) {
                SystemFunctionCall call = (SystemFunctionCall)this.getExpression();
                Expression collationArg = call.getArg(call.getArity() - 1);
                String collationName = collationArg.evaluateAsString(this.getContext()).toString();
                this.collator = this.getContext().getConfiguration().getCollation(collationName);
                if (this.collator == null) {
                    this.dynamicError(new XPathException("Unknown collation " + collationName, "FOCH0002"));
                }
            }
            this.getResultFeed().open(terminator);
        }

        @Override
        public void append(Item item) throws XPathException {
            if (!this.hasFailed()) {
                AtomicMatchKey key;
                AtomicValue next = (AtomicValue)item;
                AtomicMatchKey atomicMatchKey = key = next.isNaN() ? DistinctValues.NaN_MATCH_KEY : next.getXPathMatchKey(this.collator, this.implicitTimezone);
                if (this.lookup.add(key)) {
                    this.getNextOutputter().append(item);
                }
            }
        }
    }
}

