/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.CurrentGroupPattern;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.functions.CurrentGroupCall;
import net.sf.saxon.pattern.Pattern;

public class CurrentGroupStreamer
extends StreamingAdjunct {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        CurrentGroupCall exp = (CurrentGroupCall)this.getExpression();
        ForEachGroup feg = exp.getControllingInstruction();
        if (feg == null) {
            if (reasons != null) {
                reasons.add("The current-group() function has no containing xsl:for-each-group instruction");
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        PostureAndSweep ps = Streamability.getStreamability(feg.getSelectExpression(), contextInfo, reasons);
        if (ps.getPosture() == Posture.GROUNDED) {
            return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
        }
        if (exp.isInHigherOrderOperand()) {
            if (reasons != null) {
                reasons.add("The current-group() function is evaluated repeatedly");
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        return ps;
    }

    @Override
    public Pattern toStreamingPattern(Configuration config) {
        return CurrentGroupPattern.getInstance();
    }
}

