/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;

public abstract class BooleanFnFeed
extends ItemFeed {
    private WatchManager watchManager;
    private int count;
    private int level;
    private boolean foundAtomic;
    private boolean result;
    private boolean done;
    private boolean closed;

    BooleanFnFeed(WatchManager watchManager, Expression exp, ItemFeed result, XPathContext context) {
        super(exp, result, context);
        this.watchManager = watchManager;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.count = 0;
        this.level = 0;
        this.result = !this.isPositive();
    }

    protected abstract boolean isPositive();

    private void testNode() throws XPathException {
        if (this.level == 0 && !this.hasFailed()) {
            if (++this.count == 1) {
                this.done = true;
                this.getNextOutputter().append(BooleanValue.get(this.isPositive()));
                if (this.watchManager.allowsEarlyExit()) {
                    this.closed = true;
                    this.getNextOutputter().close();
                    this.getTerminator().terminate();
                }
            } else if (this.foundAtomic) {
                try {
                    ExpressionTool.ebvError("a sequence of two or more items starting with an atomic value", this.getExpression());
                }
                catch (XPathException e) {
                    this.dynamicError(e);
                }
            }
        }
    }

    @Override
    public void append(Item item) throws XPathException {
        if (!this.hasFailed()) {
            if (item instanceof NodeInfo) {
                this.testNode();
            } else if (++this.count == 1) {
                try {
                    this.result = ExpressionTool.effectiveBooleanValue(item) ^ !this.isPositive();
                }
                catch (XPathException e) {
                    this.dynamicError(e);
                    return;
                }
                this.foundAtomic = item instanceof AtomicValue;
            } else if (this.foundAtomic) {
                try {
                    ExpressionTool.ebvError("a sequence of two or more items starting with an atomic value", this.getExpression());
                }
                catch (XPathException e) {
                    this.dynamicError(e);
                }
            }
        }
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.testNode();
        ++this.level;
    }

    @Override
    public void endDocument() throws XPathException {
        --this.level;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.testNode();
        ++this.level;
    }

    @Override
    public void namespace(String prefix, NamespaceUri namespaceUri, int properties) throws XPathException {
        this.testNode();
    }

    @Override
    public void endElement() {
        --this.level;
    }

    @Override
    public void characters(UnicodeString chars, Location location, int properties) throws XPathException {
        this.testNode();
    }

    @Override
    public void comment(UnicodeString content, Location location, int properties) throws XPathException {
        this.testNode();
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, String value, Location location, int properties) throws XPathException {
        this.testNode();
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed() && !this.done) {
            this.getNextOutputter().append(BooleanValue.get(this.result));
            if (!this.closed) {
                super.close();
            }
            this.done = true;
        }
    }

    public static class Negative
    extends BooleanFnFeed {
        public Negative(WatchManager watchManager, Expression exp, ItemFeed result, XPathContext context) {
            super(watchManager, exp, result, context);
        }

        @Override
        protected boolean isPositive() {
            return false;
        }
    }

    public static class Positive
    extends BooleanFnFeed {
        public Positive(WatchManager watchManager, Expression exp, ItemFeed result, XPathContext context) {
            super(watchManager, exp, result, context);
        }

        @Override
        protected boolean isPositive() {
            return true;
        }
    }
}

