/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.SimpleContentFeed;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.AdjacentTextNodeMerger;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SchemaType;

public class AdjacentTextNodeMergerAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) {
        AdjacentTextNodeMerger scc = (AdjacentTextNodeMerger)this.getExpression();
        if (Streamability.getSweep(scc) == Sweep.CONSUMING) {
            Expression select = scc.getBaseExpression();
            Pattern selection = StreamingPatternMaker.makeStreamingPattern(select, this.getConfiguration(), null);
            if (selection != null) {
                return (watchManager, out, context) -> {
                    SimpleContentFeed action = new SimpleContentFeed(out);
                    Trigger watch = new Trigger(selection, action, context);
                    watch.setPipelineConfiguration(watchManager.getPipelineConfiguration());
                    return watch;
                };
            }
            return null;
        }
        return null;
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new AdjacentTextNodeMergerFeed(this.getExpression(), out, context);
    }

    private static class AdjacentTextNodeMergerFeed
    extends ItemFeed {
        private final UnicodeBuilder buffer = new UnicodeBuilder();
        private boolean prevText = false;

        AdjacentTextNodeMergerFeed(Expression exp, ItemFeed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public void append(Item item) throws XPathException {
            if (AdjacentTextNodeMerger.isTextNode(item)) {
                UnicodeString s = item.getUnicodeStringValue();
                if (!s.isEmpty()) {
                    this.buffer.accept(s);
                    this.prevText = true;
                }
            } else {
                this.flush();
                this.getNextOutputter().append(item);
            }
        }

        @Override
        public void characters(UnicodeString chars, Location location, int properties) throws XPathException {
            if (!chars.isEmpty()) {
                this.buffer.accept(chars);
                this.prevText = true;
            }
        }

        private void flush() throws XPathException {
            if (this.prevText) {
                Orphan o = new Orphan(this.getPipelineConfiguration().getConfiguration());
                o.setNodeKind((short)3);
                o.setStringValue(this.buffer.toUnicodeString());
                this.getNextOutputter().append(o);
                this.buffer.clear();
            }
            this.prevText = false;
        }

        @Override
        public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
            this.prevText = false;
            super.startElement(elemName, typeCode, location, properties);
        }

        @Override
        public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
            this.prevText = false;
            super.startElement(elemName, type, attributes, namespaces, location, properties);
        }

        @Override
        public void endElement() throws XPathException {
            this.prevText = false;
            super.endElement();
        }

        @Override
        public void processingInstruction(String name, UnicodeString data, Location location, int properties) throws XPathException {
            this.prevText = false;
            super.processingInstruction(name, data, location, properties);
        }

        @Override
        public void comment(UnicodeString content, Location location, int properties) throws XPathException {
            this.prevText = false;
            super.comment(content, location, properties);
        }

        @Override
        public void close() throws XPathException {
            this.flush();
            this.getNextOutputter().close();
        }
    }
}

