/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import com.saxonica.ee.stream.adjunct.AccumulatorAfterStreamer;
import com.saxonica.ee.stream.adjunct.BooleanFnStreamer;
import com.saxonica.ee.stream.adjunct.CodepointsToStringStreamer;
import com.saxonica.ee.stream.adjunct.CountStreamer;
import com.saxonica.ee.stream.adjunct.CurrentGroupStreamer;
import com.saxonica.ee.stream.adjunct.CurrentMergeGroupStreamer;
import com.saxonica.ee.stream.adjunct.DeepEqualStreamer;
import com.saxonica.ee.stream.adjunct.DistinctValuesStreamer;
import com.saxonica.ee.stream.adjunct.EmptyStreamer;
import com.saxonica.ee.stream.adjunct.ExistsStreamer;
import com.saxonica.ee.stream.adjunct.FilterFnStreamer;
import com.saxonica.ee.stream.adjunct.FoldStreamer;
import com.saxonica.ee.stream.adjunct.IndexOfStreamer;
import com.saxonica.ee.stream.adjunct.InsertBeforeStreamer;
import com.saxonica.ee.stream.adjunct.ItemsAfterStreamer;
import com.saxonica.ee.stream.adjunct.ItemsBeforeStreamer;
import com.saxonica.ee.stream.adjunct.ItemsFromStreamer;
import com.saxonica.ee.stream.adjunct.ItemsUntilStreamer;
import com.saxonica.ee.stream.adjunct.LastStreamer;
import com.saxonica.ee.stream.adjunct.MapEntryStreamer;
import com.saxonica.ee.stream.adjunct.MinimaxStreamer;
import com.saxonica.ee.stream.adjunct.NewMapStreamer;
import com.saxonica.ee.stream.adjunct.NotFnStreamer;
import com.saxonica.ee.stream.adjunct.OutermostStreamer;
import com.saxonica.ee.stream.adjunct.RemoveStreamer;
import com.saxonica.ee.stream.adjunct.ReverseStreamer;
import com.saxonica.ee.stream.adjunct.RootStreamer;
import com.saxonica.ee.stream.adjunct.SnapshotFnStreamer;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.adjunct.StringFnStreamer;
import com.saxonica.ee.stream.adjunct.SubsequenceStreamer;
import com.saxonica.ee.stream.adjunct.TraceStreamer;
import com.saxonica.ee.stream.adjunct.TreatFnStreamer;
import com.saxonica.ee.stream.adjunct.XmlToJsonFnStreamer;
import java.util.Map;
import java.util.function.Supplier;

public class StreamerMap {
    private static final Map<String, Supplier<StreamingAdjunct>> map = StreamingAdjunct.emptyAdjunctMap();

    public static StreamingAdjunct getStreamingAdjunct(String f) {
        if (f == null) {
            return null;
        }
        try {
            Supplier<StreamingAdjunct> supplier = map.get(f);
            return supplier == null ? null : supplier.get();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        map.put("AccumulatorAfter", () -> new AccumulatorAfterStreamer());
        map.put("BooleanFn", () -> new BooleanFnStreamer());
        map.put("CodepointsToString", () -> new CodepointsToStringStreamer());
        map.put("Count", () -> new CountStreamer());
        map.put("CurrentGroup", () -> new CurrentGroupStreamer());
        map.put("CurrentMergeGroup", () -> new CurrentMergeGroupStreamer());
        map.put("DeepEqual", () -> new DeepEqualStreamer());
        map.put("DistinctValues", () -> new DistinctValuesStreamer());
        map.put("Empty", () -> new EmptyStreamer());
        map.put("Exists", () -> new ExistsStreamer());
        map.put("FilterFn", () -> new FilterFnStreamer());
        map.put("Fold", () -> new FoldStreamer());
        map.put("IndexOf", () -> new IndexOfStreamer());
        map.put("InsertBefore", () -> new InsertBeforeStreamer());
        map.put("Last", () -> new LastStreamer());
        map.put("MapEntry", () -> new MapEntryStreamer());
        map.put("Minimax", () -> new MinimaxStreamer());
        map.put("NewMap", () -> new NewMapStreamer());
        map.put("NotFn", () -> new NotFnStreamer());
        map.put("Outermost", () -> new OutermostStreamer());
        map.put("Remove", () -> new RemoveStreamer());
        map.put("Reverse", () -> new ReverseStreamer());
        map.put("Root", () -> new RootStreamer());
        map.put("SnapshotFn", () -> new SnapshotFnStreamer());
        map.put("StringFn", () -> new StringFnStreamer());
        map.put("Subsequence", () -> new SubsequenceStreamer());
        map.put("Trace", () -> new TraceStreamer());
        map.put("TreatFn", () -> new TreatFnStreamer());
        map.put("XmlToJsonFn", () -> new XmlToJsonFnStreamer());
        map.put("saxon:ItemsUntil", () -> new ItemsUntilStreamer());
        map.put("saxon:ItemsBefore", () -> new ItemsBeforeStreamer());
        map.put("saxon:ItemsFrom", () -> new ItemsFromStreamer());
        map.put("saxon:ItemsAfter", () -> new ItemsAfterStreamer());
    }
}

