/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.Notation;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.SchemaException;

public class XSDNotation
extends AnnotationParent {
    private Notation notation;

    @Override
    protected void prepareAttributes() throws SchemaException {
        String systemAtt;
        StructuredQName nc;
        this.notation = new Notation(this.getSchema().getConfiguration(), this);
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"id", "name", "public", "system"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String name = atts.getValue(NamespaceUri.NULL, "name");
        if (name == null) {
            this.missingAttribute("name");
            name = "unnamed-notation-" + this.hashCode();
        }
        try {
            nc = this.getComponentName(name, 1);
        }
        catch (SchemaException err) {
            this.error(err.getMessage());
            nc = StandardNames.SQ_XS_INVALID_NAME;
        }
        this.notation.setNotationName(nc);
        String publicAtt = atts.getValue(NamespaceUri.NULL, "public");
        if (publicAtt != null) {
            this.notation.setNotationPublicId(publicAtt);
        }
        if ((systemAtt = atts.getValue(NamespaceUri.NULL, "system")) != null) {
            this.notation.setNotationSystemId(systemAtt);
        }
        if (publicAtt == null && systemAtt == null) {
            this.error("A notation must have either a public identifier or a system identifier");
        }
    }

    public Notation getNotation() {
        return this.notation;
    }
}

