/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.XSDAny;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.Whitespace;

public class XSDDefaultOpenContent
extends AnnotationParent {
    private boolean appliesToEmpty = false;
    private String mode = "interleave";
    private static final int[] state0terms = new int[]{579, 578};
    private static final int[] state0targets = new int[]{1, 2};
    private static final int[] state1terms = new int[0];
    private static final int[] state1targets = new int[0];
    private static final int[] state2terms = new int[]{579};
    private static final int[] state2targets = new int[]{1};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets};

    @Override
    protected void prepareAttributes() throws SchemaException {
        if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
            this.error("The xs:defaultOpenContent element requires XSD 1.1 to be enabled");
        }
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"appliesToEmpty", "id", "mode"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String attValue = atts.getValue(NamespaceUri.NULL, "appliesToEmpty");
        if (attValue != null) {
            this.appliesToEmpty = this.parseBooleanAttribute("appliesToEmpty", attValue);
        }
        if ((attValue = Whitespace.trim(atts.getValue(NamespaceUri.NULL, "mode"))) != null) {
            if (attValue.equals("interleave") || attValue.equals("suffix")) {
                this.mode = attValue;
            } else {
                this.invalidAttributeValue("mode", attValue, "Must be 'interleave' or 'suffix'");
            }
        }
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        this.checkContentModel(stateTerms, stateTargets, false);
        for (NodeInfo nodeInfo : this.children()) {
            int fp = nodeInfo.getFingerprint();
            switch (fp) {
                case 579: {
                    Wildcard wildcard = ((XSDAny)nodeInfo).getElementWildcard().getWildcard();
                    this.getXSDSchema().setDefaultOpenContent(wildcard, this.mode, this.appliesToEmpty);
                    break;
                }
            }
        }
    }

    @Override
    protected boolean isFinalState(int state) {
        return state == 1;
    }
}

