/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AssertionFacet;
import com.saxonica.ee.schema.EnumerationFacet;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.FractionDigitsFacet;
import com.saxonica.ee.schema.MaxExclusiveFacet;
import com.saxonica.ee.schema.MaxInclusiveFacet;
import com.saxonica.ee.schema.MinExclusiveFacet;
import com.saxonica.ee.schema.MinInclusiveFacet;
import com.saxonica.ee.schema.PatternFacet;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.TotalDigitsFacet;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserListType;
import com.saxonica.ee.schema.UserSchemaComponent;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.UserUnionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;

public class SimpleTypeDefinition
extends UserSimpleType
implements UserSchemaComponent {
    private boolean isSimpleContent = false;
    private TypeReference itemTypeReference = null;
    private RegularExpression tokenSeparator = null;
    private List<TypeReference> members = null;
    private UserSimpleType workingType = null;

    public SimpleTypeDefinition(EnterpriseConfiguration config) {
        this.setConfiguration(config);
    }

    public void setItemTypeReference(TypeReference itemType) {
        this.itemTypeReference = itemType;
    }

    @Override
    public boolean isAtomicType() {
        return !this.isListType() && !this.isUnionType();
    }

    @Override
    public boolean isListType() {
        return this.itemTypeReference != null || this.getDerivationMethod() == 1 && this.getBaseTypeReference() != null && ((SimpleType)this.getBaseType()).isListType();
    }

    @Override
    public boolean isUnionType() {
        return this.members != null || this.getDerivationMethod() == 1 && this.getBaseTypeReference() != null && ((SimpleType)this.getBaseType()).isUnionType();
    }

    public void setIsSimpleContent(boolean b) {
        this.isSimpleContent = b;
    }

    public void addMemberType(TypeReference memberType) {
        if (this.members == null) {
            this.members = new ArrayList<TypeReference>(5);
        }
        this.members.add(memberType);
    }

    public void setTokenSeparator(RegularExpression separator) {
        this.tokenSeparator = separator;
    }

    public UserSimpleType getWorkingType() {
        return this.workingType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        boolean result;
        TypeReference baseRef;
        if (this.getFixupStatus() != SchemaValidationStatus.UNVALIDATED) {
            return true;
        }
        this.setFixupStatus(SchemaValidationStatus.VALIDATING);
        if (this.getBaseTypeReference() == null) {
            TypeReference ref = new TypeReference(573, compiler.getConfiguration(), this);
            ref.setTarget(AnySimpleType.getInstance());
            this.setBaseTypeReference(ref);
        }
        if ((baseRef = this.getBaseTypeReference()) != null && !baseRef.isResolved()) {
            SchemaType typeDef = (SchemaType)PreparedSchema.validateReference(baseRef, compiler, true);
            if (typeDef == null) {
                this.setFixupStatus(SchemaValidationStatus.INVALID);
                return false;
            }
            if (typeDef instanceof UserSchemaComponent) {
                boolean b = ((UserSchemaComponent)((Object)typeDef)).fixup(compiler);
                if (!b) {
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
                if (typeDef instanceof SimpleTypeDefinition) {
                    UserSimpleType s = ((SimpleTypeDefinition)typeDef).getWorkingType();
                    if (s != null) {
                        baseRef.setTarget(s);
                    }
                } else if (typeDef.isComplexType()) {
                    if (!this.isSimpleContent) {
                        compiler.error("A simple type cannot have a complex type " + Err.wrap(typeDef.getDescription()) + " as its base type", this);
                        this.setFixupStatus(SchemaValidationStatus.INVALID);
                        return false;
                    }
                    if (!((ComplexType)typeDef).isSimpleContent()) {
                        compiler.error("A complex type with simple content " + Err.wrap(typeDef.getDescription()) + " cannot have a type with complex content as its base type", this);
                        this.setFixupStatus(SchemaValidationStatus.INVALID);
                        this.setValidationStatus(SchemaValidationStatus.INVALID);
                        return false;
                    }
                    if (typeDef instanceof UserComplexType) {
                        TypeReference ref = ((UserComplexType)typeDef).getSimpleContentTypeReference();
                        if (ref != null) {
                            PreparedSchema.validateReference(ref, compiler, false);
                            if (!ref.isResolved()) {
                                this.setFixupStatus(SchemaValidationStatus.INVALID);
                                return false;
                            }
                        }
                        this.setBaseTypeReference(ref);
                    }
                }
            }
        }
        if (this.itemTypeReference != null) {
            boolean badItemType = false;
            SchemaType type = (SchemaType)PreparedSchema.validateReference(this.itemTypeReference, compiler, false);
            if (type == null) {
                badItemType = true;
            } else if (type instanceof UserSchemaComponent) {
                boolean r = ((UserSchemaComponent)((Object)type)).fixup(compiler);
                if (!r) {
                    badItemType = true;
                } else if (type instanceof SimpleTypeDefinition) {
                    UserSimpleType s = ((SimpleTypeDefinition)type).getWorkingType();
                    if (s != null) {
                        this.itemTypeReference.setTarget(s);
                    }
                } else if (type.isComplexType()) {
                    badItemType = true;
                    compiler.error("A list type cannot have a complex type " + Err.wrap(type.getDescription()) + " as its item type", this);
                }
            }
            if (badItemType) {
                UserListType list = this.makeListType();
                list.setItemTypeReference(new TypeReference(575, this.getConfiguration(), this));
                this.workingType = list;
                this.setFixupStatus(SchemaValidationStatus.INVALID);
                return false;
            }
        }
        if (this.members != null) {
            for (TypeReference o : this.members) {
                SchemaType typeDef = (SchemaType)PreparedSchema.validateReference(o, compiler, false);
                if (typeDef == null) {
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
                if (typeDef instanceof SimpleTypeDefinition) {
                    boolean b = ((SimpleTypeDefinition)typeDef).fixup(compiler);
                    if (!b) {
                        this.setFixupStatus(SchemaValidationStatus.INVALID);
                        return false;
                    }
                    UserSimpleType s = ((SimpleTypeDefinition)typeDef).getWorkingType();
                    if (s == null) continue;
                    o.setTarget(s);
                    continue;
                }
                if (!typeDef.isComplexType()) continue;
                compiler.error("A member of a union type cannot be a complex type " + typeDef.getDescription(), this);
                this.setFixupStatus(SchemaValidationStatus.INVALID);
                return false;
            }
        }
        if (result = this.makeWorkingType(compiler)) {
            this.setFixupStatus(SchemaValidationStatus.VALIDATED);
            return true;
        }
        this.setFixupStatus(SchemaValidationStatus.INVALID);
        this.setValidationStatus(SchemaValidationStatus.INVALID);
        return false;
    }

    private boolean makeWorkingType(SchemaCompiler compiler) throws SchemaException {
        if (this.getDerivationMethod() == 8) {
            boolean badItemType = false;
            boolean b = this.checkFacetsForListType(compiler);
            if (b) {
                SimpleType itemType = (SimpleType)this.itemTypeReference.getTarget();
                if (!itemType.allowsDerivation(8)) {
                    badItemType = true;
                    compiler.error("The item type of the list type " + this.getDescription() + " disallows derivation by list", this);
                }
                if (itemType instanceof ListType) {
                    badItemType = true;
                    compiler.error("The item type of the list type " + this.getDescription() + " is itself a list type", this);
                }
                if (itemType == BuiltInAtomicType.ANY_ATOMIC || itemType == AnySimpleType.getInstance()) {
                    badItemType = true;
                    compiler.error("The item type of the list type " + this.getDescription() + " must not be xs:anySimpleType or xs:anyAtomicType", this);
                }
            } else {
                badItemType = true;
            }
            UserListType list = this.makeListType();
            this.workingType = list;
            if (badItemType) {
                list.setItemTypeReference(new TypeReference(575, this.getConfiguration(), this));
                return false;
            }
            list.setItemTypeReference(this.itemTypeReference);
        } else {
            if (this.getDerivationMethod() == 4) {
                if (this.members == null) {
                    this.members = Collections.emptyList();
                }
                if (this.members.isEmpty()) {
                    compiler.error("The union type " + this.getDescription() + " has no members", this);
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                    this.members.add(new TypeReference(575, this.getConfiguration(), this));
                }
                for (TypeReference member : this.members) {
                    SimpleType mem = (SimpleType)member.getTarget();
                    if (mem.allowsDerivation(4)) continue;
                    compiler.error("The member type " + mem.getDescription() + " of the type " + this.getDescription() + " disallows derivation by union", this);
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                    member.setTarget(ErrorType.getInstance());
                }
                boolean b = this.checkFacetsForUnionType(compiler);
                if (!b) {
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                }
                UserUnionType union = this.makeUnionType();
                union.setMemberTypeReferences(this.members);
                this.workingType = union;
                return this.getFixupStatus() != SchemaValidationStatus.INVALID;
            }
            SchemaType base = this.getBaseType();
            if (!base.allowsDerivation(1)) {
                compiler.error("The base type of the type " + this.getDescription() + " disallows derivation by restriction", this);
                this.setFixupStatus(SchemaValidationStatus.INVALID);
            }
            if (base instanceof SimpleTypeDefinition) {
                if (((SimpleTypeDefinition)base).workingType != null) {
                    base = ((SimpleTypeDefinition)base).workingType;
                } else if (base.getValidationStatus() == SchemaValidationStatus.INVALID || ((SimpleTypeDefinition)base).getFixupStatus() == SchemaValidationStatus.INVALID) {
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                } else {
                    ((SimpleTypeDefinition)base).makeWorkingType(compiler);
                    base = ((SimpleTypeDefinition)base).workingType;
                }
            }
            if (base != null && base.getFingerprint() == 573 && !this.getTypeName().hasURI(NamespaceUri.SCHEMA)) {
                compiler.error("A simple type cannot be derived by restricting xs:anySimpleType", this);
                this.setFixupStatus(SchemaValidationStatus.INVALID);
                this.setBaseTypeReference(new TypeReference(BuiltInAtomicType.STRING.getFingerprint(), this.getConfiguration(), this));
            }
            if (base != null && base.getFingerprint() == 632 && !this.getTypeName().hasURI(NamespaceUri.SCHEMA)) {
                compiler.error("A simple type cannot be derived by restricting xs:anyAtomicType", this);
                this.setFixupStatus(SchemaValidationStatus.INVALID);
                this.setBaseTypeReference(new TypeReference(BuiltInAtomicType.STRING.getFingerprint(), this.getConfiguration(), this));
            }
            if (base instanceof SimpleType) {
                try {
                    this.checkFacetsForRestrictedType((SimpleType)base, compiler);
                }
                catch (SchemaException | ValidationException err) {
                    compiler.error(err.getMessage(), this);
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                    this.setFacetList(Collections.emptyList());
                }
                if (base instanceof ListType || ((SimpleType)base).isListType()) {
                    boolean b = this.checkFacetsForListType(compiler);
                    if (!b) {
                        this.setFixupStatus(SchemaValidationStatus.INVALID);
                    }
                    UserListType list = this.makeListType();
                    if (base instanceof UserListType) {
                        list.setItemTypeReference(((UserListType)base).getItemTypeReference());
                        list.inheritSeparator((UserListType)base);
                    } else {
                        assert (base instanceof ListType);
                        list.setItemTypeReference(new TypeReference(((ListType)base).getItemType().getFingerprint(), compiler.getConfiguration(), this));
                    }
                    this.workingType = list;
                } else if (base instanceof UserUnionType || ((SimpleType)base).isUnionType()) {
                    boolean b = this.checkFacetsForUnionType(compiler);
                    if (!b) {
                        this.setFixupStatus(SchemaValidationStatus.INVALID);
                    }
                    UserUnionType union = this.makeUnionType();
                    if (base instanceof UserUnionType) {
                        union.setMemberTypeReferences(((UserUnionType)base).getMemberTypeReferences());
                    } else if (base instanceof SimpleTypeDefinition) {
                        union.setMemberTypeReferences(((SimpleTypeDefinition)base).members);
                    }
                    this.workingType = union;
                }
            }
            if (this.workingType == null) {
                UserAtomicType atomic = new UserAtomicType(this.getConfiguration());
                atomic.setBaseTypeReference(this.getBaseTypeReference());
                atomic.setDerivationMethod(this.getDerivationMethod());
                atomic.setTypeName(this.getTypeName(), this.getFingerprint());
                atomic.setFacetList(this.getLocalFacetList());
                atomic.convertFacetValues();
                atomic.setFinalProhibitions(this.finalProhibitions);
                atomic.setSystemId(this.getSystemId());
                atomic.setLineNumber(this.getLineNumber());
                atomic.setGeneratedId(this.getGeneratedId());
                atomic.setContainingDeclaration(this.getContainingDeclarationName(), this.containingDeclarationIsElement());
                atomic.setExtendedTypes(this.extendedTypes);
                atomic.setRedefinitionLevel(this.getRedefinitionLevel());
                atomic.setSchemaDocumentURI(this.getSchemaDocumentURI());
                this.workingType = atomic;
            }
        }
        this.workingType.mergeEnumerationFacets(compiler);
        this.workingType.getExtendedFacetList();
        this.workingType.setContextComponent(this.getContextComponent());
        if (this.workingType.getValidationStatus() == SchemaValidationStatus.INVALID || this.getFixupStatus() == SchemaValidationStatus.INVALID) {
            this.setFixupStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        this.setFixupStatus(SchemaValidationStatus.VALIDATED);
        if (this.getName() == null) {
            this.getConfiguration().getSuperSchema().addAnonymousType(this.workingType);
        }
        return true;
    }

    private UserUnionType makeUnionType() throws SchemaException {
        UserUnionType union = new UserUnionType(this.getConfiguration());
        union.setBaseTypeReference(this.getBaseTypeReference());
        union.setDerivationMethod(this.getDerivationMethod());
        union.setTypeName(this.getTypeName(), this.getFingerprint());
        union.setFacetList(this.getLocalFacetList());
        union.convertFacetValues();
        union.setFinalProhibitions(this.finalProhibitions);
        union.setSystemId(this.getSystemId());
        union.setLineNumber(this.getLineNumber());
        union.setGeneratedId(this.getGeneratedId());
        union.setContainingDeclaration(this.getContainingDeclarationName(), this.containingDeclarationIsElement());
        union.setExtendedTypes(this.extendedTypes);
        union.setRedefinitionLevel(this.getRedefinitionLevel());
        union.setSchemaDocumentURI(this.getSchemaDocumentURI());
        return union;
    }

    private UserListType makeListType() throws SchemaException {
        UserListType list = new UserListType(this.getConfiguration());
        list.setBaseTypeReference(this.getBaseTypeReference());
        list.setDerivationMethod(this.getDerivationMethod());
        list.setTypeName(this.getTypeName(), this.getFingerprint());
        list.setFacetList(this.getLocalFacetList());
        list.convertFacetValues();
        list.setFinalProhibitions(this.finalProhibitions);
        list.setSystemId(this.getSystemId());
        list.setLineNumber(this.getLineNumber());
        list.setGeneratedId(this.getGeneratedId());
        list.setContainingDeclaration(this.getContainingDeclarationName(), this.containingDeclarationIsElement());
        list.setExtendedTypes(this.extendedTypes);
        list.setRedefinitionLevel(this.getRedefinitionLevel());
        list.setSchemaDocumentURI(this.getSchemaDocumentURI());
        list.setTokenSeparator(this.tokenSeparator);
        return list;
    }

    private boolean checkFacetsForListType(SchemaCompiler compiler) throws SchemaException {
        List<Facet> facets = this.getLocalFacetList();
        for (Facet facet : facets) {
            Class<?> name = facet.getClass();
            if (!name.equals(MaxExclusiveFacet.class) && !name.equals(MaxInclusiveFacet.class) && !name.equals(MinExclusiveFacet.class) && !name.equals(MinInclusiveFacet.class) && !name.equals(TotalDigitsFacet.class) && !name.equals(FractionDigitsFacet.class)) continue;
            compiler.error("The " + name + " facet is not allowed on the list type " + this.getDescription(), this);
            return false;
        }
        return true;
    }

    private boolean checkFacetsForUnionType(SchemaCompiler compiler) throws SchemaException {
        List<Facet> facets = this.getLocalFacetList();
        for (Facet facet : facets) {
            Class<?> facetClass = facet.getClass();
            if (facetClass.equals(PatternFacet.class) || facetClass.equals(EnumerationFacet.class) || facetClass.equals(AssertionFacet.class)) continue;
            compiler.error("The " + facet.getName() + " facet is not allowed on the union type " + this.getDescription(), this);
            return false;
        }
        return true;
    }

    private void checkFacetsForRestrictedType(SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        List<Facet> facets = this.getLocalFacetList();
        for (Facet facet : facets) {
            facet.checkFacetRestriction(this, base, compiler);
        }
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        if (this.workingType != null) {
            return this.workingType.validate(compiler);
        }
        return false;
    }

    @Override
    public AtomicSequence getTypedValue(UnicodeString value, NamespaceResolver resolver, ConversionRules rules) throws ValidationException {
        if (this.workingType != null) {
            return this.workingType.getTypedValue(value, resolver, rules);
        }
        throw new UnsupportedOperationException(this.getUnresolvedMessage());
    }

    @Override
    public boolean isBuiltInType() {
        return false;
    }

    @Override
    public boolean isNamespaceSensitive() {
        throw new UnsupportedOperationException(this.getUnresolvedMessage());
    }

    @Override
    public ValidationFailure validateContent(UnicodeString value, NamespaceResolver nsResolver, ConversionRules rules) {
        if (this.workingType != null) {
            return this.workingType.validateContent(value, nsResolver, rules);
        }
        if (this.getValidationStatus() == SchemaValidationStatus.INVALID) {
            return new ValidationFailure("Cannot validate value, because simple type definition is invalid");
        }
        throw new UnsupportedOperationException(this.getUnresolvedMessage());
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        if (this.workingType == null) {
            throw new UnsupportedOperationException(this.getUnresolvedMessage());
        }
        this.workingType.serialize(serializer);
    }

    @Override
    protected void serializeVariety(SchemaModelSerializer serializer) {
        throw new UnsupportedOperationException(this.getUnresolvedMessage());
    }

    private String getUnresolvedMessage() {
        return "SimpleTypeDefinition " + this + " should have been resolved by now (" + this.getDescription() + ") #" + this.getFingerprint() + ": " + this.getNamePool().getClarkName(this.getFingerprint());
    }
}

