/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.AssertionFacet;
import com.saxonica.ee.schema.EnumerationFacet;
import com.saxonica.ee.schema.EnumerationFacetSet;
import com.saxonica.ee.schema.ExplicitTimezoneFacet;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.MaxInclusiveFacet;
import com.saxonica.ee.schema.MinInclusiveFacet;
import com.saxonica.ee.schema.PatternFacet;
import com.saxonica.ee.schema.PreprocessFacet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserDefinedType;
import com.saxonica.ee.schema.UserSchemaComponent;
import com.saxonica.ee.schema.UserUnionType;
import com.saxonica.ee.schema.ValueRangeFacet;
import com.saxonica.ee.schema.WhitespaceFacet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public abstract class UserSimpleType
extends UserDefinedType
implements SimpleType,
UserSchemaComponent,
SerializableSchemaComponent {
    private List<Facet> facetList = new ArrayList<Facet>(10);
    private List<Facet> extendedFacetList;
    private SchemaComponent contextComponent;

    @Override
    public final boolean isSimpleType() {
        return true;
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isIdType() throws MissingComponentException {
        return false;
    }

    @Override
    public boolean isIdRefType() throws MissingComponentException {
        return false;
    }

    @Override
    public boolean isListType() {
        return false;
    }

    @Override
    public boolean isUnionType() {
        return false;
    }

    public SchemaComponent getContextComponent() {
        return this.contextComponent;
    }

    public void setContextComponent(SchemaComponent contextComponent) {
        this.contextComponent = contextComponent;
    }

    public List<Facet> getExtendedFacetList() {
        if (this.extendedFacetList != null) {
            return this.extendedFacetList;
        }
        this.extendedFacetList = this.addInheritedFacets(this.facetList);
        return this.extendedFacetList;
    }

    protected List<Facet> addInheritedFacets(List<Facet> localFacets) {
        SchemaType baseType = this.getBaseType();
        if (baseType instanceof UserSimpleType) {
            ArrayList<Facet> extendedFacetList = new ArrayList<Facet>(10);
            HashSet<String> facetsFound = new HashSet<String>();
            for (Facet facet : localFacets) {
                extendedFacetList.add(facet);
                facetsFound.add(facet.getName());
            }
            List<Facet> baseFacetList = ((UserSimpleType)baseType).getExtendedFacetList();
            for (Facet facet : baseFacetList) {
                if (!(facet instanceof PatternFacet) && !(facet instanceof AssertionFacet) && facetsFound.contains(facet.getName())) continue;
                extendedFacetList.add(facet);
                facetsFound.add(facet.getName());
            }
            return extendedFacetList;
        }
        return localFacets;
    }

    @Override
    public String getEQName() {
        return "Q{" + this.getTargetNamespace() + "}" + this.getName();
    }

    public void addFacet(Facet facet) {
        this.facetList.add(facet);
    }

    public void mergeEnumerationFacets(SchemaCompiler compiler) throws SchemaException, MissingComponentException {
        SchemaType baseType;
        boolean enumFound = false;
        EnumerationFacetSet efs = new EnumerationFacetSet();
        PatternFacet pf = null;
        ConversionRules rules = this.getConfiguration().getConversionRules();
        rules = rules.copy();
        rules.setNotationSet(compiler.getPreparedSchema());
        for (int i = this.facetList.size() - 1; i >= 0; --i) {
            if (this.facetList.get(i) instanceof EnumerationFacet) {
                AtomicSequence val;
                EnumerationFacet e = (EnumerationFacet)this.facetList.get(i);
                SchemaType base = this.getBaseType();
                if (base instanceof SimpleType) {
                    try {
                        val = e.getTypedValue((SimpleType)base, rules);
                    }
                    catch (SchemaException se) {
                        compiler.error("Enumeration value does not match base type. " + se.getMessage(), this);
                        this.setValidationStatus(SchemaValidationStatus.INVALID);
                        return;
                    }
                } else {
                    val = new StringValue(e.getValue());
                }
                if (val.getLength() == 1) {
                    AtomicValue atom = val.head();
                    for (Facet facet : this.facetList) {
                        if (facet instanceof EnumerationFacet || facet instanceof EnumerationFacetSet || facet instanceof AssertionFacet || facet instanceof WhitespaceFacet || facet.testAtomicValue(atom)) continue;
                        UnicodeString value = atom.getUnicodeStringValue();
                        String message = "Enumeration value " + Err.wrap(value, 4) + " is not a valid instance of the type: it contravenes the " + facet.getName() + " facet";
                        String userMessage = facet.getMessage();
                        if (userMessage != null) {
                            message = message + ". " + userMessage;
                        }
                        compiler.warning(message, "SXSD1010", this);
                    }
                }
                efs.addEnumerationValue(val, e.getValue().toString());
                this.facetList.remove(i);
                enumFound = true;
                continue;
            }
            if (!(this.facetList.get(i) instanceof PatternFacet) || ((PatternFacet)this.facetList.get(i)).isDoNotMerge()) continue;
            if (pf == null) {
                pf = (PatternFacet)this.facetList.get(i);
                continue;
            }
            UnicodeString pat = this.facetList.get(i).getValue();
            pf.addBranch(pat);
            this.facetList.remove(i);
        }
        if (enumFound) {
            this.facetList.add(efs);
        }
        if ((baseType = this.getBaseType()) instanceof UserSimpleType) {
            ((UserSimpleType)baseType).mergeEnumerationFacets(compiler);
        }
    }

    public Facet getFacet(Class<? extends Facet> name) {
        for (Facet f : this.getExtendedFacetList()) {
            if (f.getClass() != name) continue;
            return f;
        }
        return null;
    }

    public void setFacetList(List<Facet> facetList) {
        this.facetList = facetList;
    }

    public void convertFacetValues() throws SchemaException {
        for (Facet facet : this.facetList) {
            if (!(facet instanceof ValueRangeFacet)) continue;
            ((ValueRangeFacet)facet).convertToTargetType((SimpleType)this.getBaseType(), this.getConfiguration());
        }
    }

    @Override
    public int getWhitespaceAction() {
        int action = -1;
        Facet ws = this.getFacet(WhitespaceFacet.class);
        if (ws != null) {
            action = ws.getWhitespaceAction();
        }
        if (action == -1) {
            if (this instanceof UserAtomicType && ((UserAtomicType)this).getPrimitiveType() == 513) {
                TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
                if (th.isSubType((UserAtomicType)this, BuiltInAtomicType.TOKEN)) {
                    return 2;
                }
                if (th.isSubType((UserAtomicType)this, BuiltInAtomicType.NORMALIZED_STRING)) {
                    return 1;
                }
                return 0;
            }
            if (this.isUnionType()) {
                return 0;
            }
            return 2;
        }
        return action;
    }

    public UnicodeString applyWhitespaceNormalization(UnicodeString value) {
        int action = this.getWhitespaceAction();
        return Whitespace.applyWhitespaceNormalization(action, value);
    }

    @Override
    public SchemaType getBuiltInBaseType() {
        SchemaType base = this;
        do {
            base = base.getBaseType();
            assert (base != null);
        } while (base.getFingerprint() > 1023);
        return base;
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType type, int block) throws SchemaException {
        String s = UserSimpleType.isTypeDerivationOK(this, type, block);
        if (s != null) {
            throw new SchemaException(s);
        }
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        if (!this.isValidationNeeded()) {
            return true;
        }
        this.setValidationStatus(SchemaValidationStatus.VALIDATING);
        if (this.getFingerprint() < 1023) {
            this.setValidationStatus(SchemaValidationStatus.VALIDATED);
            return true;
        }
        SchemaType base = this.getBaseType();
        if (base == null) {
            TypeReference ref = new TypeReference(573, this.getConfiguration(), this);
            ref.setTarget(AnySimpleType.getInstance());
            this.setBaseTypeReference(ref);
        } else if (base instanceof UserSimpleType) {
            ((UserSimpleType)base).validate(compiler);
        } else if (!base.isSimpleType()) {
            compiler.error("The base type of the simple type " + this.getDescription() + " is not a simple type", this);
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        this.setValidationStatus(SchemaValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public void analyzeContentExpression(Expression expression, int kind) throws XPathException {
        BuiltInAtomicType.analyzeContentExpression(this, expression, kind);
    }

    @Override
    public AtomicSequence atomize(NodeInfo node) throws XPathException {
        if (node.isNilled()) {
            return EmptyAtomicSequence.getInstance();
        }
        try {
            NamespaceMap resolver = null;
            if (this.isNamespaceSensitive()) {
                resolver = node.getNodeKind() == 1 ? node.getAllNamespaces() : node.getParent().getAllNamespaces();
            }
            return this.getTypedValue(node.getUnicodeStringValue(), resolver, this.getConfiguration().getConversionRules());
        }
        catch (ValidationException err) {
            throw new XPathException("Internal error: value doesn't match its type annotation. " + err.getMessage());
        }
    }

    public static String isTypeDerivationOK(SimpleType d, SchemaType b, int derivation) throws MissingComponentException {
        if (d == b) {
            return null;
        }
        if ((derivation & 1) != 0) {
            return "Simple type derivation is not OK: 'restriction' is in the set of disallowed derivations";
        }
        SchemaType actualBase = d.getBaseType();
        if (actualBase != null && !actualBase.allowsDerivation(1)) {
            return "Simple type derivation is not OK: the base type of type " + d.getDescription() + " does not allow derivation by restriction";
        }
        if (actualBase == b || actualBase.getFingerprint() == b.getFingerprint()) {
            return null;
        }
        String reason = null;
        if (actualBase != AnyType.getInstance()) {
            if (actualBase instanceof SimpleType) {
                reason = UserSimpleType.isTypeDerivationOK((SimpleType)actualBase, b, derivation);
                if (reason == null) {
                    return null;
                }
            } else {
                try {
                    UserComplexType.checkTypeDerivation((ComplexType)actualBase, b, derivation);
                    return null;
                }
                catch (SchemaException err) {
                    reason = err.getMessage();
                }
            }
        }
        if ((d.isListType() || d.isUnionType()) && b == AnySimpleType.getInstance()) {
            return null;
        }
        if (b.isSimpleType() && ((SimpleType)b).isUnionType() && b != ErrorType.getInstance() && ((UserUnionType)b).getExtendedFacetList().isEmpty()) {
            for (TypeReference ref : ((UserUnionType)b).getMemberTypeReferences()) {
                SimpleType member = (SimpleType)ref.getTarget();
                reason = UserSimpleType.isTypeDerivationOK(d, member, derivation);
                if (reason != null) continue;
                return null;
            }
        }
        return "The type " + d.getDescription() + " is not validly derived from the type " + b.getDescription() + (reason == null || reason.contains(" is not validly derived from the type ") ? "" : ". " + reason);
    }

    public List<Facet> getLocalFacetList() {
        return this.facetList;
    }

    @Override
    public UnicodeString preprocess(UnicodeString input) throws ValidationException {
        for (Facet f : this.getExtendedFacetList()) {
            if (!(f instanceof PreprocessFacet)) continue;
            input = ((PreprocessFacet)f).preprocess(input);
        }
        return input;
    }

    @Override
    public UnicodeString postprocess(UnicodeString input) throws ValidationException {
        for (Facet f : this.getExtendedFacetList()) {
            if (!(f instanceof PreprocessFacet)) continue;
            input = ((PreprocessFacet)f).postprocess(input);
        }
        return input;
    }

    public ValidationFailure checkAgainstFacets(AtomicSequence primitiveValue, UnicodeString lexicalValue, List<Facet> facets, ConversionRules rules) {
        UnicodeString normalizedValue = null;
        for (Facet f : facets) {
            AtomicValue av;
            if (f instanceof PatternFacet) {
                if (normalizedValue == null) {
                    normalizedValue = lexicalValue == null ? primitiveValue.getUnicodeStringValue() : this.applyWhitespaceNormalization(lexicalValue);
                }
                if (f.testAtomicValue(new StringValue(normalizedValue))) continue;
                return UserSimpleType.makeValidationFailure(primitiveValue, this, f);
            }
            if (f instanceof AssertionFacet) {
                if (primitiveValue instanceof AtomicValue) {
                    av = (AtomicValue)primitiveValue;
                    if (((AssertionFacet)f).testAtomicValue(av, rules)) continue;
                    return UserSimpleType.makeValidationFailure(av, this, f);
                }
                if (((AssertionFacet)f).testListValue(primitiveValue, rules)) continue;
                return UserSimpleType.makeValidationFailure(primitiveValue, this, f);
            }
            if (primitiveValue instanceof AtomicValue) {
                av = (AtomicValue)primitiveValue;
                if (f.testAtomicValue(av)) continue;
                return UserSimpleType.makeValidationFailure(av, this, f);
            }
            if (f.testListValue(primitiveValue)) continue;
            return UserSimpleType.makeValidationFailure(primitiveValue, this, f);
        }
        return null;
    }

    public static ValidationFailure makeValidationFailure(AtomicSequence primitiveValue, SimpleType type, Facet f) {
        String message = "Value " + Err.wrap(UserSimpleType.displayValue(primitiveValue), 4) + " contravenes the " + f.getName() + " facet " + (f.getValue() == null ? "" : Err.wrap(f.getValue(), 4) + ' ') + "of the type " + type.getDescription();
        if (f.getMessage() != null) {
            message = message + ". " + f.getMessage();
        }
        ValidationFailure ve = new ValidationFailure(message);
        ve.setConstraintReference(2, f.getConstraintName(), "1");
        ve.setErrorCode("FORG0001");
        return ve;
    }

    private static String displayValue(AtomicSequence primitiveValue) {
        String v = primitiveValue.getUnicodeStringValue().toString();
        if (v.length() > 30) {
            v = v.substring(0, 30) + "...";
        }
        return v;
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        if (this.getValidationStatus() == SchemaValidationStatus.UNVALIDATED) {
            if (this.getBaseType() instanceof UserSchemaComponent) {
                ((UserSchemaComponent)((Object)this.getBaseType())).elaborate(compiler);
            }
            for (Facet facet : this.facetList) {
                if (!(facet instanceof ValueRangeFacet)) continue;
                ((ValueRangeFacet)facet).convertToTargetType((SimpleType)this.getBuiltInBaseType(), this.getConfiguration());
            }
            this.mergeEnumerationFacets(compiler);
            this.setValidationStatus(SchemaValidationStatus.VALIDATED);
        }
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("simpleType");
        serializer.emitAttribute("id", id);
        if (!this.isAnonymousType()) {
            serializer.emitAttribute("name", this.getName());
            if (!this.getTargetNamespace().isEmpty()) {
                serializer.emitAttribute("targetNamespace", this.getTargetNamespace().toString());
            }
        }
        serializer.emitAttribute("base", serializer.getTypeLink(this.getBaseType()));
        if (this.finalProhibitions != 0) {
            String ex = "";
            if ((this.finalProhibitions & 1) != 0) {
                ex = "restriction";
            }
            if ((this.finalProhibitions & 8) != 0) {
                ex = ex + (ex.isEmpty() ? "" : " ") + "list";
            }
            if ((this.finalProhibitions & 4) != 0) {
                ex = ex + (ex.isEmpty() ? "" : " ") + "union";
            }
            serializer.emitAttribute("final", ex);
        }
        this.serializeVariety(serializer);
        boolean seenEnumeration = false;
        for (Facet f : this.getExtendedFacetList()) {
            if (f instanceof EnumerationFacetSet) {
                if (seenEnumeration) continue;
                seenEnumeration = true;
            }
            f.serializeFacet(serializer);
        }
        serializer.endElement();
    }

    protected abstract void serializeVariety(SchemaModelSerializer var1) throws XPathException;

    @Override
    public FunctionItem getComponentAsFunction() {
        return UserSimpleType.getComponentAsFunction(this);
    }

    public static FunctionItem getComponentAsFunction(SimpleType type) {
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Simple Type Definition");
                }
                case "implementation": {
                    return new ObjectValue<SimpleType>(type);
                }
                case "name": {
                    if (type.isAnonymousType()) {
                        return EmptySequence.getInstance();
                    }
                    return new StringValue(type.getName(), (AtomicType)BuiltInAtomicType.NCNAME);
                }
                case "target namespace": {
                    if (type.isAnonymousType()) {
                        return EmptySequence.getInstance();
                    }
                    return new AnyURIValue(type.getTargetNamespace().toUnicodeString());
                }
                case "final": {
                    ArrayList<AtomicValue> list = new ArrayList<AtomicValue>();
                    int f = type.getFinalProhibitions();
                    if ((f & 1) != 0) {
                        list.add(StringValue.bmp("restriction"));
                    }
                    if ((f & 2) != 0) {
                        list.add(StringValue.bmp("extension"));
                    }
                    if ((f & 8) != 0) {
                        list.add(StringValue.bmp("list"));
                    }
                    if ((f & 4) != 0) {
                        list.add(StringValue.bmp("union"));
                    }
                    return new AtomicArray(list);
                }
                case "context": {
                    if (type.isAnonymousType()) {
                        UserSimpleType stype = (UserSimpleType)type;
                        SchemaComponent contextComponent = stype.getContextComponent();
                        if (contextComponent == null) {
                            return EmptySequence.getInstance();
                        }
                        return contextComponent.getComponentAsFunction();
                    }
                    return EmptySequence.getInstance();
                }
                case "base type definition": {
                    return type.getBaseType().getComponentAsFunction();
                }
                case "facets": {
                    if (type instanceof UserSimpleType) {
                        ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                        for (Facet f : ((UserSimpleType)type).getExtendedFacetList()) {
                            list.add(f.getFacetAsFunctionItem());
                        }
                        return SequenceExtent.makeSequenceExtent(list);
                    }
                    if (type instanceof BuiltInAtomicType) {
                        List<Facet> facetList = UserSimpleType.getExtendedFacetList((BuiltInAtomicType)type, context.getConfiguration());
                        ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                        for (Facet f : facetList) {
                            list.add(f.getFacetAsFunctionItem());
                        }
                        return SequenceExtent.makeSequenceExtent(list);
                    }
                    return EmptySequence.getInstance();
                }
                case "fundamental facets": {
                    return EmptySequence.getInstance();
                }
                case "variety": {
                    String variety = "atomic";
                    if (type.isListType()) {
                        variety = "list";
                    } else if (type.isUnionType()) {
                        variety = "union";
                    }
                    return new StringValue(variety);
                }
                case "primitive type definition": {
                    if (type == BuiltInAtomicType.ANY_ATOMIC || !type.isAtomicType()) {
                        return EmptySequence.getInstance();
                    }
                    return UserSimpleType.getComponentAsFunction(((AtomicType)type).getPrimitiveItemType());
                }
                case "item type definition": {
                    if (type.isListType()) {
                        return ((ListType)type).getItemType().getComponentAsFunction();
                    }
                    return EmptySequence.getInstance();
                }
                case "member type definitions": {
                    if (type.isUnionType()) {
                        ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                        for (TypeReference member : ((UserUnionType)type).getMemberTypeReferences()) {
                            list.add(member.getTarget().getComponentAsFunction());
                        }
                        return SequenceExtent.makeSequenceExtent(list);
                    }
                    return EmptySequence.getInstance();
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }

    private static List<Facet> getExtendedFacetList(BuiltInAtomicType type, Configuration config) {
        ArrayList<Facet> list = new ArrayList<Facet>(4);
        int prim = type.getPrimitiveType();
        int fp = type.getFingerprint();
        if (prim == 533) {
            IntegerValue max;
            IntegerValue min = Int64Value.getMinInclusive(type);
            if (min != null) {
                MinInclusiveFacet facet = new MinInclusiveFacet();
                facet.setRequiredValue(min);
                list.add(facet);
            }
            if ((max = Int64Value.getMaxInclusive(type)) != null) {
                MaxInclusiveFacet facet = new MaxInclusiveFacet();
                facet.setRequiredValue(max);
                list.add(facet);
            }
        } else if (prim == 513) {
            switch (fp) {
                case 553: 
                case 554: {
                    break;
                }
                case 555: {
                    PatternFacet pat = new PatternFacet(config);
                    pat.setValue("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");
                    list.add(pat);
                    break;
                }
                case 556: {
                    PatternFacet pat = new PatternFacet(config);
                    pat.setValue("\\c+");
                    list.add(pat);
                    break;
                }
                case 558: {
                    PatternFacet pat = new PatternFacet(config);
                    pat.setValue("\\i\\c+");
                    list.add(pat);
                    break;
                }
                case 559: 
                case 560: 
                case 561: 
                case 563: {
                    PatternFacet pat = new PatternFacet(config);
                    pat.setValue("\\i\\c+");
                    list.add(pat);
                    pat = new PatternFacet(config);
                    pat.setValue("[\\i-[:]][\\c-[:]]*");
                    list.add(pat);
                    break;
                }
            }
        } else if (fp == 634) {
            PatternFacet pat = new PatternFacet(config);
            pat.setValue("[^YM]*(T.*)?");
            list.add(pat);
        } else if (fp == 633) {
            PatternFacet pat = new PatternFacet(config);
            pat.setValue("[^DT]*");
            list.add(pat);
        } else if (fp == 565) {
            ExplicitTimezoneFacet etf = new ExplicitTimezoneFacet();
            try {
                etf.setValue("required");
            }
            catch (SchemaException e) {
                throw new AssertionError((Object)e);
            }
            list.add(etf);
        }
        return list;
    }
}

