/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AllModelGroup;
import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.AttributeGroupReference;
import com.saxonica.ee.schema.AttributeUse;
import com.saxonica.ee.schema.AttributeWildcard;
import com.saxonica.ee.schema.ChoiceModelGroup;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ElementWildcard;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.IdentityConstraintReference;
import com.saxonica.ee.schema.Key;
import com.saxonica.ee.schema.KeyRef;
import com.saxonica.ee.schema.ModelGroup;
import com.saxonica.ee.schema.ModelGroupParticle;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SequenceModelGroup;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.Unique;
import com.saxonica.ee.schema.UserDefinedType;
import com.saxonica.ee.schema.UserSchemaComponent;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.fsa.AutomatonState;
import com.saxonica.ee.schema.fsa.CountingState;
import com.saxonica.ee.schema.fsa.Edge;
import com.saxonica.ee.schema.fsa.FiniteStateMachine;
import com.saxonica.ee.schema.fsa.NonDeterminizedState;
import com.saxonica.ee.schema.fsa.State;
import com.saxonica.ee.schema.fsa.SuffixState;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.stream.Sweep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.sort.SimpleTypeComparison;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ComplexVariety;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.OpenContentVariety;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;

public class UserComplexType
extends UserDefinedType
implements ComplexType,
UserSchemaComponent,
SerializableSchemaComponent {
    private boolean debug = false;
    private ComplexVariety variety;
    private boolean _abstract = false;
    private boolean allContent = false;
    private AttributeGroupDecl attributes = null;
    private AttributeGroupDecl extendedAttributes = null;
    private int block = 0;
    private TypeReference simpleContentTypeRef = null;
    private Particle particle;
    private Particle extendedParticle = null;
    private boolean restricted = false;
    private FiniteStateMachine machine;
    private boolean compiled = false;
    private Set<Assertion> assertions;
    private Wildcard openContentWildcard;
    private OpenContentVariety openContentMode = OpenContentVariety.ABSENT;
    private boolean openContentAppliesToEmpty;
    private Map<StructuredQName, SchemaType> contextDeterminedTypesForElements;
    private Map<StructuredQName, SimpleType> contextDeterminedTypesForAttributes;
    private int xsdVersion = 10;

    public UserComplexType(EnterpriseConfiguration config, SourceLocator locator) {
        this.setConfiguration(config);
        this.setLocator(locator);
        this.attributes = new AttributeGroupDecl(config);
        this.attributes.setLocator(locator);
        this.machine = new FiniteStateMachine(this, false);
    }

    @Override
    public ComplexVariety getVariety() {
        return this.variety;
    }

    @Override
    public String getEQName() {
        return "Q{" + this.getTargetNamespace() + "}" + this.getName();
    }

    public void setSaxonDebug(boolean debug) {
        this.debug = debug;
    }

    public int getLanguageVersion() {
        return this.xsdVersion;
    }

    public void setFiniteStateMachine(FiniteStateMachine machine) {
        this.machine = machine;
    }

    public void addAttributeUse(AttributeUse use) {
        this.attributes.addAttributeUse(use);
    }

    public void setEmptyCombinedAttributeGroup() {
        this.extendedAttributes = new AttributeGroupDecl(this.getConfiguration());
    }

    public void addNonInheritedAttributeUse(AttributeUse use) {
        this.attributes.addAttributeUse(use);
        this.extendedAttributes.addAttributeUse(use);
    }

    public void addAttributeGroupReference(AttributeGroupReference attrGroupRef) {
        this.attributes.addAttributeGroupReference(attrGroupRef);
    }

    public AttributeGroupDecl getAttributeGroup() {
        return this.attributes;
    }

    public AttributeGroupDecl getCombinedAttributeGroup() {
        if (this.extendedAttributes == null) {
            throw new IllegalStateException("Extended attribute group for complex type " + this.getDescription() + " has not been computed");
        }
        return this.extendedAttributes;
    }

    private boolean makeCombinedAttributeGroup(SchemaCompiler compiler) throws SchemaException {
        boolean result;
        if (this.extendedAttributes != null) {
            return true;
        }
        if (this.getDerivationMethod() == 2) {
            boolean result2;
            if (compiler != null && !(result2 = this.attributes.validate(compiler))) {
                return false;
            }
            SchemaType base = this.getBaseType();
            if (base.isSimpleType()) {
                this.extendedAttributes = this.attributes;
                return true;
            }
            if (base instanceof UserComplexType) {
                boolean result3 = ((UserComplexType)base).makeCombinedAttributeGroup(compiler);
                if (!result3) {
                    return false;
                }
                this.extendedAttributes = new AttributeGroupDecl(this.getConfiguration());
                this.extendedAttributes.setLocator(this);
                for (AttributeUse attributeUse : this.getAttributeGroup().getAttributeUses()) {
                    this.extendedAttributes.addAttributeUse(attributeUse);
                }
                AttributeGroupDecl baseAtts = ((UserComplexType)base).getCombinedAttributeGroup();
                for (AttributeUse att : baseAtts.getAttributeUses()) {
                    this.extendedAttributes.addAttributeUse(att);
                }
                AttributeWildcard attributeWildcard = baseAtts.getAttributeWildcard(compiler);
                AttributeWildcard thisWild = this.attributes.getAttributeWildcard(compiler);
                if (attributeWildcard != null) {
                    if (thisWild != null) {
                        Wildcard union = Wildcard.makeUnion(thisWild.getWildcard(), attributeWildcard.getWildcard(), this.getNamePool());
                        AttributeWildcard newawc = union.isInexpressible() ? thisWild : new AttributeWildcard(union);
                        this.extendedAttributes.setAnyAttribute(newawc);
                    } else {
                        this.extendedAttributes.setAnyAttribute(attributeWildcard);
                    }
                } else {
                    this.extendedAttributes.setAnyAttribute(thisWild);
                }
            } else {
                this.extendedAttributes = this.attributes;
            }
            return true;
        }
        if (compiler != null && !(result = this.attributes.validate(compiler))) {
            return false;
        }
        SchemaType base = this.getBaseType();
        this.extendedAttributes = new AttributeGroupDecl(this.getConfiguration());
        this.extendedAttributes.setLocator(this);
        IntHashMap<AttributeUse> map = new IntHashMap<AttributeUse>(20);
        if (base instanceof UserComplexType) {
            ((UserComplexType)base).makeCombinedAttributeGroup(compiler);
            AttributeGroupDecl attributeGroupDecl = ((UserComplexType)base).getCombinedAttributeGroup();
            for (AttributeUse att : attributeGroupDecl.getAttributeUses()) {
                if (att.isProhibited()) continue;
                map.put(att.getAttributeDeclaration().getFingerprint(), att);
            }
            for (AttributeUse att : this.getAttributeGroup().getAttributeUses()) {
                int key = att.getAttributeDeclaration().getFingerprint();
                AttributeUse old = (AttributeUse)map.get(key);
                if (old != null) {
                    if (att.isProhibited()) {
                        map.remove(key);
                        continue;
                    }
                    map.put(key, att);
                    continue;
                }
                map.put(key, att);
            }
            Iterator iter2 = map.valueIterator();
            while (iter2.hasNext()) {
                this.extendedAttributes.addAttributeUse((AttributeUse)iter2.next());
            }
            AttributeWildcard wat = this.getAttributeGroup().getAttributeWildcard(compiler);
            if (wat != null) {
                this.extendedAttributes.setAnyAttribute(wat);
            }
        } else {
            this.extendedAttributes = this.attributes;
        }
        return true;
    }

    @Override
    public int getBlock() {
        return this.block;
    }

    @Override
    public boolean isAbstract() {
        return this._abstract;
    }

    @Override
    public boolean isComplexContent() {
        return this.variety != ComplexVariety.SIMPLE;
    }

    @Override
    public boolean isSimpleContent() {
        return this.variety == ComplexVariety.SIMPLE;
    }

    @Override
    public boolean isAllContent() {
        return this.allContent;
    }

    public boolean computeIsAllContent() throws SchemaException {
        SchemaType base;
        if (this.isSimpleContent()) {
            return false;
        }
        if (this.particle instanceof ModelGroupParticle && ((ModelGroupParticle)this.particle).getGroup().containsAll(true)) {
            this.allContent = true;
            return true;
        }
        if (this.particle == null && this.getDerivationMethod() == 2 && (base = this.getBaseType()) instanceof ComplexType && ((ComplexType)base).isAllContent()) {
            this.allContent = true;
            return true;
        }
        this.allContent = false;
        return false;
    }

    public ModelGroupParticle getAllCompositor() throws MissingComponentException {
        SchemaType base;
        if (this.extendedParticle instanceof ModelGroupParticle) {
            ModelGroup group = ((ModelGroupParticle)this.extendedParticle).getGroup();
            if (group instanceof AllModelGroup) {
                return (ModelGroupParticle)this.extendedParticle;
            }
            if (group.containsAll(true)) {
                block6: {
                    Particle part;
                    ModelGroupParticle gpref = (ModelGroupParticle)this.extendedParticle;
                    do {
                        Iterator<Particle> iter;
                        if (!(iter = group.getParticles().iterator()).hasNext()) {
                            throw new IllegalStateException("Empty group");
                        }
                        part = iter.next();
                        if (!(part instanceof ModelGroupParticle)) break block6;
                        if (part != gpref) continue;
                        throw new IllegalStateException("Circular group");
                    } while (!((group = (gpref = (ModelGroupParticle)part).getGroup()) instanceof AllModelGroup));
                    return gpref;
                }
                throw new IllegalStateException("Failure finding xs:all model group");
            }
            return null;
        }
        if (this.extendedParticle == null && this.getDerivationMethod() == 2 && (base = this.getBaseType()) instanceof ComplexType && ((ComplexType)base).isAllContent()) {
            return ((UserComplexType)base).getAllCompositor();
        }
        return null;
    }

    public void setSimpleContentTypeReference(TypeReference ref) {
        this.simpleContentTypeRef = ref;
    }

    public TypeReference getSimpleContentTypeReference() {
        if (this.simpleContentTypeRef == null && this.isSimpleContent()) {
            SchemaType base = this.getBaseType();
            if (base.isSimpleType()) {
                this.simpleContentTypeRef = this.getBaseTypeReference();
            } else if (base instanceof UserComplexType) {
                this.simpleContentTypeRef = ((UserComplexType)base).getSimpleContentTypeReference();
            }
        }
        return this.simpleContentTypeRef;
    }

    @Override
    public SimpleType getSimpleContentType() throws MissingComponentException {
        TypeReference ref = this.getSimpleContentTypeReference();
        if (ref == null) {
            return null;
        }
        SimpleType simpleContentType = (SimpleType)ref.getTarget();
        if (simpleContentType instanceof SimpleTypeDefinition) {
            simpleContentType = ((SimpleTypeDefinition)simpleContentType).getWorkingType();
        }
        return simpleContentType;
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    @Override
    public boolean isEmptyContent() {
        return this.variety == ComplexVariety.EMPTY;
    }

    @Override
    public boolean isMixedContent() {
        return this.variety == ComplexVariety.MIXED;
    }

    @Override
    public boolean isSimpleType() {
        return false;
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isIdType() throws MissingComponentException {
        return this.isSimpleContent() && this.getSimpleContentType().isIdType();
    }

    @Override
    public boolean isIdRefType() throws MissingComponentException {
        return this.isSimpleContent() && this.getSimpleContentType().isIdRefType();
    }

    public Wildcard getOpenContentWildcard() {
        return this.openContentWildcard;
    }

    public OpenContentVariety getOpenContentMode() {
        return this.openContentMode;
    }

    public String getOpenContentModeString() {
        switch (this.openContentMode) {
            case ABSENT: {
                return "absent";
            }
            case NONE: {
                return "none";
            }
            case INTERLEAVE: {
                return "interleave";
            }
            case SUFFIX: {
                return "suffix";
            }
        }
        return null;
    }

    public void setAbstract(boolean isAbstract) {
        this._abstract = isAbstract;
    }

    public void setAnyAttribute(AttributeWildcard wildcard) {
        this.attributes.setAnyAttribute(wildcard);
    }

    public void setNonInheritedAnyAttribute(AttributeWildcard wildcard) {
        this.attributes.setAnyAttribute(wildcard);
        this.extendedAttributes.setAnyAttribute(wildcard);
    }

    public void setBlock(int block) {
        this.block = block;
    }

    public void setVariety(ComplexVariety variety) {
        this.variety = variety;
    }

    public void setRestriction(boolean restricted) {
        this.restricted = restricted;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    public void setOpenContentWildcard(Wildcard wildcard, String mode, boolean appliesToEmpty) {
        this.openContentWildcard = wildcard;
        if ("interleave".equals(mode)) {
            this.openContentMode = OpenContentVariety.INTERLEAVE;
        } else if ("suffix".equals(mode)) {
            this.openContentMode = OpenContentVariety.SUFFIX;
        } else if ("none".equals(mode)) {
            this.openContentMode = OpenContentVariety.NONE;
        } else {
            throw new IllegalArgumentException("Invalid value of open content mode - " + mode);
        }
        this.openContentAppliesToEmpty = appliesToEmpty;
    }

    public void addAssertion(Assertion assertion) {
        if (this.assertions == null) {
            this.assertions = new HashSet<Assertion>(4);
        }
        this.assertions.add(assertion);
    }

    @Override
    public boolean hasAssertions() {
        return this.assertions != null && !this.assertions.isEmpty();
    }

    public Set<Assertion> getAssertions() {
        if (this.assertions == null) {
            return Collections.emptySet();
        }
        return this.assertions;
    }

    public Set<Assertion> getAssertions(Sweep sweep) {
        if (this.assertions == null) {
            return Collections.emptySet();
        }
        HashSet<Assertion> filtered = new HashSet<Assertion>(this.assertions.size());
        for (Assertion a : this.assertions) {
            if (a.getSweep() != sweep) continue;
            filtered.add(a);
        }
        return filtered;
    }

    @Override
    public void lookForCycles(Stack<SchemaComponent> references, SchemaCompiler compiler) throws SchemaException, MissingComponentException {
        SchemaType base;
        for (Object e : references) {
            if (!((SchemaType)e).isSameType(this)) continue;
            compiler.error("The definition of the complex type " + this.getDescription() + " is circular", this);
            throw new SchemaException("Circular definition found");
        }
        references.push(this);
        this.getBaseTypeReference().tryToResolve(compiler, false);
        if (this.getBaseTypeReference().isResolved() && (base = (SchemaType)this.getBaseTypeReference().getTarget()) instanceof UserSchemaComponent) {
            ((UserSchemaComponent)((Object)base)).lookForCycles(references, compiler);
        }
        references.pop();
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        if (this.getFixupStatus() == SchemaValidationStatus.UNVALIDATED) {
            boolean ok;
            this.setFixupStatus(SchemaValidationStatus.VALIDATING);
            if (this.attributes != null && !(ok = this.attributes.fixup(compiler))) {
                this.setFixupStatus(SchemaValidationStatus.INVALID);
                return false;
            }
            if (this.simpleContentTypeRef != null) {
                boolean ok2;
                SchemaType type = (SchemaType)PreparedSchema.validateReference(this.simpleContentTypeRef, compiler, false);
                if (type == null) {
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
                if (type instanceof UserSchemaComponent && !(ok2 = ((UserSchemaComponent)((Object)type)).fixup(compiler))) {
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
            }
            if (this.getBaseTypeReference() != null) {
                SchemaType type = (SchemaType)PreparedSchema.validateReference(this.getBaseTypeReference(), compiler, true);
                if (type == null) {
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
                if (type instanceof UserSchemaComponent) {
                    ((UserSchemaComponent)((Object)type)).fixup(compiler);
                }
            }
            if (this.particle != null) {
                this.particle.fixup(compiler);
            }
        }
        this.setFixupStatus(SchemaValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        SchemaType base;
        boolean result = true;
        if (this.getFixupStatus() == SchemaValidationStatus.INVALID) {
            return false;
        }
        if (!this.isValidationNeeded()) {
            return true;
        }
        this.setValidationStatus(SchemaValidationStatus.VALIDATING);
        this.xsdVersion = compiler.getLanguageVersion();
        if (this.particle != null && !(result = this.particle.validate(compiler))) {
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        if (this.getBaseTypeReference() != null) {
            PreparedSchema.validateReference(this.getBaseTypeReference(), compiler, true);
            if (!this.getBaseTypeReference().isResolved()) {
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
        }
        if ((base = this.getBaseType()) instanceof UserComplexType) {
            this.lookForCycles(new Stack<SchemaComponent>(), compiler);
            result = ((UserComplexType)base).validate(compiler);
            for (Assertion a : ((UserComplexType)base).getAssertions()) {
                this.addAssertion(a);
            }
        }
        if (result & this.isSimpleContent()) {
            result &= this.validateSimpleContent(compiler, base);
        }
        if (result) {
            result = this.makeCombinedAttributeGroup(compiler);
        }
        if (result) {
            result = this.extendedAttributes.validate(compiler);
        }
        if (this.getDerivationMethod() == 2) {
            result &= this.validateExtension(compiler, base);
        }
        if (this.getDerivationMethod() == 1) {
            result &= this.validateRestriction(compiler, base);
        }
        this.allContent = this.computeIsAllContent();
        if (result) {
            this.compile(compiler);
        }
        this.setValidationStatus(result ? SchemaValidationStatus.VALIDATED : SchemaValidationStatus.INVALID);
        return result;
    }

    private boolean validateSimpleContent(SchemaCompiler compiler, SchemaType base) throws SchemaException {
        SimpleType content;
        if (this.simpleContentTypeRef == null) {
            if (this.getValidationStatus() == SchemaValidationStatus.INVALID) {
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
            if (base.isSimpleType()) {
                this.simpleContentTypeRef = this.getBaseTypeReference();
            } else if (base.isComplexType() && ((ComplexType)base).isSimpleContent()) {
                this.simpleContentTypeRef = ((UserComplexType)base).getSimpleContentTypeReference();
            } else {
                String err = "The complex type " + this.getDescription();
                err = err + " has simple content but its base type has complex content";
                compiler.error(err, this);
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
        }
        if ((content = (SimpleType)PreparedSchema.validateReference(this.getSimpleContentTypeReference(), compiler, false)) instanceof SimpleTypeDefinition) {
            SchemaType type = compiler.getPreparedSchema().getSchemaType(content.getStructuredQName());
            if (type != null) {
                if (type.getValidationStatus() == SchemaValidationStatus.INVALID) {
                    this.setValidationStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
                if (type.isSimpleType()) {
                    if (type instanceof SimpleTypeDefinition) {
                        type = ((SimpleTypeDefinition)type).getWorkingType();
                    }
                    this.getSimpleContentTypeReference().setTarget(type);
                } else {
                    String err = "The complex type " + this.getDescription();
                    err = err + " has simple content that references a complex type";
                    compiler.error(err, this);
                    this.setValidationStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
            }
            if (this.getSimpleContentType() instanceof UserSimpleType) {
                return ((UserSimpleType)this.getSimpleContentType()).validate(compiler);
            }
        }
        return true;
    }

    private boolean validateExtension(SchemaCompiler compiler, SchemaType base) throws SchemaException {
        Object p;
        String err;
        String err2;
        EnterpriseConfiguration config;
        if (base instanceof UserDefinedType) {
            Set<UserComplexType> existingExtensions = ((UserDefinedType)base).getExtensionTypes();
            for (UserComplexType ex : existingExtensions) {
                if (!ex.getTypeName().equals(this.getTypeName()) || !ex.isSameType(this)) continue;
                return true;
            }
        }
        if ((config = this.getConfiguration()).isSealedNamespace(base.getTargetNamespace())) {
            err2 = "It is not possible to extend type " + base.getDescription() + " because that type has already been used for validating instance documents or for compiling queries or stylesheets";
            compiler.error(err2, this);
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        if (!base.allowsDerivation(2)) {
            err2 = "The complex type " + this.getDescription() + " is derived by extension, but the base type prohibits extension";
            compiler.error(err2, this);
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        if (this.variety == ComplexVariety.ELEMENT_ONLY && this.isLocallyEmpty() && this.isEmptyContent(base)) {
            this.variety = ComplexVariety.EMPTY;
            this.particle = null;
        }
        if (this.isComplexContent() && base.isSimpleType()) {
            err2 = "The type " + this.getDescription() + " has complex content so it cannot be based on the simple type " + base.getDescription();
            compiler.error(err2, this);
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        if (compiler.getLanguageVersion() == 10) {
            if (UserComplexType.isAllParticle(this.particle) && !this.isEmptyContent(base)) {
                err2 = "The type " + this.getDescription() + " is defined with xs:all so (in XSD 1.0) it cannot be derived by extension from a non-empty type";
                compiler.error(err2, this);
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
            if (!this.isLocallyEmpty() && base instanceof UserComplexType && UserComplexType.isAllParticle(((UserComplexType)base).particle)) {
                err2 = "In XSD 1.0, a type cannot be derived by extension from a type defined using xs:all unless the extension is empty";
                compiler.error(err2, this);
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
        } else {
            if (UserComplexType.isAllParticle(this.particle) && base instanceof UserComplexType) {
                if (UserComplexType.isAllParticle(((UserComplexType)base).particle)) {
                    AllModelGroup amg = (AllModelGroup)((ModelGroupParticle)((UserComplexType)base).particle).getGroup();
                    if (amg.getSimplifiedContentModel().isEmpty() && ((UserComplexType)base).isMixedContent()) {
                        err = "The type " + this.getDescription() + " defined with xs:all cannot be derived by extension from a base type that is defined using xs:all with mixed content but no element content. This is because the base type is treated as if the compositor were xs:sequence rather than xs:all";
                        compiler.error(err, this);
                        this.setValidationStatus(SchemaValidationStatus.INVALID);
                        return false;
                    }
                    if (this.particle.getMinOccurs() != ((UserComplexType)base).particle.getMinOccurs()) {
                        err = "The type " + this.getDescription() + " defined with xs:all cannot be derived by extension from a base type that is defined using xs:all because the two xs:all particles have different minOccurs values";
                        compiler.error(err, this);
                        this.setValidationStatus(SchemaValidationStatus.INVALID);
                        return false;
                    }
                    p = this.makeExtendedParticle(compiler);
                    boolean validParticle = ((Particle)p).validate(compiler);
                    if (!validParticle) {
                        this.setValidationStatus(SchemaValidationStatus.INVALID);
                        return false;
                    }
                } else if (!((UserComplexType)base).isEmptyContent()) {
                    err2 = "The type " + this.getDescription() + " is defined with xs:all so it cannot be derived by extension unless the base type is empty or is itself defined with xs:all";
                    compiler.error(err2, this);
                    this.setValidationStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
            }
            if (!this.isLocallyEmpty() && !UserComplexType.isAllParticle(this.particle) && base instanceof UserComplexType && UserComplexType.isAllParticle(((UserComplexType)base).particle)) {
                err2 = "A type cannot be derived by extension from a type defined using xs:all unless the extension is empty or the extension is itself defined using xs:all";
                compiler.error(err2, this);
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
        }
        if (this.isComplexContent() && base instanceof UserComplexType && ((UserComplexType)base).isSimpleContent()) {
            if (this.isLocallyEmpty() && compiler.getLanguageVersion() == 10) {
                this.setVariety(ComplexVariety.SIMPLE);
                this.setValidationStatus(SchemaValidationStatus.UNVALIDATED);
                return this.validate(compiler);
            }
            err2 = "The type " + this.getDescription() + " has complex content so it cannot be derived by extension from the complex type " + base.getDescription() + " which has simple content";
            compiler.error(err2, this);
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        if (this.isSimpleContent() && !base.isSimpleType()) {
            if (base instanceof AnyType) {
                err2 = "The type " + this.getDescription() + " has simple content so it cannot be derived by extension from xs:anyType";
                compiler.error(err2, this);
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
            if (!((ComplexType)base).isSimpleContent()) {
                err2 = "The type " + this.getDescription() + " has simple content so it cannot be derived by extension from the type " + base.getDescription() + " which has complex content";
                compiler.error(err2, this);
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
        }
        if (base.isComplexType()) {
            SchemaType g;
            int derivation;
            ComplexType cbase = (ComplexType)base;
            if (this.isMixedContent()) {
                if (!(base instanceof AnyType || cbase.isMixedContent() || cbase.isEmptyContent())) {
                    err = "The type " + this.getDescription() + " has mixed content, so its base type must have mixed or empty content";
                    compiler.error(err, this);
                    this.setValidationStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
            } else if (this.particle != null) {
                if (base instanceof ComplexType && cbase.isMixedContent()) {
                    err = "The type " + this.getDescription() + " has element-only content, so it cannot be derived by extension from a type with mixed content";
                    compiler.error(err, this);
                    this.setValidationStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
            } else if (this.isLocallyEmpty() && base instanceof ComplexType && cbase.isMixedContent()) {
                this.setVariety(ComplexVariety.MIXED);
            }
            if (base instanceof UserComplexType) {
                if (this.openContentMode == OpenContentVariety.NONE) {
                    // empty if block
                }
                if (this.openContentWildcard == null) {
                    this.openContentWildcard = ((UserComplexType)base).getOpenContentWildcard();
                    this.openContentMode = ((UserComplexType)base).getOpenContentMode();
                } else {
                    boolean baseOpenWildcardInterleaved;
                    Wildcard baseOpenWildcard = ((UserComplexType)base).getOpenContentWildcard();
                    boolean bl = baseOpenWildcardInterleaved = ((UserComplexType)base).getOpenContentMode() == OpenContentVariety.INTERLEAVE;
                    if (baseOpenWildcard != null) {
                        if (this.openContentWildcard != null && baseOpenWildcardInterleaved && this.openContentMode != OpenContentVariety.INTERLEAVE) {
                            String err3 = "Invalid extension. The type " + this.getDescription() + " has interleaved open content, but its base type has suffix open content";
                            compiler.error(err3, this);
                            this.setValidationStatus(SchemaValidationStatus.INVALID);
                            return false;
                        }
                        if (this.openContentWildcard == null) {
                            String err4 = "Invalid extension. The base type of type " + this.getDescription() + " allows open content, but this type does not";
                            compiler.error(err4, this);
                            this.setValidationStatus(SchemaValidationStatus.INVALID);
                            return false;
                        }
                        if (this.openContentWildcard != null) {
                            this.openContentWildcard = Wildcard.makeUnion(this.openContentWildcard, baseOpenWildcard, this.getNamePool());
                        }
                    }
                }
            }
            if (this.isComplexContent()) {
                boolean ok;
                p = this.makeExtendedParticle(compiler);
                boolean bl = ok = p == null || ((Particle)p).validate(compiler);
                if (!ok) {
                    this.setValidationStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
            }
            for (AttributeUse au : this.attributes.getAttributeUses()) {
                StructuredQName fp = au.getTargetComponentName();
                if (!(base instanceof UserComplexType)) continue;
                SchemaType baseComplexType = base;
                while (baseComplexType instanceof UserComplexType) {
                    SimpleType original;
                    AttributeUse baseAttributeUse;
                    derivation = baseComplexType.getDerivationMethod();
                    g = baseComplexType.getBaseType();
                    if (g instanceof UserComplexType && derivation == 1 && (baseAttributeUse = ((UserComplexType)g).getCombinedAttributeGroup().getAttributeUse(fp)) != null && (original = baseAttributeUse.getAttributeDeclaration().getType()) != null) {
                        SimpleType derived = au.getAttributeDeclaration().getType();
                        try {
                            derived.checkTypeDerivationIsOK(original, 0);
                        }
                        catch (SchemaException se) {
                            String err5 = "The type " + this.getDescription() + " is derived by extension, and reintroduces attribute " + fp.getStructuredQName().getEQName() + " which was defined in the content model of the ancestor type " + g.getDescription() + " with an incompatible type. " + se.getMessage();
                            compiler.error(err5, this);
                            this.setValidationStatus(SchemaValidationStatus.INVALID);
                            return false;
                        }
                    }
                    baseComplexType = g;
                }
            }
            if (this.particle != null) {
                IntHashSet extensionElements = new IntHashSet(10);
                this.particle.gatherAllPermittedElements(extensionElements, true);
                IntIterator extensionElementIter = extensionElements.iterator();
                while (extensionElementIter.hasNext()) {
                    int fp = extensionElementIter.next();
                    if (!(base instanceof UserComplexType)) continue;
                    SchemaType particleBaseType = base;
                    while (particleBaseType instanceof UserComplexType) {
                        SchemaType original;
                        derivation = particleBaseType.getDerivationMethod();
                        g = particleBaseType.getBaseType();
                        if (g instanceof UserComplexType && derivation == 1 && (original = ((UserComplexType)g).getElementParticleType(fp, false)) != null) {
                            SchemaType derived = this.particle.getElementParticleType(fp);
                            try {
                                derived.checkTypeDerivationIsOK(original, 0);
                            }
                            catch (SchemaException se) {
                                String err6 = "The type " + this.getDescription() + " is derived by extension, and reintroduces element " + this.getNamePool().getClarkName(fp) + " which was defined in the content model of the ancestor type " + g.getDescription() + " with an incompatible type. " + se.getMessage();
                                compiler.error(err6, this);
                                this.setValidationStatus(SchemaValidationStatus.INVALID);
                                return false;
                            }
                        }
                        particleBaseType = g;
                    }
                }
            }
        }
        SchemaType baseType = base;
        while (true) {
            if (baseType instanceof UserDefinedType) {
                if (baseType instanceof SimpleTypeDefinition) {
                    baseType = ((SimpleTypeDefinition)baseType).getWorkingType();
                }
                ((UserDefinedType)baseType).registerExtensionType(this);
                baseType = baseType.getBaseType();
                continue;
            }
            if (!(baseType instanceof SimpleType) || !((SimpleType)baseType).isBuiltInType()) break;
            compiler.getPreparedSchema().registerExtensionOfBuiltInType(baseType.getFingerprint(), this);
            baseType = baseType.getBaseType();
        }
        return true;
    }

    private boolean validateRestriction(SchemaCompiler compiler, SchemaType base) throws SchemaException {
        if (!base.allowsDerivation(1)) {
            String err = "The complex type " + this.getDescription() + " is derived by restriction, but the base type prohibits restriction";
            compiler.error(err, this);
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        if (this.variety == ComplexVariety.ELEMENT_ONLY && (this.openContentWildcard == null || !this.openContentAppliesToEmpty) && this.isLocallyEmpty()) {
            this.variety = ComplexVariety.EMPTY;
            this.particle = null;
        }
        if (base.isSimpleType()) {
            String err = "The complex type " + this.getDescription();
            err = err + " is defined as a restriction of the simple type ";
            err = err + base.getDescription();
            compiler.error(err, this);
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        if (base.isComplexType()) {
            String err;
            ComplexType cbase = (ComplexType)base;
            boolean OK = false;
            if (this.isSimpleContent()) {
                if (cbase.isSimpleContent()) {
                    SimpleType thisContent = this.getSimpleContentType();
                    SimpleType baseContent = cbase.getSimpleContentType();
                    String reason = thisContent == null || baseContent == null ? "Cannot establish the simple content type" : UserSimpleType.isTypeDerivationOK(thisContent, baseContent, 0);
                    if (reason == null) {
                        OK = true;
                    } else {
                        String err2 = "The complex type " + this.getDescription() + " has simple content of a type that is not validly derived from that of the base type. " + reason;
                        compiler.error(err2, this);
                        this.setValidationStatus(SchemaValidationStatus.INVALID);
                        return false;
                    }
                }
                if (!OK) {
                    if (!cbase.isMixedContent()) {
                        err = "The complex type " + this.getDescription();
                        err = err + " has simple content so its base type, if complex, must have mixed content";
                        compiler.error(err, this);
                        this.setValidationStatus(SchemaValidationStatus.INVALID);
                        return false;
                    }
                    if (!((ComplexType)base).isEmptiable()) {
                        err = "The complex type " + this.getDescription() + " has simple content so its base type, if complex, must allow empty content";
                        compiler.error(err, this);
                        this.setValidationStatus(SchemaValidationStatus.INVALID);
                        return false;
                    }
                    SchemaType simpleContentBase = this.getSimpleContentType().getBaseType();
                    if (simpleContentBase == null || simpleContentBase instanceof AnySimpleType) {
                        String err3 = "The complex type " + this.getDescription() + " has simple content and its base type is a mixed complex type, so it must specify a simpleType";
                        compiler.error(err3, this);
                        this.setValidationStatus(SchemaValidationStatus.INVALID);
                        return false;
                    }
                }
            } else if (cbase.isSimpleContent()) {
                String err4 = "The complex type " + this.getDescription() + " has complex content, but is derived by restriction from a base type that has simple content";
                compiler.error(err4, this);
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
            if (this.isMixedContent() && !((ComplexType)base).isMixedContent()) {
                err = "The complex type " + this.getDescription() + " has mixed content so its base type must also have mixed content";
                compiler.error(err, this);
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
            if (this.particle != null) {
                if (this.particle.isPointless(null)) {
                    ModelGroup group = ((ModelGroupParticle)this.particle).getGroup();
                    List<Particle> contentModel = group.getSimplifiedContentModel();
                    if (!(this.variety != ComplexVariety.ELEMENT_ONLY || !contentModel.isEmpty() || group instanceof ChoiceModelGroup || this.openContentWildcard != null && this.openContentAppliesToEmpty)) {
                        this.particle = null;
                        this.variety = ComplexVariety.EMPTY;
                    } else if (contentModel.size() == 1 && !(group instanceof AllModelGroup)) {
                        this.particle = contentModel.get(0);
                    }
                } else if (this.particle instanceof ModelGroupParticle && this.particle.getMinOccurs() == 1 && this.particle.getMaxOccurs() == 1) {
                    ((ModelGroupParticle)this.particle).getGroup().getSimplifiedContentModel();
                }
            }
            return this.isValidRestriction(base, compiler);
        }
        return true;
    }

    private static boolean isAllParticle(Particle particle) throws MissingComponentException {
        return particle instanceof ModelGroupParticle && ((ModelGroupParticle)particle).getGroup() instanceof AllModelGroup;
    }

    private boolean isLocallyEmpty() throws MissingComponentException {
        if (this.isSimpleContent()) {
            return false;
        }
        if (this.particle == null || this.particle.getMaxOccurs() == 0) {
            return true;
        }
        if (this.particle instanceof ModelGroupParticle) {
            ModelGroup group = ((ModelGroupParticle)this.particle).getGroup();
            return group.isEmpty() && (group instanceof AllModelGroup || group instanceof SequenceModelGroup || group instanceof ChoiceModelGroup && this.particle.getMinOccurs() == 0);
        }
        return false;
    }

    private boolean isEmptyContent(SchemaType type) {
        return type instanceof ComplexType && ((ComplexType)type).isEmptyContent();
    }

    public boolean isValidRestriction(SchemaType base, SchemaCompiler compiler) throws SchemaException {
        String subsumeError;
        if (base instanceof AnyType) {
            return true;
        }
        if (this == base) {
            return true;
        }
        if (this.getValidationStatus() == SchemaValidationStatus.INVALID || base.getValidationStatus() == SchemaValidationStatus.INVALID) {
            return false;
        }
        ComplexType cbase = (ComplexType)base;
        this.makeCombinedAttributeGroup(compiler);
        if (cbase instanceof UserComplexType) {
            UserComplexType ucbase = (UserComplexType)cbase;
            ucbase.makeCombinedAttributeGroup(compiler);
            if (!ucbase.compiled) {
                ucbase.compile(compiler);
            }
        }
        if (cbase instanceof UserComplexType && !this.getCombinedAttributeGroup().isValidRestriction(((UserComplexType)cbase).getCombinedAttributeGroup(), compiler)) {
            compiler.error("The attributes of complex type " + this.getDescription() + " are not a restricted subset of the attributes of the type " + base.getDescription(), this);
            return false;
        }
        if (!this.compiled) {
            this.compile(compiler);
        }
        if ((subsumeError = this.isSubsumedBy(cbase, compiler)) != null) {
            if (subsumeError.startsWith("?")) {
                compiler.error("Saxon is unable to determine whether or not the content model of the complex type " + this.getDescription() + " is a valid restriction of the content model of the type " + base.getDescription() + ". " + subsumeError.substring(1), this);
            } else {
                compiler.error("The content model of the complex type " + this.getDescription() + " is not a valid restriction of the content model of the type " + base.getDescription() + ". " + subsumeError, this);
            }
            return false;
        }
        return true;
    }

    public void compile(SchemaCompiler compiler) throws SchemaException {
        if (this.compiled || this.getValidationStatus() == SchemaValidationStatus.INVALID) {
            return;
        }
        if (this.debug) {
            Logger err = compiler.getConfiguration().getLogger();
            err.info("==== Compiling complex type " + this.getDescription());
            err.info("  simple content: " + this.isSimpleContent());
            err.info("  complex content: " + this.isComplexContent());
            err.info("  all content: " + this.isAllContent());
            err.info("  empty content: " + this.isEmptyContent());
            err.info("  emptiable: " + this.isEmptiable());
            err.info("  mixed content: " + this.isMixedContent());
            err.info("  base type: " + this.getBaseType().getDescription());
        }
        this.compiled = true;
        if (this.isSimpleContent() || this.isEmptyContent()) {
            this.machine.getInitialState().setFinalState(true);
        } else if (this.isAllContent()) {
            this.makeExtendedParticle(compiler);
        } else {
            Particle extended = this.makeExtendedParticle(compiler);
            if (extended == null) {
                this.machine.getInitialState().setFinalState(true);
                this.machine.setOpenContentWildcard(this.openContentWildcard, this.openContentMode == OpenContentVariety.INTERLEAVE);
            } else {
                compiler.scheduleAutomaton(this);
                if (this.particle != null) {
                    this.particle.compile(compiler);
                }
            }
        }
        this.makeCombinedAttributeGroup(compiler);
        this.makeContextDeterminedTypeMapForAttributes();
        this.makeContextDeterminedTypeMapForElements();
    }

    protected void makeAutomaton(SchemaCompiler compiler) throws SchemaException {
        Particle extended = this.extendedParticle;
        NonDeterminizedState finalState = new NonDeterminizedState(this.machine);
        finalState.setFinalState(true);
        try {
            Logger err;
            NonDeterminizedState state = FiniteStateMachine.compileParticle(compiler, extended, finalState, this, this.machine);
            this.machine.setInitialState(state);
            if (this.debug) {
                err = compiler.getConfiguration().getLogger();
                err.info("==== NFSA for complex type " + this.getDescription());
                this.machine.display(err);
            }
            this.machine = FiniteStateMachine.determinize(compiler, this.machine);
            if (this.debug) {
                err = compiler.getConfiguration().getLogger();
                err.info("==== DFSA for complex type " + this.getDescription());
                this.machine.display(err);
            }
            this.machine.setOpenContentWildcard(this.openContentWildcard, this.openContentMode == OpenContentVariety.INTERLEAVE);
        }
        catch (SchemaException err) {
            compiler.error("Error in complex type " + this.getDescription() + ": " + err.getMessage(), this);
            throw err;
        }
    }

    public void recompile(SchemaCompiler compiler) throws SchemaException {
        if (this.debug) {
            this.getConfiguration().getLogger().info("Recompiling type " + this.getDescription());
        }
        this.compiled = false;
        this.compile(compiler);
    }

    public void cancelValidation() {
        this.setValidationStatus(SchemaValidationStatus.UNVALIDATED);
        this.compiled = false;
    }

    public FiniteStateMachine getFiniteStateMachine() {
        return this.machine;
    }

    public State getInitialState() {
        AutomatonState as = this.machine.getInitialState();
        if (as.requiresCounter()) {
            return new CountingState(as, 0);
        }
        return as;
    }

    public Particle makeExtendedParticle(SchemaCompiler compiler) throws SchemaException {
        ModelGroup group;
        if (this.extendedParticle != null) {
            return this.extendedParticle;
        }
        if (compiler != null) {
            this.lookForCycles(new Stack<SchemaComponent>(), compiler);
        }
        if (this.getDerivationMethod() == 2) {
            ComplexType cbase = (ComplexType)this.getBaseType();
            if (this.isAllContent() || cbase.isAllContent()) {
                if (cbase.isEmptyContent()) {
                    this.extendedParticle = this.particle;
                } else if (this.isLocallyEmpty()) {
                    this.extendedParticle = ((UserComplexType)cbase).getParticle();
                } else {
                    AllModelGroup all = new AllModelGroup();
                    all.setLocator(this);
                    ModelGroupParticle base = (ModelGroupParticle)((UserComplexType)cbase).makeExtendedParticle(compiler);
                    for (Particle p : base.getGroup().getParticles()) {
                        ((ModelGroup)all).addParticle(p);
                    }
                    for (Particle p : ((ModelGroupParticle)this.particle).getGroup().getParticles()) {
                        ((ModelGroup)all).addParticle(p);
                    }
                    ((SchemaStructure)all).elaborate(compiler);
                    ModelGroupParticle mgp = new ModelGroupParticle(this.getConfiguration(), this);
                    mgp.setTarget(all);
                    mgp.setLocator(this);
                    this.extendedParticle = mgp;
                    this.extendedParticle.setMinOccurs(this.particle.getMinOccurs());
                    this.variety = this.variety == ComplexVariety.MIXED ? ComplexVariety.MIXED : ComplexVariety.ELEMENT_ONLY;
                }
                return this.extendedParticle;
            }
            if (cbase instanceof UserComplexType) {
                SequenceModelGroup seq = new SequenceModelGroup();
                Particle base = ((UserComplexType)cbase).makeExtendedParticle(compiler);
                if (base != null) {
                    seq.addParticle(base);
                }
                if (this.particle != null) {
                    seq.addParticle(this.particle);
                }
                if (((ModelGroup)seq).isPointless(null)) {
                    List<Particle> contentModel = seq.getSimplifiedContentModel();
                    if (contentModel.isEmpty() && (this.openContentWildcard == null || !this.openContentAppliesToEmpty)) {
                        this.extendedParticle = null;
                        if (this.variety == ComplexVariety.ELEMENT_ONLY) {
                            this.variety = ComplexVariety.EMPTY;
                        }
                    } else if (contentModel.size() == 1) {
                        this.extendedParticle = contentModel.get(0);
                    } else {
                        ModelGroupParticle mgp = new ModelGroupParticle(this.getConfiguration(), this);
                        mgp.setTarget(seq);
                        this.extendedParticle = mgp;
                    }
                } else {
                    ModelGroupParticle mgp = new ModelGroupParticle(this.getConfiguration(), this);
                    mgp.setTarget(seq);
                    this.extendedParticle = mgp;
                }
                if (this.extendedParticle != null) {
                    this.extendedParticle.markVulnerableSubParticles();
                }
                return this.extendedParticle;
            }
            if (cbase instanceof AnyType) {
                if (this.isLocallyEmpty()) {
                    ElementWildcard any = new ElementWildcard(this.getConfiguration());
                    any.setMinOccurs(0);
                    any.setMaxOccurs(-1);
                    any.getWildcard().setProcessContents("lax");
                    this.extendedParticle = any;
                    return this.extendedParticle;
                }
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                String err = "xs:anyType cannot be extended, because any non-empty extension creates an ambiguity";
                if (compiler == null) {
                    throw new IllegalStateException(err);
                }
                compiler.error(err, this);
                this.extendedParticle = this.particle;
                return this.particle;
            }
            throw new IllegalStateException("Unknown implementation of ComplexType: " + (cbase == null ? "null" : cbase.getClass()));
        }
        if (this.particle == null) {
            this.extendedParticle = null;
            return this.extendedParticle;
        }
        Particle p = this.particle;
        if (p instanceof ModelGroupParticle && p.getMinOccurs() == 1 && p.getMaxOccurs() == 1 && (group = ((ModelGroupParticle)p).getGroup()).getSimplifiedContentModel().size() == 1 && !(group instanceof AllModelGroup)) {
            p = group.getSimplifiedContentModel().get(0);
        }
        if (p.isPointless(null) && p instanceof ModelGroupParticle) {
            List<Particle> contentModel = ((ModelGroupParticle)p).getGroup().getSimplifiedContentModel();
            if (!(this.variety != ComplexVariety.ELEMENT_ONLY || !contentModel.isEmpty() || ((ModelGroupParticle)p).getGroup() instanceof ChoiceModelGroup || this.openContentWildcard != null && this.openContentAppliesToEmpty)) {
                this.extendedParticle = null;
                this.variety = ComplexVariety.EMPTY;
            } else {
                this.extendedParticle = contentModel.size() == 1 ? contentModel.get(0) : p;
            }
        } else {
            this.extendedParticle = p;
        }
        if (this.extendedParticle != null) {
            this.extendedParticle.markVulnerableSubParticles();
        }
        return this.extendedParticle;
    }

    public Particle getParticle() {
        return this.extendedParticle;
    }

    @Override
    public boolean isEmptiable() throws MissingComponentException {
        Particle p = this.getParticle();
        return p == null || p.isEmptiable();
    }

    @Override
    public SchemaType getElementParticleType(int elementName, boolean considerExtensions) throws MissingComponentException {
        SchemaType child;
        Particle p = this.getParticle();
        SchemaType schemaType = child = p == null ? null : p.getElementParticleType(elementName);
        if (child != null) {
            return child;
        }
        if (considerExtensions) {
            if (this.openContentWildcard != null && this.openContentWildcard.matches(elementName, true, (Configuration)this.getConfiguration(), this)) {
                return AnyType.getInstance();
            }
            for (UserComplexType ext : this.getExtensionTypes()) {
                SchemaType st = ext.getElementParticleType(elementName, false);
                if (st == null) continue;
                if (child == null) {
                    child = st;
                    continue;
                }
                if (child == st) continue;
                return AnyType.getInstance();
            }
            return child;
        }
        return null;
    }

    @Override
    public int getElementParticleCardinality(int elementName, boolean considerExtensions) throws MissingComponentException {
        Particle p = this.getParticle();
        int baseCardinality = p == null ? 8192 : p.getElementParticleCardinality(elementName);
        if (this.openContentWildcard != null && this.openContentWildcard.matches(elementName, true, (Configuration)this.getConfiguration(), this)) {
            return 57344;
        }
        if (considerExtensions) {
            for (UserComplexType ext : this.getExtensionTypes()) {
                if (baseCardinality == 57344) {
                    return baseCardinality;
                }
                int extCardinality = ext.getElementParticleCardinality(elementName, false);
                baseCardinality = Cardinality.union(baseCardinality, extCardinality);
            }
        }
        return baseCardinality;
    }

    @Override
    public SimpleType getAttributeUseType(StructuredQName attributeName) throws SchemaException {
        AttributeGroupDecl ag = this.getCombinedAttributeGroup();
        AttributeUse use = ag.getAttributeUse(attributeName);
        if (use != null && !use.isProhibited()) {
            return ((AttributeDecl)use.getTarget()).getType();
        }
        SimpleType attType = null;
        for (UserComplexType ext : this.getExtensionTypes()) {
            SimpleType st = ext.getAttributeUseType(attributeName);
            if (st == null) continue;
            if (attType == null) {
                attType = st;
                continue;
            }
            if (attType == st) continue;
            return AnySimpleType.getInstance();
        }
        if (attType != null) {
            return attType;
        }
        AttributeWildcard awild = ag.getAttributeWildcard(null);
        if (awild == null) {
            return null;
        }
        Wildcard wild = awild.getWildcard();
        if (wild.matches(attributeName, false, (Configuration)this.getConfiguration(), null)) {
            switch (wild.getProcessContents()) {
                case "skip": {
                    return AnySimpleType.getInstance();
                }
                case "strict": {
                    AttributeDecl decl = this.getConfiguration().getSuperSchema().getAttributeDecl(attributeName);
                    if (decl != null) {
                        return decl.getType();
                    }
                    return null;
                }
            }
            AttributeDecl decl = this.getConfiguration().getSuperSchema().getAttributeDecl(attributeName);
            if (decl != null) {
                return decl.getType();
            }
            return AnySimpleType.getInstance();
        }
        return null;
    }

    @Override
    public int getAttributeUseCardinality(StructuredQName attributeName) throws SchemaException {
        AttributeGroupDecl ag = this.getCombinedAttributeGroup();
        AttributeUse use = ag.getAttributeUse(attributeName);
        if (use != null) {
            return use.getCardinality();
        }
        int card = 0;
        for (UserComplexType ext : this.getExtensionTypes()) {
            int c = ext.getAttributeUseCardinality(attributeName);
            card |= c;
        }
        if (card != 0) {
            return card;
        }
        AttributeWildcard awild = ag.getAttributeWildcard(null);
        if (awild == null) {
            return 8192;
        }
        Wildcard wild = awild.getWildcard();
        if (wild.matches(attributeName, false, (Configuration)this.getConfiguration(), null)) {
            return 24576;
        }
        return 8192;
    }

    @Override
    public boolean allowsAttributes() throws MissingComponentException {
        AttributeGroupDecl ag = this.getCombinedAttributeGroup();
        if (!ag.getAttributeUses().isEmpty()) {
            return true;
        }
        if (ag.getAttributeWildcard(null) != null) {
            return true;
        }
        for (UserComplexType ext : this.getExtensionTypes()) {
            if (!ext.allowsAttributes()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsElementWildcard() throws MissingComponentException {
        if (this.extendedParticle != null && this.extendedParticle.containsElementWildcard()) {
            return true;
        }
        for (UserComplexType ext : this.getExtensionTypes()) {
            if (!ext.containsElementWildcard()) continue;
            return true;
        }
        return false;
    }

    public void makeContextDeterminedTypeMapForElements() throws SchemaException {
        if (this.contextDeterminedTypesForElements != null) {
            return;
        }
        this.contextDeterminedTypesForElements = new HashMap<StructuredQName, SchemaType>();
        this.gatherContextDeterminedTypesForElements(this.contextDeterminedTypesForElements);
    }

    private void gatherContextDeterminedTypesForElements(Map<StructuredQName, SchemaType> map) throws SchemaException {
        Particle p;
        SchemaType base = this.getBaseType();
        if (base instanceof UserComplexType) {
            ((UserComplexType)base).gatherContextDeterminedTypesForElements(map);
        }
        if ((p = this.getParticle()) != null) {
            IntHashSet children = new IntHashSet();
            p.gatherAllPermittedElements(children, true);
            IntIterator kids = children.iterator();
            while (kids.hasNext()) {
                int fp = kids.next();
                SchemaType type = this.getElementParticleType(fp, false);
                map.put(this.getNamePool().getStructuredQName(fp), type);
            }
        }
    }

    public SchemaType getContextDeterminedTypeForElement(StructuredQName fp) {
        if (this.contextDeterminedTypesForElements == null) {
            return null;
        }
        return this.contextDeterminedTypesForElements.get(fp);
    }

    public void makeContextDeterminedTypeMapForAttributes() throws SchemaException {
        if (this.contextDeterminedTypesForAttributes != null) {
            return;
        }
        this.contextDeterminedTypesForAttributes = new HashMap<StructuredQName, SimpleType>();
        this.gatherContextDeterminedTypesForAttributes(this.contextDeterminedTypesForAttributes);
    }

    private void gatherContextDeterminedTypesForAttributes(Map<StructuredQName, SimpleType> map) throws SchemaException {
        SchemaType base = this.getBaseType();
        if (base instanceof UserComplexType) {
            ((UserComplexType)base).gatherContextDeterminedTypesForAttributes(map);
        }
        for (AttributeUse use : this.getAttributeGroup().getAttributeUses()) {
            if (use.isProhibited()) continue;
            StructuredQName fp = use.getTargetComponentName();
            SimpleType type = this.getAttributeUseType(fp);
            map.put(fp, type);
        }
    }

    public SimpleType getContextDeterminedTypeForAttribute(StructuredQName fp) {
        if (this.contextDeterminedTypesForAttributes == null) {
            return null;
        }
        return this.contextDeterminedTypesForAttributes.get(fp);
    }

    @Override
    public void gatherAllPermittedChildren(IntHashSet children, boolean ignoreWildcards) throws SchemaException {
        Particle p = this.getParticle();
        if (p == null) {
            return;
        }
        p.gatherAllPermittedElements(children, ignoreWildcards);
        if (this.extendedTypes != null) {
            for (Object extendedType : this.extendedTypes) {
                UserComplexType uct = (UserComplexType)extendedType;
                uct.gatherAllPermittedChildren(children, ignoreWildcards);
            }
        }
    }

    @Override
    public void gatherAllPermittedDescendants(IntHashSet descendants) throws SchemaException {
        Particle p = this.getParticle();
        if (p == null) {
            return;
        }
        IntHashSet permittedChildren = new IntHashSet(16);
        this.gatherAllPermittedChildren(permittedChildren, false);
        StructuredQName wildcardDummy = StandardNames.SQ_XS_INVALID_NAME;
        if (permittedChildren.contains(-1)) {
            descendants.add(-1);
            return;
        }
        IntIterator kids = permittedChildren.iterator();
        while (kids.hasNext()) {
            int c = kids.next();
            if (!descendants.add(c)) continue;
            SchemaType childType = this.getElementParticleType(c, true);
            if (childType == null) {
                throw new AssertionError((Object)("Child particle " + c + " not found"));
            }
            if (!(childType instanceof ComplexType)) continue;
            if (childType instanceof UserComplexType) {
                ((UserComplexType)childType).gatherAllPermittedDescendants(descendants);
                continue;
            }
            descendants.add(-1);
            return;
        }
    }

    @Override
    public SchemaType getDescendantElementType(int elementName) throws SchemaException {
        Iterator iter;
        HashSet<SchemaType> parentsConsidered = new HashSet<SchemaType>();
        HashSet<SchemaType> foundTypes = new HashSet<SchemaType>();
        this.getDescendantElementTypes(elementName, parentsConsidered, foundTypes);
        if (foundTypes.isEmpty()) {
            return null;
        }
        if (foundTypes.size() == 1 && (iter = foundTypes.iterator()).hasNext()) {
            return (SchemaType)iter.next();
        }
        return AnyType.getInstance();
    }

    private void getDescendantElementTypes(int elementName, Set<SchemaType> parentsConsidered, Set<SchemaType> foundTypes) throws SchemaException {
        Particle p = this.getParticle();
        if (p == null) {
            return;
        }
        SchemaType targetType = this.getElementParticleType(elementName, true);
        if (targetType != null) {
            foundTypes.add(targetType);
            if (targetType == AnyType.getInstance()) {
                return;
            }
        }
        IntHashSet permittedChildren = new IntHashSet(16);
        this.gatherAllPermittedChildren(permittedChildren, false);
        if (permittedChildren.contains(-1)) {
            foundTypes.add(AnyType.getInstance());
            return;
        }
        IntIterator kids = permittedChildren.iterator();
        while (kids.hasNext()) {
            int c = kids.next();
            SchemaType childType = this.getElementParticleType(c, true);
            if (childType == null) {
                throw new AssertionError((Object)("Child particle " + c + " not found"));
            }
            if (parentsConsidered.contains(childType)) continue;
            parentsConsidered.add(childType);
            if (!(childType instanceof ComplexType)) continue;
            if (childType instanceof UserComplexType) {
                ((UserComplexType)childType).getDescendantElementTypes(elementName, parentsConsidered, foundTypes);
                continue;
            }
            foundTypes.add(childType);
        }
    }

    @Override
    public int getDescendantElementCardinality(int elementFingerprint) throws SchemaException {
        int cardinality = 8192;
        IntHashSet children = new IntHashSet();
        this.gatherAllPermittedChildren(children, false);
        if (children.contains(-1)) {
            return 57344;
        }
        IntIterator kids = children.iterator();
        while (kids.hasNext()) {
            int child = kids.next();
            int childCard = this.getElementParticleCardinality(child, true);
            if (child == elementFingerprint && Cardinality.allowsMany(cardinality = Cardinality.sum(cardinality, childCard))) {
                return cardinality;
            }
            SchemaType childType = this.getElementParticleType(child, true);
            if (childType == null || !childType.isComplexType()) continue;
            IntHashSet childDescendants = new IntHashSet();
            ((ComplexType)childType).gatherAllPermittedDescendants(childDescendants);
            if (childDescendants.contains(-1)) {
                return 57344;
            }
            if (!childDescendants.contains(elementFingerprint) || (cardinality = Cardinality.sum(cardinality, Cardinality.multiply(childCard, ((ComplexType)childType).getDescendantElementCardinality(elementFingerprint)))) != 57344) continue;
            return cardinality;
        }
        return cardinality;
    }

    public String isSubsumedBy(ComplexType base, SchemaCompiler compiler) throws SchemaException {
        if (base instanceof AnyType) {
            return null;
        }
        if (base instanceof Untyped) {
            return "Untyped does not subsume any other type";
        }
        UserComplexType cbase = (UserComplexType)base;
        Wildcard bw = cbase.getOpenContentWildcard();
        Wildcard rw = this.getOpenContentWildcard();
        if (bw == null) {
            if (rw != null) {
                Particle bp = cbase.getParticle();
                if (bp instanceof ElementWildcard && bp.getMinOccurs() == 0 && bp.getMaxOccurs() == -1 && (this.isEmptyContent() || ((ModelGroup)this.getParticle().getTarget()).getContentModelSize() == 0) && rw.isSubset(((ElementWildcard)bp).getWildcard(), this.getNamePool())) {
                    return null;
                }
                return "Restricted type has open content; base type does not";
            }
        } else if (rw != null) {
            if (!rw.isSubset(bw, compiler.getNamePool())) {
                return "Restricted type has an open content wildcard that matches names which are not matched by the open content of the base type";
            }
            if (bw.compareStrength(rw) > 0) {
                return "The processContents on the open content wildcard of the restricted type is weaker than that on the open content wildcard of the base type";
            }
            if (!this.isLocallyEmpty()) {
                boolean rInterleaved;
                boolean bInterleaved = cbase.getOpenContentMode() == OpenContentVariety.INTERLEAVE;
                boolean bl = rInterleaved = this.getOpenContentMode() == OpenContentVariety.INTERLEAVE;
                if (rInterleaved && !bInterleaved) {
                    return "Restricted type allows interleaved open content, but base type only allows suffixed open content";
                }
            }
        }
        return cbase.subsumes(this, compiler);
    }

    private String subsumes(UserComplexType sub, SchemaCompiler compiler) throws SchemaException {
        this.computeIsAllContent();
        if (!sub.getAssertions().containsAll(this.getAssertions())) {
            return "The assertions defined on complex type " + this.getDescription() + " are not a subset of the assertions defined on the type " + sub.getDescription();
        }
        sub.computeIsAllContent();
        if (this.isAllContent()) {
            return AllModelGroup.allSubsumes(this, sub, compiler);
        }
        if (sub.isAllContent()) {
            return this.subsumesAll(sub, compiler);
        }
        if (sub.isEmptyContent()) {
            if (this.isEmptiable()) {
                return null;
            }
            return "Derived type has empty content model, but base type does not allow empty content";
        }
        compiler.scheduleAutomatonCheck(this, sub);
        return null;
    }

    protected static String elementParticleMatches(ElementDecl base, ElementDecl sub, SchemaCompiler compiler) throws MissingComponentException {
        SchemaType baseType = base.getType();
        SchemaType subType = sub.getType();
        if (sub.isNillable() && !base.isNillable()) {
            return "Element " + UserComplexType.eName(sub) + " in derived type is nillable but element " + UserComplexType.eName(base) + " in base type is not";
        }
        if (base.getFixedValue() != null) {
            if (sub.getFixedValue() == null) {
                return "Element " + UserComplexType.eName(base) + " in base type has a fixed value, but element " + UserComplexType.eName(sub) + " in derived type does not";
            }
            if (!SimpleTypeComparison.getInstance().equal(sub.getFixedValue(), base.getFixedValue())) {
                return "Element " + UserComplexType.eName(sub) + " in derived type has a different fixed value from element " + UserComplexType.eName(base) + " in base type";
            }
        }
        boolean elementTypeOK = true;
        String reason = null;
        if (subType.isSimpleType()) {
            reason = UserSimpleType.isTypeDerivationOK((SimpleType)subType, baseType, 0);
            elementTypeOK = reason == null;
        } else {
            while (!baseType.isSameType(subType)) {
                if (subType.getDerivationMethod() != 1) {
                    elementTypeOK = false;
                    break;
                }
                if ((subType = subType.getBaseType()) != null) continue;
                elementTypeOK = false;
                break;
            }
        }
        if (!elementTypeOK) {
            return "The type of element " + UserComplexType.eName(sub) + " in the restricted content model is not validly derived from the type of the corresponding element " + UserComplexType.eName(sub) + " in the base content model" + (reason == null ? "" : ". " + reason);
        }
        if (base.getFixedValue() != null && !SimpleTypeComparison.getInstance().equal(base.getFixedValue(), sub.getFixedValue())) {
            return "The fixed value of element " + UserComplexType.eName(sub) + " in the base content model is not reflected in the corresponding element " + UserComplexType.eName(sub) + " of the restricted content model";
        }
        HashSet<IdentityConstraint> baseUniqueSet = new HashSet<IdentityConstraint>(4);
        HashSet<IdentityConstraint> baseKeySet = new HashSet<IdentityConstraint>(4);
        HashSet<IdentityConstraint> baseKeyRefSet = new HashSet<IdentityConstraint>(4);
        for (IdentityConstraintReference icr : base.getIdentityConstraints()) {
            IdentityConstraint ic = icr.getTarget();
            if (ic instanceof Unique) {
                baseUniqueSet.add(ic);
                continue;
            }
            if (ic instanceof Key) {
                baseKeySet.add(ic);
                continue;
            }
            if (!(ic instanceof KeyRef)) continue;
            baseKeyRefSet.add(ic);
        }
        HashSet<IdentityConstraint> subUniqueSet = new HashSet<IdentityConstraint>(4);
        HashSet<IdentityConstraint> subKeySet = new HashSet<IdentityConstraint>(4);
        HashSet<IdentityConstraint> subKeyRefSet = new HashSet<IdentityConstraint>(4);
        for (IdentityConstraintReference icr : sub.getIdentityConstraints()) {
            IdentityConstraint ic = icr.getTarget();
            if (ic instanceof Unique) {
                subUniqueSet.add(ic);
                continue;
            }
            if (ic instanceof Key) {
                subKeySet.add(ic);
                continue;
            }
            if (!(ic instanceof KeyRef)) continue;
            subKeyRefSet.add(ic);
        }
        if (baseUniqueSet.size() > subUniqueSet.size()) {
            return "Element " + UserComplexType.eName(base) + "in the base type has an xs:unique constraint that is not present in the restricted type";
        }
        if (baseKeySet.size() > subKeySet.size()) {
            return "Element " + UserComplexType.eName(sub) + " in the base type has an xs:key constraint that is not present in the restricted type";
        }
        if (baseKeyRefSet.size() > subKeyRefSet.size()) {
            return "Element " + UserComplexType.eName(sub) + " in the base type has an xs:keyref constraint that is not present in the restricted type";
        }
        if (baseUniqueSet.size() + baseKeySet.size() + baseKeyRefSet.size() > 0) {
            compiler.warning("Saxon is not able to verify that the identity constraints in element " + UserComplexType.eName(sub) + " are compatible with those in the base type", "SXSD1009", sub);
        }
        if ((base.getBlock() & ~sub.getBlock()) != 0) {
            return "The disallowed substitutions of element " + UserComplexType.eName(sub) + "in the restricted content model (@block) must be a superset of those in the base content model";
        }
        return null;
    }

    private static String eName(ElementDecl e) {
        return Err.wrap(e.getDisplayName(), 1);
    }

    public String subsumesAll(UserComplexType sub, SchemaCompiler compiler) throws SchemaException {
        AllModelGroup subAll = (AllModelGroup)sub.getAllCompositor().getGroup();
        if (subAll.getNumberOfElementParticles() == 1) {
            SequenceModelGroup seq = new SequenceModelGroup();
            seq.addParticle(subAll.getSimplifiedContentModel().get(0));
            Particle temp = sub.getParticle();
            sub.setParticle(subAll.getSimplifiedContentModel().get(0));
            String message = this.subsumes(sub, compiler);
            sub.setParticle(temp);
            return message;
        }
        Particle base = this.makeExtendedParticle(compiler);
        EnterpriseConfiguration config = this.getConfiguration();
        if (base instanceof ElementWildcard) {
            int min = 0;
            int max = 0;
            for (Particle p : subAll.getParticles()) {
                min += p.getMinOccurs();
                max += p.getMaxOccurs();
                if (((ElementWildcard)base).getWildcard().matches(p.getTargetComponentName(), true, (Configuration)config, this)) continue;
                NamespaceUri uri = p.getTargetComponentName().getNamespaceUri();
                return "The base type does not allow elements in " + (uri.isEmpty() ? "no namespace" : "namespace " + uri);
            }
            if (min < base.getMinOccurs()) {
                return "The derived type allows fewer elements to appear than the base type requires in its @minOccurs";
            }
            if (base.getMaxOccurs() >= 0 && max > base.getMaxOccurs()) {
                return "The derived type allows more elements to appear than the base type permits in its @maxOccurs";
            }
            return null;
        }
        return "A type using xs:all cannot be validly derived from this base type";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyzeContentExpression(Expression expression, int kind) throws XPathException {
        EnterpriseConfiguration config = this.getConfiguration();
        TypeHierarchy th = ((Configuration)config).getTypeHierarchy();
        for (AttributeUse attributeUse : this.getAttributeGroup().getAttributeUses()) {
            if (!attributeUse.isRequired()) continue;
            if (th.relationship(expression.getItemType(), NodeKindTest.ATTRIBUTE) == Affinity.DISJOINT) {
                throw new XPathException("Type " + this.getDescription() + " defines a mandatory attribute " + attributeUse.getTargetComponentName().getDisplayName() + ", but there is no instruction to create such an attribute").withLocation(expression.getLocation()).asStaticError();
            }
            if (!(expression instanceof Block)) continue;
            Operand[] children = ((Block)expression).getOperanda();
            boolean foundPossible = false;
            if (children != null) {
                for (Operand o : children) {
                    Expression child = o.getChildExpression();
                    if (child instanceof FixedAttribute) {
                        if (((FixedAttribute)child).getAttributeFingerprint() != attributeUse.getAttributeDeclaration().getFingerprint()) continue;
                        foundPossible = true;
                        break;
                    }
                    if (th.relationship(child.getItemType(), NodeKindTest.ATTRIBUTE) == Affinity.DISJOINT) continue;
                    foundPossible = true;
                    break;
                }
            }
            if (foundPossible) continue;
            XPathException err = new XPathException("Type " + this.getDescription() + " defines a mandatory attribute " + attributeUse.getTargetComponentName().getDisplayName() + ", but there is no instruction to create such an attribute").withLocation(expression.getLocation()).asStaticError();
            throw err;
        }
        if (expression instanceof Block) {
            Operand[] children = ((Block)expression).getOperanda();
            if (children == null) {
                return;
            }
            for (Operand o : children) {
                o.getChildExpression().checkPermittedContents(this, false);
            }
            if (this.getFiniteStateMachine() != null && !this.isAllContent()) {
                void var6_9;
                State state = this.getInitialState();
                for (Operand o : children) {
                    Expression child = o.getChildExpression();
                    if (child instanceof FixedElement) {
                        NodeName elementName = ((FixedElement)child).getFixedElementName();
                        int fingerprint = ((FixedElement)child).getFixedElementName().getFingerprint();
                        Edge edge = var6_9.getTransition(fingerprint, this);
                        if (edge == null) {
                            FiniteStateMachine machine = this.getFiniteStateMachine();
                            Wildcard openContentWildcard = machine.getOpenContentWildcard();
                            if (openContentWildcard != null && openContentWildcard.matches(elementName, true, (Configuration)this.getConfiguration(), this)) {
                                if (machine.isOpenContentInterleaved()) continue;
                                if (var6_9.isFinalState()) {
                                    SuffixState suffixState = SuffixState.getInstance();
                                    continue;
                                }
                            }
                            if (var6_9.isFinalState() && !this.getExtensionTypes().isEmpty()) break;
                            CharSequence sb = var6_9.listAllowedElements();
                            String message = var6_9 instanceof SuffixState ? "The content model does not allow element " + Err.wrap(elementName.getDisplayName(), 1) + " to appear after an element that matches the suffix open content wildcard. " : "The content model does not allow element " + Err.wrap(elementName.getDisplayName(), 1) + " to appear here" + (openContentWildcard == null ? "" : " (it does not match the open content wildcard)") + ". " + sb;
                            throw new XPathException(message, "XPTY0004").withLocation(child.getLocation());
                        }
                        try {
                            State state2 = edge.makeTransition((State)var6_9);
                            continue;
                        }
                        catch (ValidationException e) {
                            throw new XPathException(e.getMessage(), "XPTY0004").withLocation(expression.getLocation());
                        }
                    }
                    ItemType t = child.getItemType();
                    if (th.relationship(t, NodeKindTest.ELEMENT) == Affinity.DISJOINT) continue;
                    return;
                }
                if (!var6_9.isFinalState()) {
                    int len = children.length;
                    if (len == 0) {
                        throw new XPathException("The generated content is empty: the schema requires at least one child element").withErrorCode("XPTY0004").withLocation(expression.getLocation());
                    }
                    throw new XPathException("The generated content is incomplete: the schema requires further child elements").withErrorCode("XPTY0004").withLocation(children[len - 1].getChildExpression().getLocation());
                }
            }
        } else {
            expression.checkPermittedContents(this, true);
        }
    }

    @Override
    public AtomicSequence atomize(NodeInfo node) throws XPathException {
        if (this.isSimpleContent()) {
            if (node.isNilled()) {
                return EmptyAtomicSequence.getInstance();
            }
            try {
                return this.getSimpleContentType().atomize(node);
            }
            catch (MissingComponentException e) {
                throw new XPathException("Can't get typed value; node is annotated with an incomplete type definition");
            }
        }
        if (this.isMixedContent()) {
            if (node.isNilled()) {
                return EmptyAtomicSequence.getInstance();
            }
            return StringValue.makeUntypedAtomic(node.getUnicodeStringValue());
        }
        if (this.isEmptyContent()) {
            return EmptyAtomicSequence.getInstance();
        }
        throw new XPathException("Cannot get the typed value of an element (" + node.getDisplayName() + ") with element-only content").withErrorCode("FOTY0012").asTypeError();
    }

    public static void checkTypeDerivation(ComplexType derived, SchemaType base, int block) throws SchemaException {
        boolean sameType = derived.isSameType(base);
        if (!sameType && (derived.getDerivationMethod() & block) != 0) {
            throw new SchemaException("Derivation of the requested type " + derived.getDescription() + " is blocked either by the base type " + derived.getDescription() + " or by the element declaration");
        }
        if (sameType) {
            return;
        }
        SchemaType baseTypeOfD = derived.getBaseType();
        if (baseTypeOfD == null) {
            baseTypeOfD = AnyType.getInstance();
        }
        if (base.isSameType(baseTypeOfD)) {
            return;
        }
        if (baseTypeOfD == AnyType.getInstance()) {
            throw new SchemaException("The requested type " + derived.getDescription() + " is not derived from the declared type " + base.getDescription());
        }
        if (baseTypeOfD.isComplexType()) {
            try {
                UserComplexType.checkTypeDerivation((ComplexType)baseTypeOfD, base, block);
            }
            catch (SchemaException err) {
                throw new SchemaException("The requested type " + derived.getDescription() + " is not validly derived from the declared type " + base.getDescription());
            }
        } else {
            String err = UserSimpleType.isTypeDerivationOK((SimpleType)baseTypeOfD, base, block);
            if (err != null) {
                throw new SchemaException("The requested type " + derived.getDescription() + " is not validly derived from the declared type " + base.getDescription() + ". " + err);
            }
        }
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        if (this.getValidationStatus() != SchemaValidationStatus.VALIDATED) {
            SchemaType base = this.getBaseType();
            if (base instanceof UserComplexType) {
                ((UserComplexType)base).elaborate(compiler);
            }
            this.xsdVersion = compiler.getLanguageVersion();
            this.extendedParticle = this.particle;
            if (this.particle != null) {
                this.particle.elaborate(compiler);
            }
            this.makeCombinedAttributeGroup(null);
            this.computeIsAllContent();
            this.extendedAttributes.buildCounterMap();
            for (AttributeUse att : this.extendedAttributes.getAttributeUses()) {
                att.elaborate(compiler);
            }
            this.makeContextDeterminedTypeMapForAttributes();
            this.makeContextDeterminedTypeMapForElements();
            this.setValidationStatus(SchemaValidationStatus.VALIDATED);
        }
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String varietyName;
        String id = serializer.getId(this, true);
        serializer.startElement("complexType");
        serializer.emitAttribute("id", id);
        if (!this.isAnonymousType()) {
            serializer.emitAttribute("name", this.getName());
            if (!this.getTargetNamespace().isEmpty()) {
                serializer.emitAttribute("targetNamespace", this.getTargetNamespace().toString());
            }
        }
        serializer.emitAttribute("base", serializer.getTypeLink(this.getBaseType()));
        if (this.finalProhibitions != 0) {
            String ex = "";
            if ((this.finalProhibitions & 2) != 0) {
                ex = (ex.isEmpty() ? "" : " ") + "extension";
            }
            if ((this.finalProhibitions & 1) != 0) {
                ex = ex + (ex.isEmpty() ? "" : " ") + "restriction";
            }
            serializer.emitAttribute("final", ex);
        }
        if (this.block != 0) {
            String dis = "";
            if ((this.block & 2) != 0) {
                dis = "extension";
            }
            if ((this.block & 1) != 0) {
                dis = dis + (dis.isEmpty() ? "" : " ") + "restriction";
            }
            serializer.emitAttribute("block", dis);
        }
        serializer.emitAttribute("derivationMethod", this.getDerivationMethod() == 2 ? "extension" : "restriction");
        serializer.emitAttribute("abstract", this.isAbstract() ? "true" : "false");
        switch (this.variety) {
            case EMPTY: {
                varietyName = "empty";
                break;
            }
            case MIXED: {
                varietyName = "mixed";
                break;
            }
            case SIMPLE: {
                varietyName = "simple";
                break;
            }
            default: {
                varietyName = "element-only";
            }
        }
        serializer.emitAttribute("variety", varietyName);
        if (this.isSimpleContent()) {
            SimpleType st = this.getSimpleContentType();
            serializer.emitAttribute("simpleType", serializer.getTypeLink(st));
        }
        if (this.openContentWildcard != null && this.openContentMode != OpenContentVariety.ABSENT && this.openContentMode != OpenContentVariety.NONE) {
            String modeName;
            switch (this.openContentMode) {
                default: {
                    throw new IllegalStateException("openContent mode must be suffix or interleave");
                }
                case INTERLEAVE: {
                    modeName = "interleave";
                    break;
                }
                case SUFFIX: {
                    modeName = "suffix";
                }
            }
            String openContentId = serializer.getId(this.openContentWildcard, false);
            serializer.startElement("openContent");
            serializer.emitAttribute("mode", modeName);
            serializer.emitAttribute("wildcard", openContentId);
            serializer.endElement();
        }
        this.getCombinedAttributeGroup().serializeContents(serializer);
        if (this.isComplexContent()) {
            Particle particle = this.getParticle();
            if (particle != null) {
                particle.serializeParticle(serializer);
            }
            if (this.machine.getInitialState() != null) {
                this.machine.serialize(serializer);
            }
        }
        if (this.hasAssertions()) {
            for (Assertion assertion : this.getAssertions()) {
                assertion.serialize(serializer);
            }
        }
        serializer.endElement();
    }

    @Override
    public FunctionItem getComponentAsFunction() {
        return UserComplexType.getComponentAsFunction(this);
    }

    public static FunctionItem getComponentAsFunction(ComplexType type) {
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Complex Type Definition");
                }
                case "implementation": {
                    return new ObjectValue<ComplexType>(type);
                }
                case "name": {
                    if (type.isAnonymousType()) {
                        return EmptySequence.getInstance();
                    }
                    return new StringValue(type.getName(), (AtomicType)BuiltInAtomicType.NCNAME);
                }
                case "target namespace": {
                    if (type.isAnonymousType()) {
                        return EmptySequence.getInstance();
                    }
                    return new AnyURIValue(type.getTargetNamespace().toUnicodeString());
                }
                case "base type definition": {
                    return type.getBaseType().getComponentAsFunction();
                }
                case "final": {
                    ArrayList<AtomicValue> list = new ArrayList<AtomicValue>();
                    int f = type.getFinalProhibitions();
                    if ((f & 1) != 0) {
                        list.add(StringValue.bmp("restriction"));
                    }
                    if ((f & 2) != 0) {
                        list.add(StringValue.bmp("extension"));
                    }
                    return new AtomicArray(list);
                }
                case "context": {
                    if (type instanceof UserComplexType && !type.isAnonymousType()) {
                        return EmptySequence.getInstance();
                    }
                    return EmptySequence.getInstance();
                }
                case "derivation method": {
                    return new StringValue(type.getDerivationMethod() == 1 ? "restriction" : "extension");
                }
                case "abstract": {
                    return BooleanValue.get(type.isAbstract());
                }
                case "attribute uses": {
                    if (type instanceof UserComplexType) {
                        ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                        for (AttributeUse use : ((UserComplexType)type).getAttributeGroup().getLocalAttributes()) {
                            list.add(use.getComponentAsFunction());
                        }
                        return SequenceExtent.makeSequenceExtent(list);
                    }
                    return EmptySequence.getInstance();
                }
                case "attribute wildcard": {
                    if (type instanceof UserComplexType) {
                        AttributeWildcard wild = ((UserComplexType)type).getAttributeGroup().getLocalAttributeWildcard();
                        return wild.getComponentAsFunction();
                    }
                    return EmptySequence.getInstance();
                }
                case "content type": {
                    CallableDelegate content = new CallableDelegate((context2, arguments2) -> {
                        String key2;
                        switch (key2 = arguments2[0].head().getStringValue()) {
                            case "class": {
                                return StringValue.bmp("Content Type");
                            }
                            case "variety": {
                                String variety;
                                switch (type.getVariety()) {
                                    case ELEMENT_ONLY: {
                                        variety = "element-only";
                                        break;
                                    }
                                    case EMPTY: {
                                        variety = "empty";
                                        break;
                                    }
                                    case MIXED: {
                                        variety = "mixed";
                                        break;
                                    }
                                    default: {
                                        variety = "simple";
                                    }
                                }
                                return StringValue.bmp(variety);
                            }
                            case "particle": {
                                if (type.getVariety() == ComplexVariety.MIXED || type.getVariety() == ComplexVariety.ELEMENT_ONLY) {
                                    return ((UserComplexType)type).getParticle().getComponentAsFunction();
                                }
                                return EmptySequence.getInstance();
                            }
                            case "open content": {
                                if (type instanceof UserComplexType) {
                                    UserComplexType ctype = (UserComplexType)type;
                                    String mode = ctype.getOpenContentModeString();
                                    if ("interleave".equals(mode) || "suffix".equals(mode)) {
                                        CallableDelegate open = new CallableDelegate((context3, arguments3) -> {
                                            String key3;
                                            switch (key3 = arguments[0].head().getStringValue()) {
                                                case "class": {
                                                    return StringValue.bmp("Open Content");
                                                }
                                                case "mode": {
                                                    return new StringValue(mode);
                                                }
                                                case "wildcard": {
                                                    return ctype.getOpenContentWildcard().getComponentAsFunction();
                                                }
                                            }
                                            return EmptySequence.getInstance();
                                        });
                                        return new CallableFunction(1, (Callable)open, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
                                    }
                                    return EmptySequence.getInstance();
                                }
                                return EmptySequence.getInstance();
                            }
                            case "simple type definition": {
                                if (type.isSimpleContent()) {
                                    return type.getSimpleContentType().getComponentAsFunction();
                                }
                                return EmptySequence.getInstance();
                            }
                        }
                        return EmptySequence.getInstance();
                    });
                    return new CallableFunction(1, (Callable)content, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
                }
                case "prohibited substitutions": {
                    ArrayList<AtomicValue> list = new ArrayList<AtomicValue>();
                    int s = type.getBlock();
                    if ((s & 2) != 0) {
                        list.add(StringValue.bmp("extension"));
                    }
                    if ((s & 1) != 0) {
                        list.add(StringValue.bmp("restriction"));
                    }
                    return new AtomicArray(list);
                }
                case "assertions": {
                    if (type instanceof UserComplexType) {
                        ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                        for (Assertion assertion : ((UserComplexType)type).getAssertions()) {
                            list.add(assertion.getComponentAsFunction());
                        }
                        return SequenceExtent.makeSequenceExtent(list);
                    }
                    return EmptySequence.getInstance();
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }

    @Override
    public String getPreferredJsonLayout() {
        if (this.isSimpleContent()) {
            return "simple-plus";
        }
        if (this.isEmptyContent()) {
            if (this.allowsAttributes()) {
                return "empty-plus";
            }
            return "empty";
        }
        if (this.isAllContent()) {
            return "record";
        }
        if (this.isMixedContent()) {
            return "mixed";
        }
        if (this.containsElementWildcard() || this.openContentMode == OpenContentVariety.SUFFIX || this.openContentMode == OpenContentVariety.INTERLEAVE) {
            return "sequence";
        }
        IntHashSet children = new IntHashSet();
        try {
            this.gatherAllPermittedChildren(children, false);
        }
        catch (SchemaException e) {
            return "mixed";
        }
        if (children.size() == 1) {
            IntIterator iter = children.iterator();
            iter.hasNext();
            int fp = iter.next();
            int card = this.getElementParticleCardinality(fp, true);
            if (Cardinality.allowsMany(card)) {
                return (this.allowsAttributes() ? "list-plus" : "list") + "/" + fp;
            }
            return "record";
        }
        return "sequence";
    }
}

