/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AssertionFacet;
import com.saxonica.ee.schema.EnumerationFacet;
import com.saxonica.ee.schema.EnumerationFacetSet;
import com.saxonica.ee.schema.ExplicitTimezoneFacet;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.FractionDigitsFacet;
import com.saxonica.ee.schema.LengthFacet;
import com.saxonica.ee.schema.MaxExclusiveFacet;
import com.saxonica.ee.schema.MaxInclusiveFacet;
import com.saxonica.ee.schema.MaxLengthFacet;
import com.saxonica.ee.schema.MinExclusiveFacet;
import com.saxonica.ee.schema.MinInclusiveFacet;
import com.saxonica.ee.schema.MinLengthFacet;
import com.saxonica.ee.schema.PatternFacet;
import com.saxonica.ee.schema.PreprocessFacet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.TotalDigitsFacet;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.WhitespaceFacet;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.validate.ValidationContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;

public class UserAtomicType
extends UserSimpleType
implements AtomicType {
    private Optional<Boolean> namespaceSensitive = Optional.empty();
    private StringConverter stringConverter;
    private static final Set<Class<? extends Facet>> STRING_FACETS = UserAtomicType.newFacetSet();
    private static final Set<Class<? extends Facet>> BOOLEAN_FACETS = UserAtomicType.newFacetSet();
    private static final Set<Class<? extends Facet>> ORDERED_FACETS = UserAtomicType.newFacetSet();
    private static final Set<Class<? extends Facet>> CALENDAR_FACETS = UserAtomicType.newFacetSet();
    private static final Set<Class<? extends Facet>> DECIMAL_FACETS = UserAtomicType.newFacetSet();

    private static Set<Class<? extends Facet>> newFacetSet() {
        return new HashSet<Class<? extends Facet>>(16);
    }

    public UserAtomicType(EnterpriseConfiguration config) {
        this.setConfiguration(config);
    }

    @Override
    public boolean isAtomicType() {
        return true;
    }

    @Override
    public boolean isPlainType() {
        return true;
    }

    @Override
    public boolean isIdType() {
        return this.getBuiltInBaseType().isIdType();
    }

    @Override
    public boolean isIdRefType() throws MissingComponentException {
        return this.getBaseType().isIdRefType();
    }

    @Override
    public boolean isBuiltInType() {
        return false;
    }

    @Override
    public String getBasicAlphaCode() {
        return ((AtomicType)this.getBuiltInBaseType()).getBasicAlphaCode();
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    @Override
    public UType getUType() {
        return this.getPrimitiveItemType().getUType();
    }

    @Override
    public boolean isOrdered(boolean optimistic) {
        return this.getPrimitiveItemType().isOrdered(false);
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public StringConverter getStringConverter(ConversionRules rules) {
        if (this.stringConverter == null) {
            StringConverter sc;
            AtomicType prim = this.getPrimitiveItemType();
            if (prim.getFingerprint() == 513) {
                sc = this.getBuiltInBaseType() == BuiltInAtomicType.STRING ? new StringConverter.StringToStringSubtype(rules, this) : new StringConverter.StringToDerivedStringSubtype(rules, this);
            } else {
                StringConverter first = this.getPrimitiveItemType().getStringConverter(rules);
                Converter.DownCastingConverter second = new Converter.DownCastingConverter(this, rules);
                sc = new StringConverter.StringToNonStringDerivedType(first, second);
            }
            if (rules instanceof ValidationContext && ((ValidationContext)rules).hasValidationParams()) {
                return sc;
            }
            this.stringConverter = sc;
        }
        return this.stringConverter;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        if (!super.validate(compiler)) {
            return false;
        }
        if (this.getBaseType() instanceof SimpleTypeDefinition) {
            UserSimpleType simpleType = ((SimpleTypeDefinition)this.getBaseType()).getWorkingType();
            this.getBaseTypeReference().setTarget(simpleType);
        }
        AtomicType prim = this.getPrimitiveItemType();
        Set<Class<? extends Facet>> allowed = null;
        switch (prim.getFingerprint()) {
            case 513: 
            case 527: 
            case 528: 
            case 529: 
            case 530: 
            case 531: {
                allowed = STRING_FACETS;
                break;
            }
            case 514: {
                allowed = BOOLEAN_FACETS;
                break;
            }
            case 516: 
            case 517: 
            case 518: 
            case 633: 
            case 634: {
                allowed = ORDERED_FACETS;
                break;
            }
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: {
                allowed = CALENDAR_FACETS;
                break;
            }
            case 515: 
            case 533: {
                allowed = DECIMAL_FACETS;
            }
        }
        for (Facet fac : this.getExtendedFacetList()) {
            if (allowed != null && allowed.contains(fac.getClass())) continue;
            compiler.error("The " + fac.getName() + " facet is not applicable to types derived from " + prim.getDisplayName(), this);
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy th) {
        return item instanceof AtomicValue && Type.isSubType(((AtomicValue)item).getItemType(), this);
    }

    @Override
    public ValidationFailure validateContent(UnicodeString value, NamespaceResolver nsResolver, ConversionRules rules) {
        StringConverter converter = this.getStringConverter(rules);
        if (this.isNamespaceSensitive()) {
            if (nsResolver == null) {
                throw new UnsupportedOperationException("Cannot validate a QName without a namespace resolver");
            }
            converter = (StringConverter)converter.setNamespaceResolver(nsResolver);
        }
        return converter.validate(value);
    }

    @Override
    public AtomicValue getTypedValue(UnicodeString value, NamespaceResolver resolver, ConversionRules rules) throws ValidationException {
        StringConverter converter = this.getStringConverter(rules);
        assert (converter != null);
        if (this.isNamespaceSensitive()) {
            converter = (StringConverter)converter.setNamespaceResolver(resolver);
        }
        return converter.convertString(value).asAtomic();
    }

    @Override
    public AtomicType getPrimitiveItemType() {
        try {
            ItemType s = (ItemType)((Object)this.getBaseType());
            if (s.isPlainType()) {
                return (AtomicType)s.getPrimitiveItemType();
            }
            return this;
        }
        catch (ClassCastException err) {
            if (this.getBaseType() == AnySimpleType.getInstance()) {
                return this;
            }
            if (Type.isPrimitiveAtomicType(this.getFingerprint())) {
                return this;
            }
            this.getConfiguration().getLogger().info("Internal failure on type " + this.getDescription());
            throw err;
        }
    }

    @Override
    public int getPrimitiveType() {
        SchemaType s = this.getBaseType();
        if (s.isAtomicType()) {
            return ((AtomicType)s).getPrimitiveType();
        }
        return this.getFingerprint();
    }

    @Override
    public boolean isNamespaceSensitive() {
        if (!this.namespaceSensitive.isPresent()) {
            SimpleType base = this;
            int fp = base.getFingerprint();
            while (fp > 1023) {
                SchemaType b = base.getBaseType();
                if (b instanceof ComplexType) {
                    try {
                        base = ((ComplexType)b).getSimpleContentType();
                    }
                    catch (MissingComponentException e) {
                        return true;
                    }
                } else {
                    base = (SimpleType)b;
                }
                fp = base.getFingerprint();
            }
            boolean sensitive = fp == 530 || fp == 531;
            this.namespaceSensitive = Optional.of(sensitive);
            return sensitive;
        }
        return this.namespaceSensitive.get();
    }

    @Override
    public AtomicType getAtomizedItemType() {
        return this;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy th) {
        return true;
    }

    public String getSharedInstance(String value) {
        EnumerationFacetSet facet = (EnumerationFacetSet)this.getFacet(EnumerationFacet.class);
        if (facet == null) {
            return value;
        }
        return facet.getSharedInstance(value);
    }

    @Override
    public String toString() {
        return this.getTypeName().getEQName();
    }

    @Override
    public String toExportString() {
        if (this.isAnonymousType()) {
            return ((AtomicType)TypeHierarchy.getNearestNamedType(this)).toExportString();
        }
        return this.toString();
    }

    public int hashCode() {
        return this.getFingerprint();
    }

    @Override
    public ValidationFailure validate(AtomicValue primValue, UnicodeString lexicalValue, ConversionRules rules) {
        ValidationFailure vf;
        BuiltInAtomicType base = (BuiltInAtomicType)this.getBuiltInBaseType();
        if (!base.isPrimitiveType() && (vf = base.validate(primValue, lexicalValue, rules)) != null) {
            return vf;
        }
        return this.checkAgainstFacets(primValue, lexicalValue, this.getExtendedFacetList(), rules);
    }

    @Override
    protected void serializeVariety(SchemaModelSerializer serializer) throws XPathException {
        serializer.emitAttribute("variety", "atomic");
        serializer.emitAttribute("primitiveType", "#" + this.getPrimitiveItemType().getName());
    }

    @Override
    public List<? extends PlainType> getPlainMemberTypes() {
        return Collections.singletonList(this);
    }

    static {
        STRING_FACETS.add(LengthFacet.class);
        STRING_FACETS.add(MinLengthFacet.class);
        STRING_FACETS.add(MaxLengthFacet.class);
        STRING_FACETS.add(PatternFacet.class);
        STRING_FACETS.add(EnumerationFacet.class);
        STRING_FACETS.add(EnumerationFacetSet.class);
        STRING_FACETS.add(WhitespaceFacet.class);
        STRING_FACETS.add(AssertionFacet.class);
        STRING_FACETS.add(PreprocessFacet.class);
        BOOLEAN_FACETS.add(PatternFacet.class);
        BOOLEAN_FACETS.add(WhitespaceFacet.class);
        BOOLEAN_FACETS.add(AssertionFacet.class);
        BOOLEAN_FACETS.add(PreprocessFacet.class);
        ORDERED_FACETS.add(PatternFacet.class);
        ORDERED_FACETS.add(EnumerationFacet.class);
        ORDERED_FACETS.add(EnumerationFacetSet.class);
        ORDERED_FACETS.add(WhitespaceFacet.class);
        ORDERED_FACETS.add(MinInclusiveFacet.class);
        ORDERED_FACETS.add(MaxInclusiveFacet.class);
        ORDERED_FACETS.add(MinExclusiveFacet.class);
        ORDERED_FACETS.add(MaxExclusiveFacet.class);
        ORDERED_FACETS.add(AssertionFacet.class);
        ORDERED_FACETS.add(PreprocessFacet.class);
        CALENDAR_FACETS.add(PatternFacet.class);
        CALENDAR_FACETS.add(EnumerationFacet.class);
        CALENDAR_FACETS.add(EnumerationFacetSet.class);
        CALENDAR_FACETS.add(WhitespaceFacet.class);
        CALENDAR_FACETS.add(MinInclusiveFacet.class);
        CALENDAR_FACETS.add(MaxInclusiveFacet.class);
        CALENDAR_FACETS.add(MinExclusiveFacet.class);
        CALENDAR_FACETS.add(MaxExclusiveFacet.class);
        CALENDAR_FACETS.add(ExplicitTimezoneFacet.class);
        CALENDAR_FACETS.add(AssertionFacet.class);
        CALENDAR_FACETS.add(PreprocessFacet.class);
        DECIMAL_FACETS.add(TotalDigitsFacet.class);
        DECIMAL_FACETS.add(FractionDigitsFacet.class);
        DECIMAL_FACETS.add(PatternFacet.class);
        DECIMAL_FACETS.add(EnumerationFacet.class);
        DECIMAL_FACETS.add(EnumerationFacetSet.class);
        DECIMAL_FACETS.add(WhitespaceFacet.class);
        DECIMAL_FACETS.add(MinInclusiveFacet.class);
        DECIMAL_FACETS.add(MaxInclusiveFacet.class);
        DECIMAL_FACETS.add(MinExclusiveFacet.class);
        DECIMAL_FACETS.add(MaxExclusiveFacet.class);
        DECIMAL_FACETS.add(AssertionFacet.class);
        DECIMAL_FACETS.add(PreprocessFacet.class);
    }
}

