/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.AttributeUse;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.Notation;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.CheckSumFilter;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.QualifiedNameValue;

public class SchemaModelSerializer {
    private final EnterpriseConfiguration config;
    private final Receiver receiver;
    private final ComplexContentOutputter cco;
    private final LinkedList<SchemaComponent> pendingComponents = new LinkedList();
    private final IdentityHashMap<SchemaComponent, String> componentToIdMap = new IdentityHashMap(200);
    private final IdentityHashMap<SerializableSchemaComponent, String> serializedComponents = new IdentityHashMap(200);
    private int nextComponent = 0;
    private NamespaceMap namespaceMap = NamespaceMap.emptyMap();
    private boolean inStartTag = false;
    private static final FingerprintedQName XML_BASE = new FingerprintedQName("xml", NamespaceUri.XML, "base", 385);

    public SchemaModelSerializer(Configuration config, Receiver out) {
        config.checkLicensedFeature(1, "schema processing", -1);
        this.config = (EnterpriseConfiguration)config;
        NamespaceReducer reducer = new NamespaceReducer(out);
        this.receiver = new CheckSumFilter(reducer);
        this.cco = new ComplexContentOutputter(this.receiver);
    }

    public void serialize() throws XPathException {
        this.cco.open();
        this.cco.startDocument(0);
        this.startElement("schema");
        this.emitAttribute("generatedAt", DateTimeValue.getCurrentDateTime(null).getStringValue());
        this.emitAttribute("xsdVersion", this.config.getConfigurationProperty(Feature.XSD_VERSION));
        String dmk = this.config.getLicenseFeature("DMK");
        if (dmk != null) {
            this.emitAttribute("dmk", dmk);
        }
        PreparedSchema schema = this.config.getSuperSchema();
        for (SchemaType schemaType : schema.getAllTypes()) {
            SchemaType sType = schemaType;
            if (sType instanceof SimpleTypeDefinition) {
                sType = ((SimpleTypeDefinition)schemaType).getWorkingType();
            }
            if (!(sType instanceof SerializableSchemaComponent)) continue;
            this.serializeComponent((SerializableSchemaComponent)((Object)sType));
        }
        for (ElementDecl elementDecl : schema.getElementDeclarations()) {
            this.serializeComponent(elementDecl);
        }
        for (AttributeDecl attributeDecl : schema.getAttributeDeclarations()) {
            this.serializeComponent(attributeDecl);
        }
        for (ModelGroupDefinition modelGroupDefinition : schema.getAllModelGroups()) {
            this.serializeComponent(modelGroupDefinition);
        }
        for (AttributeGroupDecl attributeGroupDecl : schema.getAllAttributeGroups()) {
            this.serializeComponent(attributeGroupDecl);
        }
        for (Notation notation : schema.getAllNotations()) {
            this.serializeComponent(notation);
        }
        while (!this.pendingComponents.isEmpty()) {
            SerializableSchemaComponent component = (SerializableSchemaComponent)((Object)this.pendingComponents.getFirst());
            this.serializeComponent(component);
            this.pendingComponents.removeFirst();
        }
        this.endElement();
        if (this.receiver instanceof CheckSumFilter) {
            int c = ((CheckSumFilter)this.receiver).getChecksum();
            this.cco.processingInstruction("\u03a3", BMPString.of(Integer.toHexString(c)), Loc.NONE, 0);
            String string = ((CheckSumFilter)this.receiver).getDigest();
            this.cco.processingInstruction("\u03a32", BMPString.of(string), Loc.NONE, 0);
        }
        this.cco.endDocument();
        this.cco.close();
    }

    public void startElement(String elementName) throws XPathException {
        if (this.inStartTag) {
            this.cco.namespace("", NamespaceUri.NULL, 0);
            this.cco.startContent();
        }
        this.inStartTag = true;
        FingerprintedQName nc = new FingerprintedQName("scm", NamespaceUri.SCM, elementName);
        this.cco.startElement(nc, Untyped.getInstance(), Loc.NONE, 0);
    }

    public void endElement() throws XPathException {
        if (this.inStartTag) {
            this.cco.startContent();
            this.inStartTag = false;
        }
        this.receiver.endElement();
    }

    public void emitNamespaceContext(NamespaceResolver resolver) throws XPathException {
        NamespaceMap namespaces = NamespaceMap.fromNamespaceResolver(resolver);
        String nsDisplay = ExpressionPresenter.getNamespacesAsString(namespaces, false);
        this.emitAttribute("nsContext", nsDisplay);
    }

    public void declareNamespace(String prefix, NamespaceUri uri) throws XPathException {
        this.cco.namespace(prefix, uri, 0);
    }

    public void emitAttribute(String attributeName, String value) throws XPathException {
        if (!this.inStartTag) {
            throw new IllegalStateException("Attribute emitted when not in start tag");
        }
        NodeName nc = attributeName.equals("xml:base") ? XML_BASE : new NoNamespaceName(attributeName);
        this.cco.attribute(nc, BuiltInAtomicType.UNTYPED_ATOMIC, value, Loc.NONE, 0);
    }

    public void setIsSerialized(SerializableSchemaComponent component) {
        this.serializedComponents.put(component, "");
    }

    public String getId(SchemaComponent component, boolean forSelf) {
        if (component instanceof SimpleTypeDefinition) {
            throw new IllegalStateException("Unresolved SimpleTypeDefinition found");
        }
        if (component instanceof AttributeUse) {
            throw new IllegalStateException("AttributeUse has no ID");
        }
        if (component instanceof SerializableSchemaComponent) {
            String existing = this.componentToIdMap.get(component);
            if (existing != null) {
                return existing;
            }
            String id = "C" + this.nextComponent++;
            this.componentToIdMap.put(component, id);
            if (!forSelf) {
                this.pendingComponents.add(component);
            }
            return id;
        }
        throw new UnsupportedOperationException(component.getClass().getName());
    }

    private void serializeComponent(SerializableSchemaComponent component) throws XPathException {
        if (this.serializedComponents.get(component) == null) {
            component.serialize(this);
            this.serializedComponents.put(component, "");
        }
    }

    public void emitTypedValue(AtomicSequence value) throws XPathException {
        for (AtomicValue atom : value) {
            this.startElement("item");
            BuiltInAtomicType type = atom.getPrimitiveType();
            this.emitAttribute("type", "#" + type.getName());
            this.emitAttribute("value", atom.getUnicodeStringValue().toString());
            if (atom instanceof QualifiedNameValue) {
                this.emitAttribute("namespace", ((QualifiedNameValue)atom).getNamespaceURI().toString());
            }
            this.endElement();
        }
    }

    public String getTypeLink(SchemaType type) {
        if (type instanceof UserSimpleType || type instanceof UserComplexType) {
            return this.getId(type, false);
        }
        return "#" + type.getName();
    }
}

