/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class PreprocessFacet
extends Facet {
    Assertion action;
    Assertion reverseAction;

    public PreprocessFacet() {
    }

    public PreprocessFacet(Assertion action, Assertion reverseAction) {
        this.action = action;
        this.reverseAction = reverseAction;
    }

    @Override
    public boolean isConstraining() {
        return false;
    }

    @Override
    public String getName() {
        return "preprocess";
    }

    @Override
    public UnicodeString getValue() {
        return null;
    }

    public Assertion getAction() {
        return this.action;
    }

    public Assertion getReverseAction() {
        return this.reverseAction;
    }

    public void setAction(Assertion action) {
        this.action = action;
    }

    public void setReverseAction(Assertion action) {
        this.reverseAction = action;
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
    }

    public UnicodeString preprocess(UnicodeString input) throws ValidationException {
        XPathExpression exp = this.action.getCondition();
        try {
            XPathDynamicContext context = exp.createDynamicContext();
            if (this.action.getValueVariable() != null) {
                context.setVariable(this.action.getValueVariable(), new StringValue(input));
            }
            return exp.evaluateSingle(context).getUnicodeStringValue();
        }
        catch (XPathException err) {
            throw new ValidationException(err);
        }
    }

    public UnicodeString postprocess(UnicodeString input) throws ValidationException {
        if (this.reverseAction == null) {
            return input;
        }
        XPathExpression exp = this.reverseAction.getCondition();
        try {
            XPathDynamicContext context = exp.createDynamicContext();
            if (this.action.getValueVariable() != null) {
                context.setVariable(this.reverseAction.getValueVariable(), new StringValue(input));
            }
            return exp.evaluateSingle(context).getUnicodeStringValue();
        }
        catch (XPathException err) {
            throw new ValidationException(err);
        }
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        return true;
    }

    @Override
    public void serializeFacet(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement(this.getName());
        if (this.isFixed()) {
            serializer.emitAttribute("fixed", "true");
        }
        this.action.serialize(serializer);
        if (this.reverseAction != null) {
            this.reverseAction.serialize(serializer);
        }
        serializer.endElement();
    }

    @Override
    public FunctionItem getFacetAsFunctionItem() {
        PreprocessFacet thisFacet = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue(this.getName());
                }
                case "implementation": {
                    return new ObjectValue<PreprocessFacet>(thisFacet);
                }
                case "action": {
                    return this.action.getComponentAsFunction();
                }
                case "reverse action": {
                    return this.reverseAction.getComponentAsFunction();
                }
                case "fixed": {
                    return BooleanValue.get(this.isFixed());
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

