/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.ComponentReference;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.Notation;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SymbolSpace;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserDefinedType;
import com.saxonica.ee.schema.UserSchemaComponent;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.om.Action;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NotationSet;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntIterator;

public class PreparedSchema
implements NotationSet {
    public static final int NAMESPACE_UNKNOWN = 1;
    public static final int NAMESPACE_UNDER_CONSTRUCTION = 2;
    public static final int NAMESPACE_KNOWN = 3;
    public static final int NAMESPACE_SEALED = 4;
    private EnterpriseConfiguration config;
    private final Set<NamespaceUri> targetNamespaces = new HashSet<NamespaceUri>();
    private Map<StructuredQName, AttributeDecl> attributesByName = null;
    private IntHashMap<AttributeDecl> attributesByFingerprint = null;
    private Map<StructuredQName, AttributeGroupDecl> attributeGroups = null;
    private Map<StructuredQName, ModelGroupDefinition> groups = null;
    private Map<StructuredQName, SchemaType> typesByName = null;
    private Map<StructuredQName, SchemaType> anonymousTypesByName = null;
    private Map<StructuredQName, ElementDecl> elementsByName = null;
    private IntHashMap<ElementDecl> elementsByFingerprint = null;
    private Map<StructuredQName, IdentityConstraint> identityConstraints;
    private Map<StructuredQName, Notation> notations;
    private NamePool namePool;
    private transient List<UserSchemaComponent> components;
    private IntHashMap<Set<UserComplexType>> extensionsOfBuiltInTypes;
    private HashMap<StructuredQName, GlobalParam> params;
    private int localLicenseId = -1;

    protected PreparedSchema() {
    }

    public PreparedSchema(EnterpriseConfiguration config) {
        this.namePool = config.getNamePool();
        this.config = config;
        this.attributesByName = new HashMap<StructuredQName, AttributeDecl>(10);
        this.attributesByFingerprint = new IntHashMap(10);
        this.attributeGroups = new HashMap<StructuredQName, AttributeGroupDecl>(20);
        this.groups = new HashMap<StructuredQName, ModelGroupDefinition>(20);
        this.typesByName = new HashMap<StructuredQName, SchemaType>(100);
        this.elementsByName = new HashMap<StructuredQName, ElementDecl>(100);
        this.elementsByFingerprint = new IntHashMap(100);
        this.anonymousTypesByName = new HashMap<StructuredQName, SchemaType>(100);
        this.params = new HashMap(10);
    }

    public void setConfiguration(EnterpriseConfiguration config) {
        this.config = config;
    }

    public EnterpriseConfiguration getConfiguration() {
        return this.config;
    }

    public void setLocalLicenseId(int id) {
        this.localLicenseId = id;
    }

    public int getLocalLicenseId() {
        return this.localLicenseId;
    }

    public void addComponent(UserSchemaComponent obj) {
        if (this.components == null) {
            this.components = new ArrayList<UserSchemaComponent>(20);
        }
        this.components.add(obj);
    }

    private void fixupComponentReferences(SchemaCompiler compiler) throws SchemaException {
        int errors = 0;
        if (this.components != null) {
            for (UserSchemaComponent component : this.components) {
                try {
                    boolean b = component.fixup(compiler);
                    if (b || compiler.isAllowDanglingReferences()) continue;
                    ++errors;
                }
                catch (SchemaException err) {
                    ++errors;
                    compiler.getErrorReporter().report(new XmlProcessingException(err));
                }
            }
            if (errors > 0) {
                throw new SchemaException("Errors were found in the schema");
            }
        }
    }

    private boolean isBuiltInNamespace(NamespaceUri namespace) {
        return namespace.equals(NamespaceUri.XML) || namespace.equals(NamespaceUri.FN) || namespace.equals(NamespaceUri.SCHEMA_INSTANCE);
    }

    public AttributeDecl getAttributeDecl(StructuredQName name) {
        AttributeDecl decl = this.attributesByName.get(name);
        if (decl == null && this.isBuiltInNamespace(name.getNamespaceUri())) {
            this.config.addSchemaForBuiltInNamespace(name.getNamespaceUri());
            decl = this.attributesByName.get(name);
        }
        return decl;
    }

    public AttributeDecl getAttributeDecl(int fingerprint) {
        return this.attributesByFingerprint.get(fingerprint);
    }

    public Iterable<AttributeDecl> getAttributeDeclarations() {
        return this.attributesByName.values();
    }

    public void addAttributeDecl(AttributeDecl attribute) {
        AttributeDecl oldDecl = this.attributesByName.put(attribute.getComponentName(), attribute);
        if (oldDecl != attribute) {
            this.attributesByFingerprint.put(attribute.getFingerprint(), attribute);
            this.addComponent(attribute);
            this.targetNamespaces.add(attribute.getTargetNamespace());
        }
    }

    public AttributeGroupDecl getAttributeGroup(StructuredQName name) {
        return this.attributeGroups.get(name);
    }

    public Iterable<AttributeGroupDecl> getAllAttributeGroups() {
        return this.attributeGroups.values();
    }

    public void addAttributeGroup(AttributeGroupDecl attributeGroup) {
        AttributeGroupDecl existing = this.attributeGroups.get(attributeGroup.getAttributeGroupName());
        if (existing == null || existing.getRedefinitionLevel() <= attributeGroup.getRedefinitionLevel()) {
            this.attributeGroups.put(attributeGroup.getAttributeGroupName(), attributeGroup);
            if (existing != attributeGroup) {
                this.addComponent(attributeGroup);
                this.targetNamespaces.add(attributeGroup.getTargetNamespace());
            }
        }
    }

    public ModelGroupDefinition getGroup(StructuredQName name) {
        return this.groups.get(name);
    }

    public Iterable<ModelGroupDefinition> getAllModelGroups() {
        return this.groups.values();
    }

    public void addGroup(ModelGroupDefinition group) {
        ModelGroupDefinition existing = this.groups.get(group.getModelGroupName());
        if (existing == null || existing.getRedefinitionLevel() <= group.getRedefinitionLevel()) {
            this.groups.put(group.getModelGroupName(), group);
            if (existing != group) {
                this.addComponent(group);
                this.targetNamespaces.add(group.getTargetNamespace());
            }
        }
    }

    public SchemaType getSchemaType(StructuredQName name) {
        SchemaType type;
        if (name.hasURI(NamespaceUri.SCHEMA) && (type = BuiltInType.getSchemaTypeByLocalName(name.getLocalPart())) != null) {
            return type;
        }
        return this.typesByName.get(name);
    }

    public SimpleType getSimpleType(StructuredQName name) {
        SchemaType t = this.getSchemaType(name);
        if (t instanceof SimpleType) {
            return (SimpleType)t;
        }
        return null;
    }

    public Iterable<SchemaType> getAllTypes() {
        return this.typesByName.values();
    }

    public void addType(SchemaType type) {
        SchemaType existing = this.typesByName.get(type.getStructuredQName());
        if (existing == null || existing.getRedefinitionLevel() < type.getRedefinitionLevel()) {
            this.typesByName.put(type.getStructuredQName(), type);
            if (existing != type && type instanceof UserSchemaComponent) {
                this.addComponent((UserSchemaComponent)((Object)type));
                this.targetNamespaces.add(type.getTargetNamespace());
            }
        }
    }

    public void addAnonymousType(SchemaType type) {
        this.anonymousTypesByName.put(type.getStructuredQName(), type);
    }

    public SchemaType getType(StructuredQName name) {
        SchemaType type = this.getSchemaType(name);
        if (type == null) {
            type = this.anonymousTypesByName.get(name);
        }
        return type;
    }

    public void registerExtensionOfBuiltInType(int fp, UserComplexType extension) {
        Set<UserComplexType> set;
        if (this.extensionsOfBuiltInTypes == null) {
            this.extensionsOfBuiltInTypes = new IntHashMap(20);
        }
        if ((set = this.extensionsOfBuiltInTypes.get(fp)) == null) {
            set = new HashSet<UserComplexType>(4);
            this.extensionsOfBuiltInTypes.put(fp, set);
        }
        set.add(extension);
    }

    public Set<UserComplexType> getExtensionsOfBuiltInType(int fp) {
        if (this.extensionsOfBuiltInTypes == null) {
            return Collections.emptySet();
        }
        Set<UserComplexType> set = this.extensionsOfBuiltInTypes.get(fp);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public void addElementDecl(ElementDecl elementDecl) {
        ElementDecl existing = this.elementsByName.get(elementDecl.getComponentName());
        if (existing == null || existing.getRedefinitionLevel() < elementDecl.getRedefinitionLevel()) {
            this.elementsByName.put(elementDecl.getComponentName(), elementDecl);
            this.elementsByFingerprint.put(elementDecl.getFingerprint(), elementDecl);
            if (existing != elementDecl) {
                this.addComponent(elementDecl);
                this.targetNamespaces.add(elementDecl.getTargetNamespace());
            }
        }
    }

    public ElementDecl getElementDecl(StructuredQName name) {
        ElementDecl decl = this.elementsByName.get(name);
        if (decl == null && this.isBuiltInNamespace(name.getNamespaceUri())) {
            this.config.addSchemaForBuiltInNamespace(name.getNamespaceUri());
            decl = this.elementsByName.get(name);
        }
        return decl;
    }

    public ElementDecl getElementDecl(int fingerprint) {
        return this.elementsByFingerprint.get(fingerprint);
    }

    public Iterable<ElementDecl> getElementDeclarations() {
        return this.elementsByName.values();
    }

    public void addNotation(Notation notation) {
        Map<StructuredQName, Notation> nn;
        Notation oldNotation;
        if (this.notations == null) {
            this.notations = new HashMap<StructuredQName, Notation>(20);
        }
        if ((oldNotation = (nn = this.notations).put(notation.getNotationName(), notation)) != notation) {
            this.addComponent(notation);
            this.targetNamespaces.add(notation.getTargetNamespace());
        }
    }

    public Notation getNotation(StructuredQName notationName) {
        if (this.notations == null) {
            return null;
        }
        return this.notations.get(notationName);
    }

    public Iterable<Notation> getAllNotations() {
        if (this.notations == null) {
            return Collections.emptyList();
        }
        return this.notations.values();
    }

    public void addIdentityConstraint(IdentityConstraint constraint) {
        IdentityConstraint oldConstraint;
        if (this.identityConstraints == null) {
            this.identityConstraints = new HashMap<StructuredQName, IdentityConstraint>(20);
        }
        if ((oldConstraint = this.identityConstraints.put(constraint.getConstraintName(), constraint)) != constraint) {
            this.addComponent(constraint);
            this.targetNamespaces.add(constraint.getTargetNamespace());
        }
    }

    public IdentityConstraint getIdentityConstraint(StructuredQName name) {
        if (this.identityConstraints == null) {
            return null;
        }
        return this.identityConstraints.get(name);
    }

    public Iterable<IdentityConstraint> getIdentityConstraints() {
        if (this.identityConstraints == null) {
            return Collections.emptyList();
        }
        return this.identityConstraints.values();
    }

    public Set<NamespaceUri> getTargetNamespaces() {
        return this.targetNamespaces;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void addGlobalParam(GlobalParam param) throws SchemaException {
        GlobalParam prev = this.params.put(param.getVariableQName(), param);
        if (prev != null && prev != param) {
            throw new SchemaException("Duplicate declaration of parameter " + param.getVariableQName().getEQName());
        }
    }

    public GlobalParam getGlobalParam(StructuredQName name) {
        return this.params.get(name);
    }

    public Collection<GlobalParam> getGlobalParams() {
        return this.params.values();
    }

    public void copyTo(PreparedSchema destination, SchemaCompiler compiler) throws SchemaException {
        ArrayList<Action> fixupActions = new ArrayList<Action>();
        this.checkConsistency(destination, compiler, fixupActions);
        this.copyWithoutChecking(destination);
        for (Action action : fixupActions) {
            try {
                action.doAction();
            }
            catch (XPathException e) {
                throw new SchemaException(e);
            }
        }
    }

    private void copyWithoutChecking(PreparedSchema destination) {
        SchemaType type;
        for (StructuredQName structuredQName : this.typesByName.keySet()) {
            type = this.typesByName.get(structuredQName);
            destination.addType(type);
        }
        for (SchemaType schemaType : this.anonymousTypesByName.values()) {
            type = (UserDefinedType)schemaType;
            destination.addAnonymousType(type);
        }
        for (ElementDecl elementDecl : this.elementsByName.values()) {
            destination.addElementDecl(elementDecl);
        }
        for (AttributeDecl attributeDecl : this.attributesByName.values()) {
            destination.addAttributeDecl(attributeDecl);
        }
        for (ModelGroupDefinition modelGroupDefinition : this.groups.values()) {
            destination.addGroup(modelGroupDefinition);
        }
        for (AttributeGroupDecl attributeGroupDecl : this.attributeGroups.values()) {
            destination.addAttributeGroup(attributeGroupDecl);
        }
        if (this.notations != null) {
            for (Notation notation : this.notations.values()) {
                destination.addNotation(notation);
            }
        }
        if (this.identityConstraints != null) {
            for (IdentityConstraint identityConstraint : this.identityConstraints.values()) {
                destination.addIdentityConstraint(identityConstraint);
            }
        }
        HashSet<UserSchemaComponent> destinationComponents = new HashSet<UserSchemaComponent>();
        if (destination.components != null) {
            destinationComponents.addAll(destination.components);
        }
        if (this.components != null) {
            for (UserSchemaComponent comp : this.components) {
                if (destinationComponents.contains(comp)) continue;
                destination.addComponent(comp);
            }
        }
        if (this.extensionsOfBuiltInTypes != null) {
            IntIterator intIterator = this.extensionsOfBuiltInTypes.keyIterator();
            while (intIterator.hasNext()) {
                int fp = intIterator.next();
                Set<UserComplexType> types = this.getExtensionsOfBuiltInType(fp);
                for (UserComplexType type2 : types) {
                    destination.registerExtensionOfBuiltInType(fp, type2);
                }
            }
        }
        for (GlobalParam param : this.params.values()) {
            try {
                destination.addGlobalParam(param);
            }
            catch (SchemaException err) {
                throw new IllegalStateException(err);
            }
        }
    }

    private void checkConsistency(PreparedSchema destination, SchemaCompiler compiler, List<Action> fixupActions) throws SchemaException {
        String loc;
        SchemaStructure existing;
        SchemaType type;
        boolean conflicts = false;
        for (StructuredQName structuredQName : this.typesByName.keySet()) {
            type = this.typesByName.get(structuredQName);
            SchemaType existing2 = destination.getSchemaType(structuredQName);
            if (existing2 == null || type.getRedefinitionLevel() != existing2.getRedefinitionLevel() || type.isSameType(existing2)) continue;
            String loc2 = "";
            if (existing2 instanceof SourceLocator) {
                loc2 = this.existingLocation((SourceLocator)((Object)existing2));
            }
            compiler.error("Duplicate type " + Err.wrap(type.getDisplayName()) + loc2, type instanceof Location ? (Location)((Object)type) : null);
            conflicts = true;
        }
        for (SchemaType schemaType : this.anonymousTypesByName.values()) {
            type = (UserDefinedType)schemaType;
            SchemaType existing2 = destination.getSchemaType(((UserDefinedType)type).getTypeName());
            if (existing2 == null || ((UserDefinedType)type).isSameType(existing2)) continue;
            String loc2 = "";
            if (existing2 instanceof SourceLocator) {
                loc2 = this.existingLocation((SourceLocator)((Object)existing2));
            }
            compiler.error("Duplicate type " + Err.wrap(((UserDefinedType)type).getName()) + loc2, (Location)((Object)type));
            conflicts = true;
        }
        for (ElementDecl elementDecl : this.elementsByName.values()) {
            existing = destination.getElementDecl(elementDecl.getComponentName());
            if (existing == null || ((ElementDecl)existing).isSameDeclaration(elementDecl)) continue;
            loc = this.existingLocation(existing);
            compiler.error("Duplicate element declaration " + Err.wrap(elementDecl.getDisplayName(), 1) + loc, elementDecl);
            conflicts = true;
        }
        for (AttributeDecl attributeDecl : this.attributesByName.values()) {
            existing = destination.getAttributeDecl(attributeDecl.getComponentName());
            if (existing == null || ((AttributeDecl)existing).isSameDeclaration(attributeDecl)) continue;
            loc = this.existingLocation(existing);
            compiler.error("Duplicate attribute declaration " + Err.wrap(attributeDecl.getDisplayName()) + loc, attributeDecl);
            conflicts = true;
        }
        for (ModelGroupDefinition modelGroupDefinition : this.groups.values()) {
            existing = destination.getGroup(modelGroupDefinition.getModelGroupName());
            if (existing == null || existing.getRedefinitionLevel() != modelGroupDefinition.getRedefinitionLevel() || ((ModelGroupDefinition)existing).isSameGroup(modelGroupDefinition)) continue;
            loc = this.existingLocation(existing);
            compiler.error("Duplicate group declaration " + Err.wrap(modelGroupDefinition.getName()) + loc, modelGroupDefinition);
            conflicts = true;
        }
        for (AttributeGroupDecl attributeGroupDecl : this.attributeGroups.values()) {
            existing = destination.getAttributeGroup(attributeGroupDecl.getAttributeGroupName());
            if (existing == null || existing.getRedefinitionLevel() != attributeGroupDecl.getRedefinitionLevel() || ((AttributeGroupDecl)existing).isSameDeclaration(attributeGroupDecl)) continue;
            loc = this.existingLocation(existing);
            compiler.error("Duplicate attribute group declaration " + Err.wrap(attributeGroupDecl.getDisplayName()) + loc, attributeGroupDecl);
            conflicts = true;
        }
        if (this.notations != null) {
            for (Notation notation : this.notations.values()) {
                existing = destination.getNotation(notation.getNotationName());
                if (existing == null || existing == notation || notation.isSameDeclaration((Notation)existing)) continue;
                loc = this.existingLocation(existing);
                compiler.error("Duplicate notation declaration " + Err.wrap(notation.getName()) + loc, notation);
                conflicts = true;
            }
        }
        if (this.identityConstraints != null) {
            for (IdentityConstraint identityConstraint : this.identityConstraints.values()) {
                existing = destination.getIdentityConstraint(identityConstraint.getConstraintName());
                if (existing == null || ((IdentityConstraint)existing).isSameDeclaration(identityConstraint)) continue;
                loc = this.existingLocation(existing);
                compiler.error("Duplicate identity constraint name " + Err.wrap(identityConstraint.getName()) + loc, identityConstraint);
                conflicts = true;
            }
        }
        for (GlobalParam globalParam : this.params.values()) {
            if (destination.getGlobalParam(globalParam.getVariableQName()) == null) continue;
            compiler.error("Duplicate saxon:param declaration " + globalParam.getVariableQName().getEQName(), globalParam);
            conflicts = true;
        }
        if (conflicts) {
            throw new SchemaException("Duplicated components found in schema");
        }
    }

    private String existingLocation(SourceLocator existing) {
        if (existing.getLineNumber() < 1) {
            return " - previously defined in imported component";
        }
        return " - previously defined on line " + existing.getLineNumber() + " of " + existing.getSystemId();
    }

    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        this.fixupComponentReferences(compiler);
        for (ElementDecl elementDecl : this.elementsByName.values()) {
            elementDecl.fixupSubstitutionGroup(compiler);
        }
        if (this.components != null) {
            for (UserSchemaComponent s : this.components) {
                if (!(result &= s.validate(compiler)) || !(s instanceof SimpleTypeDefinition)) continue;
                UserSimpleType st = ((SimpleTypeDefinition)s).getWorkingType();
                this.typesByName.put(st.getTypeName(), st);
                PreparedSchema superSchema = compiler.getConfiguration().getSuperSchema();
                if (superSchema.getSchemaType(st.getTypeName()) != s) continue;
                superSchema.typesByName.put(st.getTypeName(), st);
            }
        }
        if (result) {
            compiler.typeCheckIdentityConstraints();
        }
        this.components = null;
        if (result) {
            this.config.addSchema(this);
        }
        return result;
    }

    public static SchemaComponent validateReference(ComponentReference ref, SchemaCompiler compiler, boolean fatal) throws SchemaException {
        if (ref.isDangling()) {
            return ref.getTarget();
        }
        ref.tryToResolve(compiler, fatal);
        if (ref.isResolved()) {
            return ref.getTarget();
        }
        String componentType = SymbolSpace.getSymbolSpaceName(ref.getSymbolSpace());
        String reason = "has not been declared";
        if (ref.getTargetComponentName().hasURI(NamespaceUri.SCHEMA)) {
            reason = "is not defined in the XML Schema namespace";
        }
        String message = "The " + componentType + ' ' + Err.wrap(ref.getTargetComponentName().getDisplayName()) + " is referenced, but " + reason;
        if (compiler.reportMissingComponent(componentType, ref.getTargetComponentName())) {
            if (fatal || !compiler.isAllowDanglingReferences()) {
                compiler.error(message, ref);
            } else {
                compiler.warning(message, "SXSD1007", ref);
            }
        }
        return null;
    }

    public static PreparedSchema merge(PreparedSchema ps1, PreparedSchema ps2) throws SchemaException {
        if (ps1.config != ps2.config) {
            throw new SchemaException("The two schemas to be merged must use the same EnterpriseConfiguration");
        }
        NamePool pool = ps1.config.getNamePool();
        PreparedSchema result = new PreparedSchema(ps1.config);
        result.attributesByName = PreparedSchema.combine(ps1.attributesByName, ps2.attributesByName, "Attribute declaration");
        result.attributesByFingerprint = PreparedSchema.combine(ps1.attributesByFingerprint, ps2.attributesByFingerprint, pool, "Attribute declaration");
        result.attributeGroups = PreparedSchema.combine(ps1.attributeGroups, ps2.attributeGroups, "Attribute group");
        result.groups = PreparedSchema.combine(ps1.groups, ps2.groups, "Model group");
        result.typesByName = PreparedSchema.combine(ps1.typesByName, ps2.typesByName, "Type");
        result.anonymousTypesByName = PreparedSchema.combine(ps1.anonymousTypesByName, ps2.anonymousTypesByName, "Anonymous type");
        result.elementsByName = PreparedSchema.combine(ps1.elementsByName, ps2.elementsByName, "Element declaration");
        result.elementsByFingerprint = PreparedSchema.combine(ps1.elementsByFingerprint, ps2.elementsByFingerprint, pool, "Element declaration");
        result.notations = PreparedSchema.combine(ps1.notations, ps2.notations, "Notation");
        result.identityConstraints = PreparedSchema.combine(ps1.identityConstraints, ps2.identityConstraints, "Identity constraint");
        if (ps1.components != null || ps2.components != null) {
            result.components = new ArrayList<UserSchemaComponent>((ps1.components == null ? 0 : ps1.components.size()) + (ps2.components == null ? 0 : ps2.components.size()));
            if (ps1.components != null) {
                result.components.addAll(ps1.components);
            }
            if (ps2.components != null) {
                result.components.addAll(ps2.components);
            }
        }
        result.targetNamespaces.addAll(ps1.targetNamespaces);
        result.targetNamespaces.addAll(ps2.targetNamespaces);
        return result;
    }

    private static <T extends SchemaComponent> Map<StructuredQName, T> combine(Map<StructuredQName, T> m1, Map<StructuredQName, T> m2, String kind) throws SchemaException {
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        HashMap<StructuredQName, SchemaComponent> result = new HashMap<StructuredQName, SchemaComponent>(m1.size() + m2.size());
        for (StructuredQName k1 : m1.keySet()) {
            String loc2;
            String loc1;
            SchemaComponent v1 = (SchemaComponent)m1.get(k1);
            SchemaComponent v2 = (SchemaComponent)m2.get(k1);
            if (v2 != null && v2 != v1 && !(loc1 = PreparedSchema.identify(v1)).equals(loc2 = PreparedSchema.identify(v2))) {
                throw new SchemaException(kind + " " + k1.getDisplayName() + " is defined in more than one schema document (" + loc1 + ", " + loc2 + ")");
            }
            result.put(k1, v1);
        }
        for (StructuredQName k2 : m2.keySet()) {
            result.put(k2, (SchemaComponent)m2.get(k2));
        }
        return result;
    }

    private static String identify(SchemaComponent component) {
        if (component instanceof SchemaStructure) {
            SchemaStructure ss = (SchemaStructure)component;
            return "line " + ss.getLineNumber() + " of " + ss.getSystemId();
        }
        if (component instanceof SchemaType) {
            return ((SchemaType)component).getEQName();
        }
        return component.getClass().getName();
    }

    private static <T extends SchemaStructure> IntHashMap<T> combine(IntHashMap<T> m1, IntHashMap<T> m2, NamePool pool, String kind) throws SchemaException {
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        IntHashMap<SchemaStructure> result = new IntHashMap<SchemaStructure>(m1.size() + m2.size());
        IntIterator i1 = m1.keyIterator();
        while (i1.hasNext()) {
            String loc2;
            String loc1;
            int k1 = i1.next();
            SchemaStructure v1 = (SchemaStructure)m1.get(k1);
            SchemaStructure v2 = (SchemaStructure)m2.get(k1);
            if (v2 != null && v2 != v1 && !(loc1 = PreparedSchema.identify(v1)).equals(loc2 = PreparedSchema.identify(v2))) {
                throw new SchemaException(kind + " " + pool.getEQName(k1) + " is defined in more than one schema document (" + loc1 + ", " + loc2 + ")");
            }
            result.put(k1, v1);
        }
        IntIterator i2 = m2.keyIterator();
        while (i2.hasNext()) {
            int k2 = i2.next();
            result.put(k2, (SchemaStructure)m2.get(k2));
        }
        return result;
    }

    @Override
    public boolean isDeclaredNotation(NamespaceUri uri, String local) {
        return this.notations != null && this.notations.get(new StructuredQName("", uri, local)) != null;
    }
}

