/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.ComponentReference;
import com.saxonica.ee.schema.SymbolSpace;
import net.sf.saxon.type.MissingComponentException;

public class MissingComponentExceptionImpl
extends MissingComponentException {
    private final ComponentReference reference;

    public MissingComponentExceptionImpl(ComponentReference ref) {
        super("Unresolved reference to schema component " + (ref.getTargetComponentName() == null ? "" : ref.getTargetComponentName().getDisplayName()));
        this.reference = ref;
    }

    public ComponentReference getComponentReference() {
        return this.reference;
    }

    @Override
    public String getMessage() {
        try {
            String space = SymbolSpace.getSymbolSpaceName(this.reference.getSymbolSpace());
            String component = this.reference.getTargetComponentName().getEQName();
            String module = this.reference.getSystemId();
            if (module.endsWith("override.xsl")) {
                module = "schema_document_resulting_from_override_processing";
            }
            return "The schema contains an unresolved reference to " + space + ' ' + component + " at line " + this.reference.getLineNumber() + " in " + this.reference.getSystemId();
        }
        catch (Exception e) {
            return super.getMessage();
        }
    }
}

