/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ModelGroup;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.Wildcard;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.z.IntHashSet;

public class ElementWildcard
extends Particle {
    private Wildcard wildcard;

    public ElementWildcard(EnterpriseConfiguration config) {
        this.wildcard = new Wildcard();
        this.wildcard.setConfiguration(config);
        this.setConfiguration(config);
    }

    public ElementWildcard copy() {
        ElementWildcard e = new ElementWildcard(this.getConfiguration());
        e.wildcard = this.wildcard;
        e.setMinOccurs(this.getMinOccurs());
        e.setMaxOccurs(this.getMaxOccurs());
        return e;
    }

    public ElementWildcard(Wildcard wc) {
        this.wildcard = wc;
    }

    public void setWildcard(Wildcard wildcard) {
        this.wildcard = wildcard;
    }

    public Wildcard getWildcard() {
        return this.wildcard;
    }

    @Override
    public boolean isEmptiable() {
        return this.getMinOccurs() == 0;
    }

    @Override
    public boolean isPointless(ModelGroup container) {
        return false;
    }

    @Override
    public Term getTerm() {
        return this.wildcard;
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) {
        this.setFixupStatus(SchemaValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public void compile(SchemaCompiler compiler) {
    }

    @Override
    public SchemaType getElementParticleType(int elementName) {
        EnterpriseConfiguration config = this.getConfiguration();
        if (this.wildcard.matches(elementName, true, (Configuration)config, null)) {
            if (this.wildcard.getProcessContents().equals("skip")) {
                return AnyType.getInstance();
            }
            if (this.wildcard.getProcessContents().equals("strict")) {
                ElementDecl decl = this.getConfiguration().getSuperSchema().getElementDecl(elementName);
                if (decl == null) {
                    return null;
                }
                try {
                    return decl.getType();
                }
                catch (MissingComponentException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            ElementDecl decl = this.getConfiguration().getSuperSchema().getElementDecl(elementName);
            if (decl == null) {
                return AnyType.getInstance();
            }
            try {
                return decl.getType();
            }
            catch (MissingComponentException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public int getElementParticleCardinality(int elementName) {
        EnterpriseConfiguration config = this.getConfiguration();
        if (this.wildcard.matches(elementName, true, (Configuration)config, null)) {
            return Particle.computeParticleCardinality(this.getMinOccurs(), this.getMaxOccurs());
        }
        return 8192;
    }

    @Override
    public boolean containsElementWildcard() {
        return true;
    }

    @Override
    public void gatherAllPermittedElements(IntHashSet result, boolean ignoreWildcards) throws SchemaException {
        if (!ignoreWildcards) {
            result.add(-1);
        }
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        return this.wildcard.validate(compiler);
    }

    @Override
    public void serializeParticle(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this.wildcard, false);
        serializer.startElement("elementWildcard");
        serializer.emitAttribute("minOccurs", "" + this.getMinOccurs());
        serializer.emitAttribute("maxOccurs", this.getMaxOccurs() < 0 ? "unbounded" : "" + this.getMaxOccurs());
        serializer.emitAttribute("ref", id);
        serializer.endElement();
    }

    public FunctionItem getTermComponentAsFunction() {
        return this.wildcard.getComponentAsFunction();
    }
}

