/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.UserListType;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.sort.CustomSet;
import net.sf.saxon.expr.sort.SimpleTypeComparison;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class DistinctFacet
extends Facet {
    @Override
    public String getName() {
        return "distinct";
    }

    @Override
    public UnicodeString getValue() {
        return BMPString.of("true");
    }

    public void setValue(String value) throws SchemaException {
        if (value != null && !value.equals("true")) {
            throw new SchemaException("The only permitted value for saxon:distinct is 'true'");
        }
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException {
        if (!(base instanceof UserListType)) {
            throw new SchemaException("The saxon:distinct facet is allowed only on list types");
        }
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        return true;
    }

    @Override
    public boolean testListValue(AtomicSequence value) {
        CustomSet<AtomicSequence> values = new CustomSet<AtomicSequence>(SimpleTypeComparison.getInstance());
        for (AtomicValue atom : value) {
            if (values.add(atom)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FunctionItem getFacetAsFunctionItem() {
        DistinctFacet facet = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue(this.getName());
                }
                case "implementation": {
                    return new ObjectValue<DistinctFacet>(facet);
                }
                case "value": {
                    return new StringValue(this.getValue());
                }
                case "fixed": {
                    return BooleanValue.get(this.isFixed());
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

