/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.validate.ValidationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.CollectionFn;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.ResourceResolverDelegate;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.ValidationParams;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class Assertion
extends SchemaStructure
implements SchemaComponent,
SerializableSchemaComponent {
    private XPathExpression condition;
    private XPathVariable valueVariable;
    private Map<StructuredQName, XPathVariable> declaredParams;
    private String conditionText;
    private String message;
    private XPathStaticContext staticContext;
    private Sweep sweep = Sweep.FREE_RANGING;
    private boolean returnsFailingNodes;

    public Assertion() {
    }

    public Assertion(EnterpriseConfiguration config, XPathExpression condition, XPathVariable valueVariable, Map<StructuredQName, XPathVariable> params, String text) {
        this.setConfiguration(config);
        this.condition = condition;
        this.valueVariable = valueVariable;
        this.declaredParams = params;
        this.conditionText = text;
    }

    public XPathExpression getCondition() {
        return this.condition;
    }

    public XPathVariable getValueVariable() {
        return this.valueVariable;
    }

    public String getConditionText() {
        return this.conditionText;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setSweep(Sweep sweep) {
        this.sweep = sweep;
    }

    public Sweep getSweep() {
        return this.sweep;
    }

    public void setReturnsFailingNodes(boolean failingNodes) {
        this.returnsFailingNodes = failingNodes;
    }

    public void setStaticContext(XPathStaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public XPathStaticContext getStaticContext() {
        return this.staticContext;
    }

    public boolean testSimple(AtomicSequence value, ConversionRules rules) {
        XPathDynamicContext context;
        Configuration config;
        if (rules instanceof ValidationContext) {
            try {
                Controller controller = ((ValidationContext)rules).getController();
                config = controller.getConfiguration();
                ValidationParams actualParams = ((ValidationContext)rules).getValidationParams();
                context = this.condition.createDynamicContext(controller, null);
                ValidationParams.setValidationParams(this.declaredParams, actualParams, context);
            }
            catch (XPathException err) {
                throw new IllegalStateException(err.getMessage());
            }
        } else {
            context = this.condition.createDynamicContext();
            Controller controller = context.getXPathContextObject().getController();
            config = this.staticContext.getConfiguration();
        }
        Assertion.setDocumentsAndCollections(config, context);
        try {
            if (this.getValueVariable() != null) {
                context.setVariable(this.getValueVariable(), value == null ? EmptySequence.getInstance() : value);
            }
            return ExpressionTool.effectiveBooleanValue(this.condition.iterate(context));
        }
        catch (XPathException err) {
            context.getErrorReporter().report(new XmlProcessingException(err).asWarning());
            return false;
        }
    }

    public List<NodeInfo> testComplex(NodeInfo contextItem, AtomicSequence value, ValidationContext rules) {
        XPathDynamicContext context;
        Configuration config;
        try {
            Controller controller = rules.getController();
            config = controller.getConfiguration();
            ValidationParams actualParams = rules.getValidationParams();
            context = this.condition.createDynamicContext(controller, contextItem);
            ValidationParams.setValidationParams(this.declaredParams, actualParams, context);
            if (this.getValueVariable() != null) {
                context.setVariable(this.getValueVariable(), value == null ? EmptySequence.getInstance() : value);
            }
        }
        catch (XPathException err) {
            throw new IllegalStateException(err.getMessage());
        }
        Assertion.setDocumentsAndCollections(config, context);
        ArrayList<NodeInfo> result = new ArrayList<NodeInfo>();
        try {
            if (this.returnsFailingNodes) {
                SequenceTool.supply(this.condition.iterate(context), item -> result.add((NodeInfo)item));
                return result;
            }
            boolean ok = this.condition.effectiveBooleanValue(context);
            if (!ok) {
                result.add(contextItem);
            }
        }
        catch (UncheckedXPathException err) {
            context.getErrorReporter().report(new XmlProcessingException(err.getXPathException()).asWarning());
            result.add(contextItem);
        }
        catch (XPathException err) {
            context.getErrorReporter().report(new XmlProcessingException(err).asWarning());
            result.add(contextItem);
        }
        return result;
    }

    public static void setDocumentsAndCollections(Configuration config, XPathDynamicContext context) {
        context.setResourceResolver(new ResourceResolverDelegate(request -> {
            throw new UncheckedXPathException(new XPathException("Use of doc() function within an assertion is not allowed", "FODC0002"));
        }));
        context.getXPathContextObject().getController().setDefaultCollection(CollectionFn.EMPTY_COLLECTION_URI);
        context.setCollectionFinder((context1, collectionURI) -> {
            if (collectionURI.equals(CollectionFn.EMPTY_COLLECTION_URI)) {
                return CollectionFn.EMPTY_COLLECTION;
            }
            throw new XPathException("No collections are available when processing assertions");
        });
    }

    public int hashCode() {
        return this.condition.getInternalExpression().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Assertion && this.condition.getInternalExpression().isEqual(((Assertion)other).condition.getInternalExpression());
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("assertion");
        serializer.emitNamespaceContext(this.staticContext.getNamespaceResolver());
        serializer.emitAttribute("test", this.getConditionText());
        serializer.emitAttribute("defaultNamespace", this.staticContext.getDefaultElementNamespace().toString());
        serializer.emitAttribute("xml:base", this.staticContext.getStaticBaseURI());
        if (this.sweep != Sweep.FREE_RANGING) {
            serializer.emitAttribute("sweep", this.sweep.toString());
        }
        serializer.endElement();
    }

    @Override
    public FunctionItem getComponentAsFunction() {
        Assertion thisAssertion = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Assertion");
                }
                case "implementation": {
                    return new ObjectValue<Assertion>(thisAssertion);
                }
                case "test": {
                    return SchemaStructure.makeXPathExpressionPropertyRecord(this.conditionText, this.staticContext.getNamespaceResolver(), this.staticContext.getStaticBaseURI());
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

