/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.optim.SearchableValue;
import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.value.AtomicValue;

class SmallSearchableValue
extends SearchableValue {
    SmallSearchableValue(Item[] array, int end) {
        this.value = array;
        this.end = end;
    }

    @Override
    public SequenceIterator findItems(Expression use, SequenceIterator values, boolean convertUntypedToOther, AtomicComparer comparer, XPathContext context) throws XPathException {
        ArrayList<Item> selected = new ArrayList<Item>();
        XPathContextMajor c2 = context.newContext();
        ManualIterator manual = new ManualIterator();
        c2.setCurrentIterator(manual);
        ArrayList soughtValues = new ArrayList();
        SequenceTool.supply(values, item -> soughtValues.add((AtomicValue)item));
        if (soughtValues.isEmpty()) {
            return EmptyIterator.getInstance();
        }
        EqualityComparer compare = convertUntypedToOther ? (a, b) -> GeneralComparison.compare(a, 50, b, comparer, true, c2, use.getRetainedStaticContext()) : (a, b) -> ValueComparison.compare(a, 50, b, comparer, true);
        block0: for (int i = 0; i < this.end; ++i) {
            Item key;
            manual.setContextItem(this.value[i]);
            SequenceIterator keys = use.iterate(c2);
            while ((key = keys.next()) != null) {
                AtomicSequence atomized = key.atomize();
                boolean matched = false;
                for (AtomicValue sought : soughtValues) {
                    for (AtomicValue val : atomized) {
                        if (!compare.compare(val, sought)) continue;
                        selected.add(this.value[i]);
                        matched = true;
                        break;
                    }
                    if (!matched) continue;
                    break;
                }
                if (!matched) continue;
                keys.close();
                continue block0;
            }
        }
        return new ListIterator.Of(selected);
    }

    @FunctionalInterface
    private static interface EqualityComparer {
        public boolean compare(AtomicValue var1, AtomicValue var2) throws XPathException;
    }
}

