/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.optim.MultiIndex;
import com.saxonica.ee.optim.SearchableValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class IndexedValue
extends SearchableValue {
    private final List<Expression> indexedExpressions = new ArrayList<Expression>(3);
    private final List<MultiIndex> indexes = new ArrayList<MultiIndex>(3);
    private Set<NodeInfo> distinctNodes;

    IndexedValue(Item[] array, int end) {
        this.value = array;
        this.end = end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceIterator findItems(Expression use, SequenceIterator values, boolean convertUntypedToOther, AtomicComparer comparer, XPathContext context) throws XPathException {
        MultiIndex index = null;
        IndexedValue indexedValue = this;
        synchronized (indexedValue) {
            Expression si;
            int i;
            for (i = 0; i < this.indexedExpressions.size(); ++i) {
                si = this.indexedExpressions.get(i);
                if (si != use) continue;
                index = this.indexes.get(i);
                break;
            }
            if (index == null) {
                for (i = 0; i < this.indexedExpressions.size(); ++i) {
                    si = this.indexedExpressions.get(i);
                    if (!si.isEqual(use)) continue;
                    index = this.indexes.get(i);
                    this.indexedExpressions.add(use);
                    this.indexes.add(index);
                    break;
                }
            }
            if (index == null) {
                index = new MultiIndex(this);
                this.indexedExpressions.add(use);
                this.indexes.add(index);
            }
        }
        return index.findItems(use, values, convertUntypedToOther, comparer.getCollator(), context);
    }

    @Override
    public synchronized boolean containsNode(NodeInfo sought) {
        if (this.distinctNodes == null) {
            Item it;
            this.distinctNodes = new HashSet<NodeInfo>();
            SequenceIterator iter = this.iterate();
            while ((it = iter.next()) != null) {
                if (!(it instanceof NodeInfo)) continue;
                this.distinctNodes.add((NodeInfo)it);
            }
        }
        return this.distinctNodes.contains(sought);
    }
}

