/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.optim.GeneralEqualityEE;
import com.saxonica.ee.optim.SearchableValue;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;

public final class IndexedFilterExpression
extends Expression {
    private final Operand baseOp;
    private final Operand useOp;
    private final Operand searchOp;
    private final AtomicComparer comparer;
    private final boolean convertUntypedToOther;

    public IndexedFilterExpression(VariableReference start, ComparisonExpression filter, boolean indexFirstOperand) {
        this.baseOp = new Operand(this, start, OperandRole.FOCUS_CONTROLLING_SELECT);
        if (indexFirstOperand) {
            this.useOp = new Operand(this, filter.getLhsExpression(), FilterExpression.FILTER_PREDICATE);
            this.searchOp = new Operand(this, filter.getRhsExpression(), OperandRole.ATOMIC_SEQUENCE);
        } else {
            this.useOp = new Operand(this, filter.getRhsExpression(), FilterExpression.FILTER_PREDICATE);
            this.searchOp = new Operand(this, filter.getLhsExpression(), OperandRole.ATOMIC_SEQUENCE);
        }
        this.comparer = filter.getAtomicComparer();
        this.convertUntypedToOther = filter.convertsUntypedToOther();
        if (start.getBinding() instanceof GlobalVariable && !((GlobalVariable)start.getBinding()).isIndexedVariable()) {
            ((GlobalVariable)start.getBinding()).setIndexedVariable();
        }
    }

    public IndexedFilterExpression(Expression base, Expression use, Expression search, AtomicComparer comparer, boolean convertUntypedToOther) {
        this.baseOp = new Operand(this, base, OperandRole.FOCUS_CONTROLLING_SELECT);
        this.useOp = new Operand(this, use, FilterExpression.FILTER_PREDICATE);
        this.searchOp = new Operand(this, search, OperandRole.ATOMIC_SEQUENCE);
        this.comparer = comparer;
        this.convertUntypedToOther = convertUntypedToOther;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.baseOp, this.useOp, this.searchOp);
    }

    @Override
    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    public Expression getBaseExpression() {
        return this.baseOp.getChildExpression();
    }

    public Expression getUseExpression() {
        return this.useOp.getChildExpression();
    }

    public Expression getSearchExpression() {
        return this.searchOp.getChildExpression();
    }

    public boolean isConvertUntypedToOther() {
        return this.convertUntypedToOther;
    }

    public AtomicComparer getComparer() {
        return this.comparer;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.baseOp.typeCheck(visitor, contextInfo);
        ItemType type = this.getBaseExpression().getItemType();
        ContextItemStaticInfo cisi = visitor.getConfiguration().makeContextItemStaticInfo(type, false);
        this.useOp.typeCheck(visitor, cisi);
        this.searchOp.typeCheck(visitor, contextInfo);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (!(this.getBaseExpression() instanceof VariableReference)) {
            if (ExpressionTool.dependsOnFocus(this.getSearchExpression())) {
                LetExpression let = new LetExpression();
                let.setVariableQName(new StructuredQName("vv", NamespaceUri.SAXON_GENERATED_VARIABLE, "vv" + this.computeHashCode()));
                let.setSequence(this.getSearchExpression());
                let.setRequiredType(this.getSearchExpression().getStaticType());
                Expression filter = new GeneralEqualityEE(this.getUseExpression(), 6, new LocalVariableReference(let));
                filter = ((Expression)filter).typeCheck(visitor, contextItemType);
                let.setAction(new FilterExpression(this.getBaseExpression(), filter));
                ExpressionTool.copyLocationInfo(this, let);
                return let.optimize(visitor, contextItemType);
            }
            Expression filter = new GeneralEqualityEE(this.getUseExpression(), 6, this.getSearchExpression());
            ItemType type = this.getBaseExpression().getItemType();
            ContextItemStaticInfo cisi = visitor.getConfiguration().makeContextItemStaticInfo(type, false);
            filter = ((Expression)filter).typeCheck(visitor, cisi);
            FilterExpression e2 = new FilterExpression(this.getBaseExpression(), filter);
            return ((Expression)e2).optimize(visitor, contextItemType);
        }
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        IndexedFilterExpression ife = new IndexedFilterExpression(this.getBaseExpression().copy(rebindings), this.getUseExpression().copy(rebindings), this.getSearchExpression().copy(rebindings), this.comparer, this.convertUntypedToOther);
        ExpressionTool.copyLocationInfo(this, ife);
        return ife;
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    protected int computeSpecialProperties() {
        return this.getBaseExpression().getSpecialProperties();
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.getBaseExpression().addToPathMap(pathMap, pathMapNodeSet);
        this.getUseExpression().addToPathMap(pathMap, target);
        this.getSearchExpression().addToPathMap(pathMap, target);
        return target;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IndexedFilterExpression) {
            IndexedFilterExpression f = (IndexedFilterExpression)other;
            return this.getBaseExpression().isEqual(f.getBaseExpression()) && this.getUseExpression().isEqual(f.getUseExpression()) && this.getSearchExpression().isEqual(f.getSearchExpression()) && this.comparer.equals(f.comparer) && this.convertUntypedToOther == f.convertUntypedToOther;
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return "IndexedFilterExpression".hashCode() + this.getBaseExpression().hashCode() ^ this.getUseExpression().hashCode() ^ this.getSearchExpression().hashCode();
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public int computeDependencies() {
        int b = this.getBaseExpression().getDependencies() | this.getSearchExpression().getDependencies();
        int f = this.getUseExpression().getDependencies();
        return b | f & 0x3E1;
    }

    @Override
    public String getExpressionName() {
        return "indexedFilter";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("indexedFilter2", this);
        out.emitAttribute("comp", this.comparer.save());
        if (this.convertUntypedToOther) {
            out.emitAttribute("flags", "u");
        }
        out.setChildRole("base");
        this.getBaseExpression().export(out);
        out.setChildRole("use");
        this.getUseExpression().export(out);
        out.setChildRole("search");
        this.getSearchExpression().export(out);
        out.endElement();
    }

    @Override
    public String toShortString() {
        return this.getBaseExpression().toShortString() + "[(:indexed:)" + this.getUseExpression().toShortString() + "=" + this.getSearchExpression().toShortString() + "]";
    }

    @Override
    public Elaborator getElaborator() {
        return new IndexedFilterExpressionElaborator();
    }

    private static class IndexedFilterExpressionElaborator
    extends PullElaborator {
        private IndexedFilterExpressionElaborator() {
        }

        @Override
        public PullEvaluator elaborateForPull() {
            IndexedFilterExpression expr = (IndexedFilterExpression)this.getExpression();
            Expression baseExp = expr.getBaseExpression();
            PullEvaluator basePullEvaluator = baseExp.makeElaborator().elaborateForPull();
            PullEvaluator searchPullEvaluator = expr.getSearchExpression().makeElaborator().elaborateForPull();
            return context -> {
                SearchableValue indexedValue;
                if (baseExp instanceof VariableReference) {
                    Sequence base = ((VariableReference)baseExp).evaluateVariable(context);
                    if (base instanceof EmptySequence) {
                        return EmptyIterator.getInstance();
                    }
                    if (base instanceof SearchableValue) {
                        indexedValue = (SearchableValue)base;
                    } else {
                        indexedValue = SearchableValue.makeSearchableValue(base.iterate());
                        Binding binding = ((VariableReference)baseExp).getBinding();
                        if (binding instanceof LocalBinding) {
                            context.setLocalVariable(((LocalBinding)binding).getLocalSlotNumber(), indexedValue);
                        } else if (binding instanceof GlobalVariable) {
                            context.getController().getBindery(((GlobalVariable)binding).getPackageData()).setGlobalVariable((GlobalVariable)binding, indexedValue);
                        }
                    }
                } else {
                    indexedValue = SearchableValue.makeSearchableValue(basePullEvaluator.iterate(context));
                }
                if (indexedValue.getLength() == 0) {
                    return EmptyIterator.getInstance();
                }
                AtomicComparer comparer = expr.comparer.provideContext(context);
                SequenceIterator values = searchPullEvaluator.iterate(context);
                return indexedValue.findItems(expr.getUseExpression(), values, expr.convertUntypedToOther, comparer, context);
            };
        }
    }
}

