/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn.js;

import com.saxonica.ee.extfn.js.IXSLFunctionSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class IXSLRemoveProperty
extends StyleElement {
    private Expression name;
    private Expression object;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    protected void prepareAttributes() {
        block10: for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            String value = att.getValue();
            switch (f) {
                case "name": {
                    String nameAtt = Whitespace.trim(value);
                    this.name = this.makeAttributeValueTemplate(nameAtt, att);
                    continue block10;
                }
                case "object": {
                    String objectAtt = value;
                    this.object = this.makeExpression(objectAtt, att);
                    continue block10;
                }
            }
            this.checkUnknownAttribute(attName);
        }
        if (this.object == null) {
            try {
                this.object = IXSLFunctionSet.getInstance().makeFunction("window", 0).makeFunctionCall(new Expression[0]);
            }
            catch (XPathException e) {
                this.compileError(e);
            }
        }
        if (this.name == null) {
            this.reportAbsence("name");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkEmpty();
        this.name = this.typeCheck("name", this.name);
        this.object = this.typeCheck("object", this.object);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression e = IXSLFunctionSet.getInstance().makeFunction("remove-property", 2).makeFunctionCall(this.name, this.object);
        e.setRetainedStaticContext(this.makeRetainedStaticContext());
        return e;
    }
}

