/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn;

import com.saxonica.config.JavaExtensionLibrary;
import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.ee.extfn.ExperimentalSequenceTypeMarshaller;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.functions.extfn.EXPathArchive.Archive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.registry.ConstructorFunctionLibrary;
import net.sf.saxon.functions.registry.XSLT30FunctionSet;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.lib.StandardDiagnostics;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.option.exslt.Date;
import net.sf.saxon.option.exslt.Math;
import net.sf.saxon.option.exslt.Random;
import net.sf.saxon.option.exslt.Sets;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class ExperimentalXPathCompiler {
    private Configuration config;
    private FunctionLibrary globalFunctionLibrary;
    private Map<StructuredQName, GroundedValue> globalVariables = new HashMap<StructuredQName, GroundedValue>();
    private SEFStaticContext uniformStaticContext;
    private final Map<String, Map<String, NamespaceUri>> namespaceBindingsCache = new HashMap<String, Map<String, NamespaceUri>>();
    private NodeInfo mostRecentNsAttribute = null;
    private Map<String, NamespaceUri> mostRecentNsBindings = null;

    private ExperimentalXPathCompiler() {
    }

    private ExperimentalXPathCompiler(ExperimentalXPathCompiler original) {
        this.config = original.config;
        this.globalFunctionLibrary = original.globalFunctionLibrary;
        this.globalVariables = original.globalVariables;
    }

    public static ExperimentalXPathCompiler make(XPathContext context, MapItem globalFunctions, MapItem globalVariables) {
        ExperimentalXPathCompiler compiler = new ExperimentalXPathCompiler();
        compiler.config = context.getConfiguration();
        for (KeyValuePair entry : globalVariables.keyValuePairs()) {
            String name = entry.key.getStringValue();
            GroundedValue value = entry.value;
            compiler.globalVariables.put(StructuredQName.fromEQName(name), value);
        }
        JavaExtensionLibrary javaLib = new JavaExtensionLibrary((ProfessionalConfiguration)context.getConfiguration());
        javaLib.declareJavaClass("http://exslt.org/sets", Sets.class);
        javaLib.declareJavaClass("http://exslt.org/math", Math.class);
        javaLib.declareJavaClass("http://exslt.org/dates-and-times", Date.class);
        javaLib.declareJavaClass("http://exslt.org/random", Random.class);
        javaLib.declareJavaClass(Archive.NAMESPACE.toString(), Archive.class);
        FunctionLibraryList libraryList = new FunctionLibraryList();
        libraryList.addFunctionLibrary(XSLT30FunctionSet.getInstance());
        libraryList.addFunctionLibrary(MapFunctionSet.getInstance(31));
        libraryList.addFunctionLibrary(ArrayFunctionSet.getInstance(31));
        libraryList.addFunctionLibrary(new ConstructorFunctionLibrary(context.getConfiguration()));
        libraryList.addFunctionLibrary(context.getConfiguration().getVendorFunctionSet());
        libraryList.addFunctionLibrary(javaLib);
        libraryList.addFunctionLibrary(compiler.setupUserFunctionLibrary(globalFunctions));
        compiler.globalFunctionLibrary = libraryList;
        return compiler;
    }

    public ExperimentalXPathCompiler withUniformStaticContext(XPathContext context, NodeInfo sefElement, NodeInfo nsAttribute) {
        Objects.requireNonNull(sefElement);
        Objects.requireNonNull(nsAttribute);
        ExperimentalXPathCompiler newComp = new ExperimentalXPathCompiler(this);
        newComp.uniformStaticContext = new SEFStaticContext(sefElement, null, nsAttribute);
        return newComp;
    }

    private FunctionLibrary setupUserFunctionLibrary(MapItem globalFunctions) {
        final HashMap<SymbolicName.F, ProvisionalSEFFunction> library = new HashMap<SymbolicName.F, ProvisionalSEFFunction>();
        if (globalFunctions != null) {
            for (KeyValuePair kvp : globalFunctions.keyValuePairs()) {
                AtomicValue key = kvp.key;
                String nameArity = key.getStringValue();
                String[] parts = nameArity.split("#");
                int arity = Integer.parseInt(parts[1]);
                StructuredQName name = StructuredQName.fromEQName(parts[0]);
                MapItem typeAsMap = (MapItem)kvp.value;
                SpecificFunctionType ft = (SpecificFunctionType)ExperimentalXPathCompiler.fromMap(typeAsMap).getPrimaryType();
                library.put(new SymbolicName.F(name, arity), new ProvisionalSEFFunction(name, arity, ft));
            }
        }
        return new FunctionLibrary(){

            @Override
            public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
                return library.containsKey(functionName);
            }

            @Override
            public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) {
                if (this.isAvailable(functionName, env.getXPathVersion())) {
                    UserFunction fn = (UserFunction)library.get(functionName);
                    fn.setFunctionName(functionName.getComponentName());
                    UserFunctionCall call = new UserFunctionCall();
                    call.setArguments(staticArgs);
                    call.setFunctionName(functionName.getComponentName());
                    call.setFunction(fn);
                    return call;
                }
                return null;
            }

            @Override
            public FunctionLibrary copy() {
                return null;
            }

            @Override
            public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) {
                return (FunctionItem)library.get(functionName);
            }
        };
    }

    public MapItem compileXPath(XPathContext context, String exprText, NodeInfo sefElement, MapItem localVariableMap, NodeInfo nsAttribute) throws XPathException {
        SEFStaticContext env;
        Controller controller = context.getController();
        if (this.uniformStaticContext != null) {
            env = this.uniformStaticContext;
            env.setLocalVariableMap(localVariableMap);
        } else {
            env = new SEFStaticContext(sefElement, localVariableMap, nsAttribute);
        }
        Expression expr = null;
        try {
            if (sefElement.getLocalPart().equals("pattern")) {
                expr = Pattern.make(exprText, env, null);
            } else {
                boolean inCatch = sefElement.iterateAxis(0, new LocalNameTest(this.config.getNamePool(), 1, "catch")).next() != null;
                boolean allowEmpty = "true".equals(sefElement.getAttributeValue(NamespaceUri.NULL, "allowEmpty"));
                expr = ExperimentalXPathCompiler.make(exprText, env, inCatch, allowEmpty);
            }
        }
        catch (XPathException e) {
            throw new XPathException("Error in XPath expression {" + exprText + "}: " + e.getMessage()).withErrorCode("XTDE3160");
        }
        ExpressionVisitor visitor = new ExpressionVisitor(this.config);
        visitor.setStaticContext(env);
        AnyItemType contextItemType = AnyItemType.getInstance();
        expr = expr.typeCheck(visitor, new ContextItemStaticInfo(contextItemType, false));
        int used = localVariableMap.size();
        int allocated = ExperimentalXPathCompiler.allocateSlots(expr, used, this.config.makeSlotManager());
        Builder b = controller.makeBuilder();
        b.setTiming(false);
        ExpressionPresenter out = new ExpressionPresenter(this.config, b);
        out.setDefaultNamespace(NamespaceUri.SAXON_XSLT_EXPORT);
        ExpressionPresenter.ExportOptions options = new ExpressionPresenter.ExportOptions();
        options.suppressStaticContext = true;
        options.target = "JS";
        options.targetVersion = 2;
        out.setOptions(options);
        expr.export(out);
        b.close();
        NodeInfo node = b.getCurrentRoot().iterateAxis(3).next();
        StringValue st = ExperimentalSequenceTypeMarshaller.unmarshal(ExperimentalXPathCompiler.makeMap(expr.getStaticType()));
        DictionaryMap result = new DictionaryMap();
        result.initialPut("expr", node);
        result.initialPut("type", st);
        return result;
    }

    private static Expression make(String expression, StaticContext env, boolean inCatch, boolean allowEmpty) throws XPathException {
        try {
            XPathParser parser = env.getConfiguration().newExpressionParser("XP", false, env);
            if (inCatch) {
                parser.setCatchDepth(1);
            }
            parser.setAllowAbsentExpression(allowEmpty);
            Expression exp = parser.parse(expression, 0, 0, env);
            ExpressionTool.setDeepRetainedStaticContext(exp, env.makeRetainedStaticContext());
            exp = exp.simplify();
            return exp;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static int allocateSlots(Expression exp, int nextFree, SlotManager frame) {
        LocalVariableReference var;
        LocalBinding binding;
        if (exp instanceof Assignation) {
            ((Assignation)exp).setSlotNumber(nextFree);
            int count = ((Assignation)exp).getRequiredSlots();
            nextFree += count;
            if (frame != null) {
                frame.allocateSlotNumber(((Assignation)exp).getVariableQName(), (Assignation)exp);
            }
        }
        if (exp instanceof LocalParam && ((LocalParam)exp).getSlotNumber() < 0) {
            ((LocalParam)exp).setSlotNumber(nextFree++);
        }
        if (exp instanceof FLWORExpression) {
            for (Clause c : ((FLWORExpression)exp).getClauseList()) {
                for (LocalVariableBinding b : c.getRangeVariables()) {
                    b.setSlotNumber(nextFree++);
                    frame.allocateSlotNumber(b.getVariableQName(), b);
                }
            }
        }
        if (exp instanceof LocalVariableReference && (binding = (var = (LocalVariableReference)exp).getBinding()) != null) {
            var.setSlotNumber(binding.getLocalSlotNumber());
        }
        for (Operand o : exp.operands()) {
            nextFree = ExperimentalXPathCompiler.allocateSlots(o.getChildExpression(), nextFree, frame);
        }
        return nextFree;
    }

    public static void breakpoint(String s) {
        System.err.println(s);
    }

    public static void stackTrace(XPathContext context) {
        new StandardDiagnostics().logStackTrace(context, context.getConfiguration().getLogger(), 2);
    }

    public static MapItem parseSequenceType(XPathContext context, String input, final NodeInfo nsContext, final NamespaceUri xpathDefaultNamespace) throws XPathException {
        IndependentContext env = new IndependentContext(context.getConfiguration());
        env.setNamespaceResolver(new NamespaceResolver(){
            final NamespaceUri defaultNS;
            final NamespaceResolver supplied;
            {
                this.defaultNS = xpathDefaultNamespace == null ? NamespaceUri.NULL : xpathDefaultNamespace;
                this.supplied = nsContext.getAllNamespaces();
            }

            @Override
            public NamespaceUri getURIForPrefix(String prefix, boolean useDefault) {
                if (prefix.isEmpty() && useDefault) {
                    return this.defaultNS;
                }
                return this.supplied.getURIForPrefix(prefix, useDefault);
            }

            @Override
            public Iterator<String> iteratePrefixes() {
                return this.supplied.iteratePrefixes();
            }
        });
        env.setXPathLanguageLevel(31);
        XPathParser parser = new XPathParser(env);
        SequenceType st = parser.parseSequenceType(input, env);
        return ExperimentalXPathCompiler.makeMap(st);
    }

    public static MapItem makeMap(SequenceType st) {
        ItemType primary = st.getPrimaryType();
        DictionaryMap result = new DictionaryMap();
        String occurrenceIndicator = Cardinality.getOccurrenceIndicator(st.getCardinality());
        if (!occurrenceIndicator.isEmpty()) {
            result.initialPut("o", new StringValue(occurrenceIndicator));
        }
        if (st == SequenceType.EMPTY_SEQUENCE) {
            return result;
        }
        String alphaCode = primary.getBasicAlphaCode();
        result.initialPut("p", new StringValue(alphaCode));
        if (primary instanceof UserAtomicType) {
            result.initialPut("t", new StringValue(((UserAtomicType)primary).getEQName()));
        } else if (primary instanceof UnionType) {
            try {
                ArrayList<GroundedValue> memberMaps = new ArrayList<GroundedValue>();
                for (PlainType plainType : ((UnionType)primary).getPlainMemberTypes()) {
                    memberMaps.add(ExperimentalXPathCompiler.makeMap(SequenceType.makeSequenceType(plainType, 16384)));
                }
                result.initialPut("u", new SimpleArrayItem(memberMaps));
            }
            catch (MissingComponentException memberMaps) {}
        } else if (primary instanceof NameTest) {
            String name = ((NameTest)primary).getMatchingNodeName().getEQName();
            result.initialPut("n", new StringValue(name));
        } else if (primary instanceof LocalNameTest) {
            result.initialPut("n", StringValue.bmp("*:" + ((LocalNameTest)primary).getLocalName()));
        } else if (primary instanceof NamespaceTest) {
            result.initialPut("n", StringValue.bmp("Q{" + ((NamespaceTest)primary).getNamespaceURI() + "}*"));
        } else if (primary instanceof CombinedNodeTest) {
            ((CombinedNodeTest)primary).addTypeDetails(result);
        } else if (primary instanceof ContentTypeTest) {
            String annotation = ((ContentTypeTest)primary).getContentType().getEQName();
            result.initialPut("c", new StringValue(annotation));
        } else if (primary instanceof DocumentNodeTest) {
            NodeTest content = ((DocumentNodeTest)primary).getElementTest();
            MapItem contentMap = ExperimentalXPathCompiler.makeMap(SequenceType.makeSequenceType(content, 16384));
            result.initialPut("e", contentMap);
        } else if (primary instanceof FunctionItemType) {
            if (primary instanceof ArrayItemType) {
                SequenceType memberType = ((ArrayItemType)primary).getMemberType();
                if (memberType != SequenceType.ANY_SEQUENCE) {
                    MapItem contentMap = ExperimentalXPathCompiler.makeMap(memberType);
                    result.initialPut("v", contentMap);
                }
            } else if (primary instanceof MapType) {
                SequenceType valueType;
                PlainType keyType = ((MapType)primary).getKeyType();
                if (keyType != BuiltInAtomicType.ANY_ATOMIC) {
                    MapItem keyMap = ExperimentalXPathCompiler.makeMap(new SequenceType(keyType, 16384));
                    result.initialPut("k", keyMap);
                }
                if ((valueType = ((MapType)primary).getValueType()) != SequenceType.ANY_SEQUENCE) {
                    MapItem mapItem = ExperimentalXPathCompiler.makeMap(valueType);
                    result.initialPut("v", mapItem);
                }
            } else {
                SequenceType[] argTypes;
                SequenceType valueType = ((FunctionItemType)primary).getResultType();
                if (valueType != SequenceType.ANY_SEQUENCE) {
                    MapItem contentMap = ExperimentalXPathCompiler.makeMap(valueType);
                    result.initialPut("r", contentMap);
                }
                if ((argTypes = ((FunctionItemType)primary).getArgumentTypes()) != null) {
                    ArrayList<GroundedValue> arrayList = new ArrayList<GroundedValue>();
                    for (SequenceType at : argTypes) {
                        arrayList.add(ExperimentalXPathCompiler.makeMap(at));
                    }
                    SimpleArrayItem arrayItem = new SimpleArrayItem(arrayList);
                    result.initialPut("a", arrayItem);
                }
            }
        }
        return result;
    }

    public static SequenceType fromMap(MapItem typeAsMap) {
        String occ = ((StringValue)typeAsMap.get(StringValue.bmp("o"))).getStringValue();
        int cardinality = Cardinality.fromOccurrenceIndicator(occ.substring(0, 1));
        String primary = ((StringValue)typeAsMap.get(StringValue.bmp("p"))).getStringValue();
        if (primary.isEmpty()) {
            return SequenceType.makeSequenceType(AnyItemType.getInstance(), cardinality);
        }
        switch (primary.charAt(0)) {
            case 'A': {
                BuiltInAtomicType bat = BuiltInAtomicType.fromAlphaCode(primary);
                assert (bat != null);
                return SequenceType.makeSequenceType(bat, cardinality);
            }
            case 'N': {
                return SequenceType.makeSequenceType(ExperimentalXPathCompiler.nodeTestFromAlphaCode(primary), cardinality);
            }
            case 'F': {
                if (primary.length() == 1) {
                    MapItem resultType = (MapItem)typeAsMap.get(StringValue.bmp("r"));
                    ArrayItem argTypes = (ArrayItem)typeAsMap.get(StringValue.bmp("a"));
                    assert (resultType != null);
                    assert (argTypes != null);
                    SequenceType resultType1 = ExperimentalXPathCompiler.fromMap(resultType);
                    int arity = argTypes.arrayLength();
                    SequenceType[] argTypeArray = new SequenceType[arity];
                    for (int i = 0; i < arity; ++i) {
                        argTypeArray[i] = ExperimentalXPathCompiler.fromMap((MapItem)argTypes.get(i));
                    }
                    SpecificFunctionType sft = new SpecificFunctionType(argTypeArray, resultType1);
                    return SequenceType.makeSequenceType(sft, cardinality);
                }
                if (primary.charAt(1) == 'M') {
                    return SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, cardinality);
                }
                if (primary.charAt(1) == 'A') {
                    return SequenceType.makeSequenceType(ArrayItemType.ANY_ARRAY_TYPE, cardinality);
                }
                throw new AssertionError();
            }
        }
        throw new AssertionError();
    }

    private static NodeTest nodeTestFromAlphaCode(String code) {
        switch (code) {
            case "NE": {
                return NodeKindTest.ELEMENT;
            }
            case "NA": {
                return NodeKindTest.ATTRIBUTE;
            }
            case "NT": {
                return NodeKindTest.TEXT;
            }
            case "NC": {
                return NodeKindTest.COMMENT;
            }
            case "NP": {
                return NodeKindTest.PROCESSING_INSTRUCTION;
            }
            case "ND": {
                return NodeKindTest.DOCUMENT;
            }
            case "NN": {
                return NodeKindTest.NAMESPACE;
            }
        }
        return AnyNodeTest.getInstance();
    }

    private static class SEFLocalVariableReference
    extends LocalVariableReference {
        private String declaredType;
        private boolean isSuppliedParameter;

        public SEFLocalVariableReference(StructuredQName name) {
            super(name);
        }

        public void setDeclaredType(String type) {
            this.declaredType = type;
        }

        public void setSuppliedParameter(boolean isSupplied) {
            this.isSuppliedParameter = isSupplied;
        }

        @Override
        public void export(ExpressionPresenter destination) throws XPathException {
            if (this.isSuppliedParameter) {
                destination.startElement("supplied");
            } else {
                destination.startElement("varRef", this);
                destination.emitAttribute("name", this.getVariableName());
            }
            destination.emitAttribute("slot", "" + this.getSlotNumber());
            if (this.declaredType != null) {
                destination.emitAttribute("type", this.declaredType);
            }
            destination.endElement();
        }
    }

    private static class ProvisionalSEFFunction
    extends UserFunction {
        StructuredQName name;
        int arity;
        SpecificFunctionType functionType;

        public ProvisionalSEFFunction(StructuredQName name, int arity, SpecificFunctionType functionType) {
            this.name = name;
            this.arity = arity;
            this.functionType = functionType;
        }

        @Override
        public FunctionItemType getFunctionItemType() {
            return this.functionType;
        }

        @Override
        public StructuredQName getFunctionName() {
            return this.name;
        }

        @Override
        public int getArity() {
            return this.arity;
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
            return null;
        }

        @Override
        public String getDescription() {
            return this.name.getDisplayName() + "#" + this.arity;
        }

        @Override
        public void export(ExpressionPresenter out) throws XPathException {
        }
    }

    private class SEFStaticContext
    implements StaticContext,
    NamespaceResolver {
        private final NodeInfo sefElement;
        private RetainedStaticContext retainedStaticContext;
        private Map<String, NamespaceUri> staticNamespaceBindings;
        private final PackageData packageData;
        private MapItem localVariableMap;
        private final NodeInfo nsAttribute;
        private DecimalFormatManager decimalFormatManager;

        public SEFStaticContext(NodeInfo sefElement, MapItem localVariableMap, NodeInfo nsAttribute) {
            this.sefElement = sefElement;
            this.localVariableMap = localVariableMap;
            this.nsAttribute = nsAttribute;
            PackageData pd = new PackageData(ExperimentalXPathCompiler.this.config);
            pd.setHostLanguage(HostLanguage.XPATH, this.getXPathVersion());
            pd.setSchemaAware(false);
            this.packageData = pd;
        }

        @Override
        public Configuration getConfiguration() {
            return this.sefElement.getConfiguration();
        }

        @Override
        public PackageData getPackageData() {
            return this.packageData;
        }

        @Override
        public XPathContext makeEarlyEvaluationContext() {
            return new EarlyEvaluationContext(this.getConfiguration());
        }

        @Override
        public RetainedStaticContext makeRetainedStaticContext() {
            if (this.retainedStaticContext == null) {
                this.retainedStaticContext = new RetainedStaticContext(this);
            }
            return this.retainedStaticContext;
        }

        @Override
        public Location getContainingLocation() {
            return this.sefElement;
        }

        @Override
        public void issueWarning(String message, String errorCode, Location locator) {
            System.err.println("WARNING: " + message);
        }

        @Override
        public String getSystemId() {
            return this.sefElement.getSystemId();
        }

        @Override
        public String getStaticBaseURI() {
            return Navigator.getInheritedAttributeValue(this.sefElement, NamespaceUri.NULL, "baseUri");
        }

        public void setLocalVariableMap(MapItem variableMap) {
            this.localVariableMap = variableMap;
        }

        @Override
        public Expression bindVariable(StructuredQName qName) throws XPathException {
            String eqName = qName.getEQName();
            StringValue eqNameVal = new StringValue(eqName);
            GroundedValue localVariableDetails = this.localVariableMap.get(eqNameVal);
            if (localVariableDetails != null) {
                NumericValue slotVal = (NumericValue)localVariableDetails.itemAt(1);
                SEFLocalVariableReference var = new SEFLocalVariableReference(qName);
                var.setSlotNumber((int)slotVal.longValue());
                StringValue type = (StringValue)localVariableDetails.itemAt(2);
                var.setDeclaredType(type.getStringValue());
                NodeInfo decl = (NodeInfo)localVariableDetails.itemAt(0);
                if (decl.getLocalPart().equals("accRule") && decl.getNamespaceUri().equals(NamespaceUri.SAXON_XSLT_EXPORT) && eqName.equals("Q{}value")) {
                    var.setSuppliedParameter(true);
                }
                return var;
            }
            if (ExperimentalXPathCompiler.this.globalVariables.containsKey(qName)) {
                return new GlobalVariableReference(qName);
            }
            throw new XPathException("Variable " + qName.getDisplayName() + " has not been declared");
        }

        @Override
        public FunctionLibrary getFunctionLibrary() {
            return ExperimentalXPathCompiler.this.globalFunctionLibrary;
        }

        @Override
        public String getDefaultCollationName() {
            String att = this.sefElement.getAttributeValue(NamespaceUri.NULL, "default-collation");
            if (att == null) {
                return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
            return Whitespace.trim(att);
        }

        @Override
        public NamespaceUri getDefaultElementNamespace() {
            String att = this.sefElement.getAttributeValue(NamespaceUri.NULL, "xpath-default-namespace");
            if (att == null) {
                return NamespaceUri.NULL;
            }
            return NamespaceUri.of(att);
        }

        @Override
        public NamespaceUri getDefaultFunctionNamespace() {
            return NamespaceUri.FN;
        }

        @Override
        public boolean isInBackwardsCompatibleMode() {
            return this.sefElement.getAttributeValue(NamespaceUri.NULL, "BC") != null;
        }

        @Override
        public boolean isImportedSchema(NamespaceUri namespace) {
            return false;
        }

        @Override
        public Set<NamespaceUri> getImportedSchemaNamespaces() {
            return Collections.emptySet();
        }

        @Override
        public NamespaceResolver getNamespaceResolver() {
            return this;
        }

        private void makeNamespaceBindings() {
            if (this.staticNamespaceBindings == null) {
                assert (this.nsAttribute != null);
                if (ExperimentalXPathCompiler.this.mostRecentNsAttribute != null && this.nsAttribute.isSameNodeInfo(ExperimentalXPathCompiler.this.mostRecentNsAttribute)) {
                    this.staticNamespaceBindings = ExperimentalXPathCompiler.this.mostRecentNsBindings;
                } else {
                    ExperimentalXPathCompiler.this.mostRecentNsAttribute = this.nsAttribute;
                    String ns = this.nsAttribute.getStringValue();
                    Map cachedValue = (Map)ExperimentalXPathCompiler.this.namespaceBindingsCache.get(ns);
                    if (cachedValue != null) {
                        this.staticNamespaceBindings = ExperimentalXPathCompiler.this.mostRecentNsBindings = cachedValue;
                    } else {
                        String[] bindings;
                        this.staticNamespaceBindings = ExperimentalXPathCompiler.this.mostRecentNsBindings = new HashMap();
                        for (String binding : bindings = ns.split(" ")) {
                            int eq = binding.indexOf("=");
                            assert (eq >= 0);
                            String prefix = binding.substring(0, eq);
                            String uri = binding.substring(eq + 1);
                            if (uri.equals("~")) {
                                uri = NamespaceConstant.getUriForConventionalPrefix(prefix);
                                assert (uri != null);
                            }
                            this.staticNamespaceBindings.put(prefix, NamespaceUri.of(uri));
                        }
                        ExperimentalXPathCompiler.this.namespaceBindingsCache.put(ns, this.staticNamespaceBindings);
                    }
                }
            }
        }

        @Override
        public NamespaceUri getURIForPrefix(String prefix, boolean useDefault) {
            this.makeNamespaceBindings();
            return this.staticNamespaceBindings.get(prefix);
        }

        @Override
        public Iterator<String> iteratePrefixes() {
            this.makeNamespaceBindings();
            return this.staticNamespaceBindings.keySet().iterator();
        }

        @Override
        public ItemType getRequiredContextItemType() {
            return AnyItemType.getInstance();
        }

        @Override
        public DecimalFormatManager getDecimalFormatManager() {
            if (this.decimalFormatManager == null) {
                this.decimalFormatManager = new DecimalFormatManager(HostLanguage.XSLT, 30);
            }
            return this.decimalFormatManager;
        }

        @Override
        public int getXPathVersion() {
            return 31;
        }

        @Override
        public KeyManager getKeyManager() {
            return null;
        }

        @Override
        public ItemType resolveTypeAlias(StructuredQName typeName) {
            return null;
        }
    }
}

