/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.ICULibrary;
import com.saxonica.config.JavaExtensionLibrary;
import com.saxonica.config.JavaLocalizerFactory;
import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.config.pe.DynamicLoaderPE;
import com.saxonica.functions.extfn.EXPathArchive.Archive;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.java.JavaPlatform;
import net.sf.saxon.lib.IDynamicLoader;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.option.axiom.AxiomObjectModel;
import net.sf.saxon.option.dom4j.DOM4JObjectModel;
import net.sf.saxon.option.exslt.Date;
import net.sf.saxon.option.exslt.Math;
import net.sf.saxon.option.exslt.Random;
import net.sf.saxon.option.exslt.Sets;
import net.sf.saxon.option.jdom2.JDOM2ObjectModel;
import net.sf.saxon.option.xom.XOMObjectModel;
import net.sf.saxon.trans.XPathException;

public class JavaPlatformPE
extends JavaPlatform {
    @Override
    public boolean hasICUCollator() {
        return ICULibrary.isICUCollatorAvailable();
    }

    @Override
    public boolean hasICUNumberer() {
        return ICULibrary.hasNumberer();
    }

    @Override
    public void initialize(Configuration config) {
        super.initialize(config);
        if (config instanceof ProfessionalConfiguration) {
            JavaExtensionLibrary javaLib = new JavaExtensionLibrary((ProfessionalConfiguration)config);
            javaLib.declareJavaClass("http://exslt.org/sets", Sets.class);
            javaLib.declareJavaClass("http://exslt.org/math", Math.class);
            javaLib.declareJavaClass("http://exslt.org/dates-and-times", Date.class);
            javaLib.declareJavaClass("http://exslt.org/random", Random.class);
            javaLib.declareJavaClass(Archive.NAMESPACE.toString(), Archive.class);
            ((ProfessionalConfiguration)config).setExtensionBinder("java", javaLib);
            JavaLocalizerFactory jlf = new JavaLocalizerFactory(config);
            jlf.setLocalizationClass("da", "net.sf.saxon.option.local.Numberer_da");
            jlf.setLocalizationClass("de", "net.sf.saxon.option.local.Numberer_de");
            jlf.setLocalizationClass("de", "net.sf.saxon.option.local.Numberer_de");
            jlf.setLocalizationClass("en", "net.sf.saxon.expr.number.Numberer_en");
            jlf.setLocalizationClass("fr", "net.sf.saxon.option.local.Numberer_fr");
            jlf.setLocalizationClass("fr-BE", "net.sf.saxon.option.local.Numberer_frBE");
            jlf.setLocalizationClass("it", "net.sf.saxon.option.local.Numberer_it");
            jlf.setLocalizationClass("nl", "net.sf.saxon.option.local.Numberer_nl");
            jlf.setLocalizationClass("nl-BE", "net.sf.saxon.option.local.Numberer_nlBE");
            jlf.setLocalizationClass("sv", "net.sf.saxon.option.local.Numberer_sv");
            config.setLocalizerFactory(jlf);
        }
    }

    @Override
    public IDynamicLoader getDefaultDynamicLoader() {
        return new DynamicLoaderPE();
    }

    @Override
    public void addFunctionLibraries(FunctionLibraryList list, Configuration config, int hostLanguage) {
        super.addFunctionLibraries(list, config, hostLanguage);
        if (config instanceof ProfessionalConfiguration) {
            FunctionLibrary extensionBinder = ((ProfessionalConfiguration)config).getExtensionBinder("java");
            list.addFunctionLibrary(extensionBinder);
        }
    }

    @Override
    public void registerAllBuiltInObjectModels(Configuration config) {
        try {
            config.registerExternalObjectModel(AxiomObjectModel.getInstance());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            config.registerExternalObjectModel(JDOM2ObjectModel.getInstance());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            config.registerExternalObjectModel(DOM4JObjectModel.getInstance());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            config.registerExternalObjectModel(XOMObjectModel.getInstance());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public StringCollator makeUcaCollator(String uri, Configuration config) throws XPathException {
        StringCollator collator = ICULibrary.makeICUCollator(uri, config);
        if (collator == null) {
            return super.makeUcaCollator(uri, config);
        }
        return collator;
    }
}

