/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.tei.id;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.Context;
import ro.sync.ecss.extensions.api.link.CannotRecognizeIDException;
import ro.sync.ecss.extensions.api.link.DefaultIDTypeIdentifier;
import ro.sync.ecss.extensions.api.link.IDTypeIdentifier;
import ro.sync.ecss.extensions.api.link.IDTypeRecognizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TEIP5IDTypeRecognizer
extends IDTypeRecognizer {
    public List<IDTypeIdentifier> detectIDType(String systemID, Context context, String attrName, String attrNs, String attributeValue, int offset) throws CannotRecognizeIDException {
        ArrayList<IDTypeIdentifier> idTypeIdentifiers = new ArrayList<IDTypeIdentifier>();
        if (attributeValue != null && !attributeValue.trim().isEmpty()) {
            Stack elementStack;
            if ("id".equals(attrName)) {
                DefaultIDTypeIdentifier idTypeIdentifier = new DefaultIDTypeIdentifier(attributeValue.trim(), true);
                idTypeIdentifiers.add((IDTypeIdentifier)idTypeIdentifier);
            } else if ("target".equals(attrName) && !(elementStack = context.getElementStack()).isEmpty()) {
                String idValue = null;
                StringTokenizer stringTokenizer = new StringTokenizer(attributeValue, " ", true);
                int idx = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String nextToken = stringTokenizer.nextToken();
                    if (offset < idx) break;
                    if (offset <= idx + nextToken.length()) {
                        if (" ".equals(nextToken)) break;
                        idValue = nextToken;
                        break;
                    }
                    idx += nextToken.length();
                }
                if (idValue != null && !"".equals(idValue.trim()) && idValue.startsWith("#") && (idValue = idValue.substring(1)).trim().length() > 0) {
                    idTypeIdentifiers.add((IDTypeIdentifier)new DefaultIDTypeIdentifier(idValue, false));
                }
            }
        }
        return idTypeIdentifiers.isEmpty() ? null : idTypeIdentifiers;
    }

    public int[] locateIDType(String systemID, Context context, String attrName, String attrNs, String attributeValue, IDTypeIdentifier idIdentifier, short mode) {
        Stack elementStack;
        int[] idLocation = null;
        if ((mode & 1) != 0 && "id".equals(attrName)) {
            idLocation = new int[]{0, attributeValue.length()};
        }
        if ((mode & 2) != 0 && "target".equals(attrName) && !(elementStack = context.getElementStack()).isEmpty()) {
            String idValue = idIdentifier.getValue();
            String textToFind = "#" + idValue;
            int indexOf = attributeValue.indexOf(textToFind);
            while (indexOf >= 0) {
                if (indexOf + textToFind.length() == attributeValue.length() || attributeValue.charAt(indexOf + textToFind.length()) == ' ') {
                    idLocation = new int[]{indexOf + 1, indexOf + 1 + idIdentifier.getValue().length()};
                }
                if (idLocation != null) break;
                indexOf = attributeValue.indexOf(textToFind, indexOf + textToFind.length());
            }
        }
        return idLocation;
    }

    public boolean isDefaultIDTypeRecognitionAvailable() {
        return false;
    }

    public boolean isIDTypeRecognitionAvailable() {
        return true;
    }
}

