/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.tei;

import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.ContextElement;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaAwareEditingHandlerAdapter;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.InvalidEditException;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResultsImpl;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TEISchemaAwareEditingHandler
extends AuthorSchemaAwareEditingHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger((String)TEISchemaAwareEditingHandler.class.getName());
    protected final String documentNamespace;
    private static final String LIST = "list";
    private static final String PARAGRAPH = "p";
    private static final String LIST_ITEM = "item";
    private static final String TABLE = "table";
    private static final String TABLE_ROW = "row";
    private static final String TABLE_CELL = "cell";
    private static final String HEAD = "head";

    public TEISchemaAwareEditingHandler(String documentNamespace) {
        this.documentNamespace = documentNamespace;
    }

    public boolean handleTyping(int offset, char ch, AuthorAccess authorAccess) throws InvalidEditException {
        boolean handleTyping = false;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        if (!authorSchemaManager.isLearnSchema() && !authorSchemaManager.hasLoadingErrors() && authorSchemaManager.getAuthorSchemaAwareOptions().isEnableSmartTyping()) {
            try {
                AuthorDocumentFragment characterFragment = authorAccess.getDocumentController().createNewDocumentTextFragment(String.valueOf(ch));
                handleTyping = this.handleInsertionEvent(offset, new AuthorDocumentFragment[]{characterFragment}, authorAccess);
            }
            catch (AuthorOperationException e) {
                throw new InvalidEditException(e.getMessage(), "Invalid typing event: " + e.getMessage(), (Throwable)e, false);
            }
        }
        return handleTyping;
    }

    public boolean handleTypingFallback(int offset, char ch, AuthorAccess authorAccess) throws InvalidEditException {
        boolean handleEvent = false;
        try {
            AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
            WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
            if (context != null) {
                StringBuilder xmlFragment = new StringBuilder("<");
                xmlFragment.append(PARAGRAPH);
                if (this.documentNamespace != null && this.documentNamespace.length() != 0) {
                    xmlFragment.append(" xmlns=\"").append(this.documentNamespace).append("\"");
                }
                xmlFragment.append("/>");
                boolean canInsertRow = authorSchemaManager.canInsertDocumentFragments(new AuthorDocumentFragment[]{authorAccess.getDocumentController().createNewDocumentFragmentInContext(xmlFragment.toString(), offset)}, context, (short)4);
                if (canInsertRow) {
                    authorAccess.getDocumentController().insertXMLFragment(xmlFragment.toString(), offset);
                    authorAccess.getDocumentController().insertText(offset + 1, String.valueOf(ch));
                    this.lastHandlerResult = new SchemaAwareHandlerResultsImpl("result.value.handle.insert.fragment.operation");
                    ((SchemaAwareHandlerResultsImpl)this.lastHandlerResult).addResult("result.id.handle.insert.fragment.offset", (Object)(offset + 1));
                    handleEvent = true;
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Fragments cannot be inserted in a para element.");
                }
            }
        }
        catch (BadLocationException | AuthorOperationException e) {
            throw new InvalidEditException(e.getMessage(), "Invalid typing event: " + e.getMessage(), e, false);
        }
        return handleEvent;
    }

    public boolean handlePasteFragment(int offset, AuthorDocumentFragment[] fragmentsToInsert, int actionId, AuthorAccess authorAccess) throws InvalidEditException {
        boolean handleInsertionEvent = false;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        if (!authorSchemaManager.isLearnSchema() && !authorSchemaManager.hasLoadingErrors() && authorSchemaManager.getAuthorSchemaAwareOptions().isEnableSmartPaste()) {
            handleInsertionEvent = this.handleInsertionEvent(offset, fragmentsToInsert, authorAccess);
        }
        return handleInsertionEvent;
    }

    private boolean handleInsertionEvent(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess) throws InvalidEditException {
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        boolean handleEvent = false;
        try {
            boolean canInsertFragments;
            AuthorNode nodeAtInsertionOffset = authorAccess.getDocumentController().getNodeAtOffset(offset);
            if (logger.isDebugEnabled()) {
                logger.debug("nodeAtInsertionOffset " + nodeAtInsertionOffset);
            }
            if (this.isElementWithNameAndNamespace(nodeAtInsertionOffset, LIST)) {
                boolean canInsertFragments2 = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4);
                if (!canInsertFragments2) {
                    handleEvent = this.handleInvalidInsertionEventInLists(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
                }
            } else if (this.isElementWithNameAndNamespace(nodeAtInsertionOffset, TABLE) && offset != nodeAtInsertionOffset.getEndOffset() && !(canInsertFragments = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4))) {
                handleEvent = this.handleInvalidInsertionEventInTable(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
            }
        }
        catch (BadLocationException | AuthorOperationException e) {
            throw new InvalidEditException(e.getMessage(), "Invalid typing event: " + e.getMessage(), e, false);
        }
        return handleEvent;
    }

    private boolean handleInvalidInsertionEventInLists(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws BadLocationException, AuthorOperationException {
        boolean handleEvent = false;
        WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
        this.pushContextElement(context, LIST_ITEM);
        if (authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, context, (short)4)) {
            StringBuilder xmlFragment = new StringBuilder("<").append(LIST_ITEM);
            if (this.documentNamespace != null && this.documentNamespace.length() != 0) {
                xmlFragment.append(" xmlns=\"").append(this.documentNamespace).append("\"");
            }
            xmlFragment.append(">").append("</").append(LIST_ITEM).append(">");
            if (logger.isDebugEnabled()) {
                logger.debug("Insert " + xmlFragment);
            }
            authorAccess.getDocumentController().insertXMLFragment(xmlFragment.toString(), offset);
            int insertionOffset = -1;
            AuthorNode newParaNode = authorAccess.getDocumentController().getNodeAtOffset(offset + 1);
            for (int i = 0; i < fragmentsToInsert.length; ++i) {
                if (insertionOffset == -1) {
                    insertionOffset = newParaNode.getEndOffset();
                }
                authorAccess.getDocumentController().insertFragment(newParaNode.getEndOffset(), fragmentsToInsert[i]);
            }
            this.lastHandlerResult = new SchemaAwareHandlerResultsImpl("result.value.handle.insert.fragment.operation");
            ((SchemaAwareHandlerResultsImpl)this.lastHandlerResult).addResult("result.id.handle.insert.fragment.offset", (Object)insertionOffset);
            handleEvent = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("Fragments cannot be inserted in a para element.");
        }
        return handleEvent;
    }

    protected void pushContextElement(WhatElementsCanGoHereContext context, String elementName) {
        ContextElement contextElement = new ContextElement();
        contextElement.setQName(elementName);
        contextElement.setNamespace(this.documentNamespace);
        context.pushContextElement(contextElement, null);
    }

    protected boolean isElementWithNameAndNamespace(AuthorNode node, String elementLocalName) {
        boolean result = false;
        if (node.getType() == 0) {
            AuthorElement element = (AuthorElement)node;
            result = elementLocalName.equals(element.getLocalName()) && element.getNamespace().equals(this.documentNamespace);
        }
        return result;
    }

    private boolean handleInvalidInsertionEventInTable(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws BadLocationException, AuthorOperationException {
        boolean handleEvent = false;
        WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
        this.pushContextElement(context, TABLE_ROW);
        this.pushContextElement(context, TABLE_CELL);
        if (authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, context, (short)4)) {
            StringBuilder xmlFragment = new StringBuilder("<");
            xmlFragment.append(TABLE_ROW);
            if (this.documentNamespace != null && this.documentNamespace.length() != 0) {
                xmlFragment.append(" xmlns=\"").append(this.documentNamespace).append("\"");
            }
            xmlFragment.append("><");
            xmlFragment.append(TABLE_CELL);
            xmlFragment.append("/></");
            xmlFragment.append(TABLE_ROW);
            xmlFragment.append(">");
            if (logger.isDebugEnabled()) {
                logger.debug("Insert " + xmlFragment);
            }
            authorAccess.getDocumentController().insertXMLFragment(xmlFragment.toString(), offset);
            AuthorNode newCell = authorAccess.getDocumentController().getNodeAtOffset(offset + 2);
            int insertionOffset = -1;
            for (int i = 0; i < fragmentsToInsert.length; ++i) {
                if (insertionOffset == -1) {
                    insertionOffset = newCell.getEndOffset();
                }
                authorAccess.getDocumentController().insertFragment(newCell.getEndOffset(), fragmentsToInsert[i]);
            }
            this.lastHandlerResult = new SchemaAwareHandlerResultsImpl("result.value.handle.insert.fragment.operation");
            ((SchemaAwareHandlerResultsImpl)this.lastHandlerResult).addResult("result.id.handle.insert.fragment.offset", (Object)insertionOffset);
            handleEvent = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("Fragments cannot be inserted in a para element.");
        }
        return handleEvent;
    }

    public boolean changeElementsToMoveUpDown(List<AuthorNode> selectedElements) {
        AuthorNode parent;
        boolean elementsChanged = false;
        AuthorNode authorNode = selectedElements.get(0);
        if (this.isElementWithNameAndNamespace(authorNode, HEAD) && (parent = authorNode.getParent()) != null) {
            selectedElements.clear();
            selectedElements.add(parent);
            elementsChanged = true;
        }
        return elementsChanged;
    }
}

