/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.tei;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.exml.workspace.api.node.customizer.BasicRenderingInformation;
import ro.sync.exml.workspace.api.node.customizer.NodeRendererCustomizerContext;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TEINodeRendererCustomizer
extends XMLNodeRendererCustomizer {
    private static final Logger logger = LoggerFactory.getLogger((String)TEINodeRendererCustomizer.class.getName());
    private static final Map<String, String> nameToIconPath = new HashMap<String, String>();

    private static String getImageURL(String path) {
        URL imageURL = TEINodeRendererCustomizer.class.getResource(path);
        if (imageURL != null) {
            return imageURL.toExternalForm();
        }
        logger.error(TEINodeRendererCustomizer.class.getName() + " - Image not found: " + path);
        return null;
    }

    public BasicRenderingInformation getRenderingInformation(NodeRendererCustomizerContext context) {
        BasicRenderingInformation renderingInfo = new BasicRenderingInformation();
        String nodeName = context.getNodeName();
        if (nodeName != null) {
            Object imageKey = nodeName;
            switch (nodeName) {
                case "list": {
                    if ("ordered".equals(context.getAttributeValue("type"))) {
                        imageKey = (String)imageKey + "@ordered";
                        break;
                    }
                    imageKey = (String)imageKey + "@unordered";
                    break;
                }
                case "hi": {
                    String rendValue = context.getAttributeValue("rend");
                    if ("bold".equals(rendValue)) {
                        imageKey = (String)imageKey + "@bold";
                        break;
                    }
                    if ("italic".equals(rendValue) || "it".equals(rendValue)) {
                        imageKey = (String)imageKey + "@italic";
                        break;
                    }
                    if (!"ul".equals(rendValue) && !"underline".equals(rendValue)) break;
                    imageKey = (String)imageKey + "@underline";
                    break;
                }
                case "row": {
                    if (!"label".equals(context.getAttributeValue("role"))) break;
                    imageKey = (String)imageKey + "@label";
                }
            }
            String iconPath = nameToIconPath.get(imageKey);
            renderingInfo.setIconPath(iconPath);
        }
        return renderingInfo;
    }

    public String getDescription() {
        return "TEI Node Renderer Customizer";
    }

    static {
        nameToIconPath.put("TEI", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTEI16.png"));
        String headImg = TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementHead16.png");
        nameToIconPath.put("teiHeader", headImg);
        nameToIconPath.put("head", headImg);
        nameToIconPath.put("title", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTitle16.png"));
        nameToIconPath.put("p", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementPara16.png"));
        nameToIconPath.put("item", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementLi16.png"));
        nameToIconPath.put("div", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementDiv16.png"));
        nameToIconPath.put("body", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementBody16.png"));
        nameToIconPath.put("table", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTable16.png"));
        nameToIconPath.put("cell", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTd16.png"));
        nameToIconPath.put("emph", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementItalic16.png"));
        nameToIconPath.put("figure", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementImage16.png"));
        String linkIconPath = TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementLink16.png");
        nameToIconPath.put("link", linkIconPath);
        nameToIconPath.put("ref", linkIconPath);
        nameToIconPath.put("ptr", linkIconPath);
        nameToIconPath.put("list@ordered", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementOl16.png"));
        nameToIconPath.put("list@unordered", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementUl16.png"));
        nameToIconPath.put("hi@bold", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementBold16.png"));
        nameToIconPath.put("hi@italic", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementItalic16.png"));
        nameToIconPath.put("hi@underline", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementUnderline16.png"));
        nameToIconPath.put("row@label", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTHead16.png"));
        nameToIconPath.put("row", TEINodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTr16.png"));
    }
}

