/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProviderBase;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;
import ro.sync.ecss.extensions.commons.table.support.DITACALSTableCellInfoProvider;
import ro.sync.ecss.extensions.commons.table.support.DITASimpleTableCellSpanProvider;
import ro.sync.ecss.extensions.commons.table.support.errorscanner.CALSAndHTMLTableLayoutProblem;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITATableCellInfoProvider
extends AuthorTableColumnWidthProviderBase
implements AuthorTableCellSpanProvider {
    private static final String SIMPLETABLE_CLASS_VALUE = " topic/simpletable ";
    private static final String SIMPLETABLE_CELL_CLASS_VALUE = " topic/stentry ";
    private static final String SIMPLETABLE_ROW_CLASS_VALUE = " topic/strow ";
    private static final String SIMPLETABLE_HEAD_CLASS_VALUE = " topic/sthead ";
    private static final String ATTRIBUTE_NAME_CLASS = "class";
    private static final String ATTRIBUTE_NAME_RELCOLWIDTH = "relcolwidth";
    private CALSTableCellInfoProvider calsProvider;
    private DITASimpleTableCellSpanProvider simpleTableCellSpanProvider;
    private List<WidthRepresentation> columnWidths = new ArrayList<WidthRepresentation>();
    private Set<String> simpleTableCellTagNames = new HashSet<String>();
    private AuthorElement tableElement;

    public void init(AuthorElement tableElement) {
        this.tableElement = tableElement;
        this.calsProvider = null;
        this.simpleTableCellSpanProvider = null;
        AttrValue classAttrVal = tableElement.getAttribute(ATTRIBUTE_NAME_CLASS);
        if (classAttrVal == null || classAttrVal.getRawValue() == null || !classAttrVal.getRawValue().contains(" ut-d/imagemap ")) {
            if (classAttrVal != null && classAttrVal.getRawValue() != null && classAttrVal.getRawValue().contains(SIMPLETABLE_CLASS_VALUE)) {
                String value;
                this.simpleTableCellSpanProvider = new DITASimpleTableCellSpanProvider();
                this.simpleTableCellSpanProvider.init(tableElement);
                this.simpleTableCellTagNames = DITATableCellInfoProvider.detectSimpleTableCellTagNames(tableElement);
                AttrValue relColWidthAttr = tableElement.getAttribute(ATTRIBUTE_NAME_RELCOLWIDTH);
                if (relColWidthAttr != null && (value = relColWidthAttr.getValue().trim()).length() > 0) {
                    String[] split;
                    for (String token : split = value.split(" ")) {
                        float relativeWidth = 0.0f;
                        if (token.length() <= 0) continue;
                        if (token.endsWith("*")) {
                            String proportion = token.substring(0, token.length() - 1);
                            if (proportion.length() == 0) {
                                relativeWidth = 1.0f;
                            } else {
                                try {
                                    relativeWidth = NumberParserUtil.parseFloat((String)proportion);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        } else if ((token.endsWith("pt") || token.endsWith("px") || token.endsWith("in")) && this.errorsListener != null) {
                            this.errorsListener.add(tableElement, tableElement, CALSAndHTMLTableLayoutProblem.COLUMN_WIDTH_NO_MEASURING_UNITS_VALUE_INCORRECT, token);
                        }
                        WidthRepresentation colWidth = new WidthRepresentation(0.0f, null, relativeWidth, false);
                        this.columnWidths.add(colWidth);
                    }
                }
            } else {
                this.calsProvider = new DITACALSTableCellInfoProvider();
                this.calsProvider.init(tableElement);
            }
        }
    }

    private static Set<String> detectSimpleTableCellTagNames(AuthorElement tableElement) {
        HashSet<String> cellTagNames = new HashSet<String>();
        List tableChildren = tableElement.getContentNodes();
        for (AuthorNode tableChild : tableChildren) {
            AttrValue classAttrVal;
            if (tableChild.getType() != 0 || (classAttrVal = ((AuthorElement)tableChild).getAttribute(ATTRIBUTE_NAME_CLASS)) == null || classAttrVal.getRawValue() == null || !classAttrVal.getRawValue().contains(SIMPLETABLE_ROW_CLASS_VALUE) && !classAttrVal.getRawValue().contains(SIMPLETABLE_HEAD_CLASS_VALUE)) continue;
            List rowChildren = ((AuthorElement)tableChild).getContentNodes();
            for (AuthorNode rowChild : rowChildren) {
                if (rowChild.getType() != 0 || (classAttrVal = ((AuthorElement)rowChild).getAttribute(ATTRIBUTE_NAME_CLASS)) == null || classAttrVal.getRawValue() == null || !classAttrVal.getRawValue().contains(SIMPLETABLE_CELL_CLASS_VALUE)) continue;
                cellTagNames.add(((AuthorElement)rowChild).getLocalName());
            }
        }
        return cellTagNames;
    }

    private boolean isSimpleTableCell(String cellTagName) {
        return this.simpleTableCellTagNames.contains(cellTagName);
    }

    private static boolean isRelTableCell(String cellTagName) {
        return "relcell".equals(cellTagName) || "relcolspec".equals(cellTagName);
    }

    public Integer getColSpan(AuthorElement cellElement) {
        Integer toReturn = null;
        if (this.calsProvider != null) {
            toReturn = this.calsProvider.getColSpan(cellElement);
        } else if (this.simpleTableCellSpanProvider != null) {
            toReturn = this.simpleTableCellSpanProvider.getColSpan(cellElement);
        }
        return toReturn;
    }

    public Integer getRowSpan(AuthorElement cellElement) {
        Integer toReturn = null;
        if (this.calsProvider != null) {
            toReturn = this.calsProvider.getRowSpan(cellElement);
        } else if (this.simpleTableCellSpanProvider != null) {
            toReturn = this.simpleTableCellSpanProvider.getRowSpan(cellElement);
        }
        return toReturn;
    }

    public boolean hasColumnSpecifications(AuthorElement tableElement) {
        boolean toReturn = true;
        if (this.calsProvider != null) {
            toReturn = this.calsProvider.hasColumnSpecifications(tableElement);
        } else if (this.simpleTableCellSpanProvider != null) {
            toReturn = this.simpleTableCellSpanProvider.hasColumnSpecifications(tableElement);
        }
        return toReturn;
    }

    public String getDescription() {
        String toReturn = null;
        toReturn = this.calsProvider != null ? this.calsProvider.getDescription() : (this.simpleTableCellSpanProvider != null ? this.simpleTableCellSpanProvider.getDescription() : "Provides information about cells in DITA simple tables");
        return toReturn;
    }

    public List<WidthRepresentation> getCellWidth(AuthorElement cellElement, int colNumberStart, int colSpan) {
        List<WidthRepresentation> toReturn = null;
        if (this.calsProvider != null) {
            toReturn = this.calsProvider.getCellWidth(cellElement, colNumberStart, colSpan);
        } else if (colNumberStart < this.columnWidths.size()) {
            toReturn = new ArrayList<WidthRepresentation>();
            toReturn.add(this.columnWidths.get(colNumberStart));
        }
        return toReturn;
    }

    public void commitColumnWidthModifications(AuthorDocumentController authorDocumentController, WidthRepresentation[] colWidths, String tableCellsTagName) throws AuthorOperationException {
        if (this.isSimpleTableCell(tableCellsTagName)) {
            this.columnWidths.clear();
            StringBuilder newWidth = new StringBuilder();
            for (int i = 0; i < colWidths.length; ++i) {
                this.columnWidths.add(colWidths[i]);
                newWidth.append(colWidths[i].getRelativeWidth()).append("*");
                if (i == colWidths.length - 1) continue;
                newWidth.append(" ");
            }
            authorDocumentController.setAttribute(ATTRIBUTE_NAME_RELCOLWIDTH, newWidth.length() > 0 ? new AttrValue(newWidth.toString()) : null, this.tableElement);
        } else {
            this.calsProvider.commitColumnWidthModifications(authorDocumentController, colWidths, tableCellsTagName);
        }
    }

    public void commitTableWidthModification(AuthorDocumentController authorDocumentController, int newTableWidth, String tableCellsTagName) throws AuthorOperationException {
        if (this.calsProvider != null) {
            this.calsProvider.commitTableWidthModification(authorDocumentController, newTableWidth, tableCellsTagName);
        }
    }

    public WidthRepresentation getTableWidth(String tableCellsTagName) {
        if (this.calsProvider != null) {
            return this.calsProvider.getTableWidth(tableCellsTagName);
        }
        return null;
    }

    public boolean isTableAcceptingWidth(String tableCellsTagName) {
        return false;
    }

    public boolean isTableAndColumnsResizable(String tableCellsTagName) {
        boolean toReturn = false;
        if (this.isSimpleTableCell(tableCellsTagName)) {
            toReturn = true;
        } else if (!DITATableCellInfoProvider.isRelTableCell(tableCellsTagName) && this.calsProvider != null) {
            toReturn = this.calsProvider.isTableAndColumnsResizable(tableCellsTagName);
        }
        return toReturn;
    }

    public boolean isAcceptingFixedColumnWidths(String tableCellsTagName) {
        boolean toReturn = false;
        if (!this.isSimpleTableCell(tableCellsTagName) && !DITATableCellInfoProvider.isRelTableCell(tableCellsTagName) && this.calsProvider != null) {
            toReturn = this.calsProvider.isAcceptingFixedColumnWidths(tableCellsTagName);
        }
        return toReturn;
    }

    public boolean isAcceptingPercentageColumnWidths(String tableCellsTagName) {
        boolean toReturn = false;
        if (!this.isSimpleTableCell(tableCellsTagName) && !DITATableCellInfoProvider.isRelTableCell(tableCellsTagName) && this.calsProvider != null) {
            toReturn = this.calsProvider.isAcceptingPercentageColumnWidths(tableCellsTagName);
        }
        return toReturn;
    }

    public boolean isAcceptingProportionalColumnWidths(String tableCellsTagName) {
        boolean toReturn = false;
        if (this.isSimpleTableCell(tableCellsTagName)) {
            toReturn = true;
        } else if (!DITATableCellInfoProvider.isRelTableCell(tableCellsTagName) && this.calsProvider != null) {
            toReturn = this.calsProvider.isAcceptingProportionalColumnWidths(tableCellsTagName);
        }
        return toReturn;
    }

    public List<WidthRepresentation> getAllColspecWidthRepresentations() {
        List<WidthRepresentation> toReturn = null;
        toReturn = this.calsProvider != null ? this.calsProvider.getAllColspecWidthRepresentations() : this.columnWidths;
        return toReturn;
    }
}

