/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.util.List;
import java.util.Map;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TableProperty {
    private String propertyName = "";
    private String propertyRenderString = "";
    private List<String> values;
    private Map<String, String> icons;
    private String currentValue = null;
    private String oldValue = null;
    private boolean isAttr = false;
    private boolean isActive;
    private String parentGroup = null;
    private GuiElements guiType = GuiElements.COMBOBOX;

    public TableProperty(String propertyName, String propertyRenderString, List<String> propertyValues, String currentValue) {
        this(propertyName, propertyRenderString, propertyValues, currentValue, false);
    }

    public TableProperty(String propertyName, String propertyRenderString, List<String> propertyValues, String currentValue, boolean isAttribute) {
        this(propertyName, propertyRenderString, propertyValues, currentValue, isAttribute, true);
    }

    public TableProperty(String propertyName, String propertyRenderString, List<String> propertyValues, String currentValue, boolean isAttribute, boolean isActive) {
        this(propertyName, propertyRenderString, propertyValues, currentValue, null, null, null, isAttribute, isActive);
    }

    public TableProperty(String propertyName, String propertyRenderString, List<String> propertyValues, String currentValue, String parentGroup, GuiElements guiType, Map<String, String> icons, boolean isAttribute, boolean isActive) {
        this.propertyName = propertyName;
        this.propertyRenderString = propertyRenderString;
        this.values = propertyValues;
        this.currentValue = currentValue;
        this.isAttr = isAttribute;
        this.isActive = isActive;
        this.parentGroup = parentGroup;
        if (guiType != null) {
            this.guiType = guiType;
        }
        this.icons = icons;
    }

    public String getAttributeName() {
        return this.propertyName;
    }

    public String getAttributeRenderString() {
        return this.propertyRenderString;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        if (currentValue != null) {
            this.oldValue = currentValue;
        }
        this.currentValue = currentValue;
    }

    public String getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(String parentGroup) {
        this.parentGroup = parentGroup;
    }

    public boolean isAttribute() {
        return this.isAttr;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj != null && this.getClass() == obj.getClass()) {
            TableProperty prop = (TableProperty)obj;
            boolean valuesEquals = false;
            List<String> propertyValues = prop.getValues();
            if (this.values == null && propertyValues == null) {
                valuesEquals = true;
            } else if (this.values != null && propertyValues != null) {
                valuesEquals = this.values.size() == propertyValues.size() && this.values.containsAll(propertyValues) && propertyValues.containsAll(this.values);
            }
            boolean currentValueEquals = this.currentValue == null && prop.getCurrentValue() == null || this.currentValue != null && this.currentValue.equals(prop.getCurrentValue());
            boolean nameEquals = this.propertyName == null && prop.getAttributeRenderString() == null || this.propertyName != null && this.propertyName.equals(prop.getAttributeName());
            boolean renderStrEquals = this.propertyRenderString == null && prop.getAttributeRenderString() == null || this.propertyRenderString != null && this.propertyRenderString.equals(prop.getAttributeRenderString());
            equals = nameEquals && valuesEquals && currentValueEquals && renderStrEquals && this.isAttribute() == prop.isAttribute();
        }
        return equals;
    }

    public String toString() {
        return "Name: " + this.propertyName + " render string: " + this.propertyRenderString + " current value: " + this.currentValue + " is attribute: " + this.isAttr + " possible values: " + this.values;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public void setGuiType(GuiElements guiType) {
        if (guiType != null) {
            this.guiType = guiType;
        }
    }

    public GuiElements getGuiType() {
        return this.guiType;
    }

    public Map<String, String> getIcons() {
        return this.icons;
    }

    public void setIcons(Map<String, String> icons) {
        this.icons = icons;
    }
}

