/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.Position;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.commons.table.properties.ECTablePropertiesCustomizerDialog;
import ro.sync.ecss.extensions.commons.table.properties.EditedTablePropertiesInfo;
import ro.sync.ecss.extensions.commons.table.properties.SATablePropertiesCustomizerDialog;
import ro.sync.ecss.extensions.commons.table.properties.TabInfo;
import ro.sync.ecss.extensions.commons.table.properties.TablePropertiesHelper;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;
import ro.sync.exml.workspace.api.Platform;
import ro.sync.exml.workspace.api.util.ColorThemeUtilities;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class ShowTablePropertiesBaseOperation
implements AuthorOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ShowTablePropertiesBaseOperation.class.getName());
    protected TablePropertiesHelper tableHelper;
    protected AuthorAccess authorAccess;

    public ShowTablePropertiesBaseOperation(TablePropertiesHelper tableHelper) {
        this.tableHelper = tableHelper;
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        this.authorAccess = authorAccess;
        try {
            this.showTableProperties(args);
        }
        catch (AuthorOperationException e) {
            authorAccess.getWorkspaceAccess().showErrorMessage(e.getMessage(), (Throwable)e);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public void showTableProperties(ArgumentsMap args) throws AuthorOperationException {
        int oldCaretOffset = this.authorAccess.getEditorAccess().getCaretOffset();
        List<Integer[]> selections = this.getSelections();
        List<TabInfo> categoriesAndAttributes = this.getCategoriesAndProperties(selections);
        if (categoriesAndAttributes.isEmpty()) {
            throw new AuthorOperationException(this.authorAccess.getAuthorResourceBundle().getMessage("Cannot_perform_operation_no_element_to_edit_properties_for"));
        }
        EditedTablePropertiesInfo tableInfo = null;
        EditedTablePropertiesInfo editedTablePropertiesInfo = new EditedTablePropertiesInfo(categoriesAndAttributes, this.getSelectedTab(selections));
        tableInfo = args.getArgumentValue("tableInfo") != null ? ShowTablePropertiesBaseOperation.getTableInfoFromDescriptor((Map)args.getArgumentValue("tableInfo"), categoriesAndAttributes) : this.showDialog(editedTablePropertiesInfo);
        if (tableInfo != null) {
            this.applyChanges(tableInfo);
            this.authorAccess.getEditorAccess().setCaretPosition(oldCaretOffset);
        }
    }

    private static EditedTablePropertiesInfo getTableInfoFromDescriptor(Map<String, List> tableInforDescriptor, List<TabInfo> categoriesAndAttributes) {
        ArrayList<TabInfo> modifications = new ArrayList<TabInfo>();
        EditedTablePropertiesInfo tableInfo = null;
        for (TabInfo tabInfo : categoriesAndAttributes) {
            ArrayList<TableProperty> modifiedProperties = new ArrayList<TableProperty>();
            List attributes = tableInforDescriptor.get(tabInfo.getTabKey());
            if (attributes == null) continue;
            for (Map attribute : attributes) {
                String attributeName = (String)attribute.get("attributeName");
                boolean isAttribute = (Boolean)attribute.get("attribute");
                String value = (String)attribute.get("currentValue");
                modifiedProperties.add(new TableProperty(attributeName, null, null, value, isAttribute));
            }
            if (modifiedProperties.isEmpty()) continue;
            List<AuthorElement> nodes = tabInfo.getNodes();
            modifications.add(new TabInfo(tabInfo.getTabKey(), modifiedProperties, nodes));
        }
        if (!modifications.isEmpty()) {
            tableInfo = new EditedTablePropertiesInfo(modifications);
        }
        return tableInfo;
    }

    private void applyChanges(EditedTablePropertiesInfo tableInfo) throws AuthorOperationException {
        this.applyAttributesChanges(tableInfo);
        List<TabInfo> fragmentsAndOffsetsToInsert = this.getFragmentsAndOffsetsToInsert(tableInfo);
        for (int i = 0; i < fragmentsAndOffsetsToInsert.size(); ++i) {
            TabInfo tabInfo = fragmentsAndOffsetsToInsert.get(i);
            this.applyTabChanges(tabInfo);
        }
    }

    private void applyTabChanges(TabInfo tabInfo) {
        List<AuthorElement> nodesToDelete = tabInfo.getNodes();
        AuthorNode commonAncestor = this.authorAccess.getDocumentController().getStrictCommonAncestor((AuthorNode[])nodesToDelete.toArray(new AuthorElement[0]));
        if (!(commonAncestor instanceof AuthorElement)) {
            return;
        }
        Iterator<AuthorElement> iterator = nodesToDelete.iterator();
        while (iterator.hasNext()) {
            AuthorElement authorElement = iterator.next();
            if (!nodesToDelete.contains(authorElement.getParentElement())) continue;
            iterator.remove();
        }
        ShowTablePropertiesBaseOperation.sortInDocumentOrder(nodesToDelete);
        int[] startOffsets = new int[nodesToDelete.size()];
        int[] endOffsets = new int[nodesToDelete.size()];
        for (int j = 0; j < nodesToDelete.size(); ++j) {
            startOffsets[j] = nodesToDelete.get(j).getStartOffset();
            endOffsets[j] = nodesToDelete.get(j).getEndOffset();
        }
        this.authorAccess.getDocumentController().multipleDelete((AuthorElement)commonAncestor, startOffsets, endOffsets);
        int[] offsets = new int[tabInfo.getFragmentsToInsert().size()];
        for (int j = 0; j < tabInfo.getFragmentsToInsert().size(); ++j) {
            offsets[j] = tabInfo.getInsertOffsets()[j].getOffset();
        }
        this.authorAccess.getDocumentController().insertMultipleFragments((AuthorElement)commonAncestor, tabInfo.getFragmentsToInsert().toArray(new AuthorDocumentFragment[0]), offsets);
    }

    private static void sortInDocumentOrder(List<AuthorElement> nodesToDelete) {
        Collections.sort(nodesToDelete, new Comparator<AuthorElement>(){

            @Override
            public int compare(AuthorElement o1, AuthorElement o2) {
                int toRet = 0;
                toRet = o1.getStartOffset() < o2.getStartOffset() ? -1 : 1;
                return toRet;
            }
        });
    }

    private void applyAttributesChanges(EditedTablePropertiesInfo tableInfo) {
        List<TabInfo> attributesModifications = this.getElementsWithModifiedAttributes(tableInfo);
        for (int i = 0; i < attributesModifications.size(); ++i) {
            TabInfo tabInfo = attributesModifications.get(i);
            List<AuthorElement> authorElements = tabInfo.getNodes();
            List<TableProperty> attrsToModify = tabInfo.getProperties();
            AuthorNode commonAncestor = this.authorAccess.getDocumentController().getCommonAncestor((AuthorNode[])authorElements.toArray(new AuthorElement[0]));
            if (commonAncestor == null) continue;
            int[] offsets = new int[authorElements.size()];
            for (int j = 0; j < authorElements.size(); ++j) {
                AuthorElement authorElement = authorElements.get(j);
                offsets[j] = authorElement.getStartOffset();
            }
            LinkedHashMap<String, AttrValue> attributes = new LinkedHashMap<String, AttrValue>();
            for (int k = 0; k < attrsToModify.size(); ++k) {
                TableProperty attr = attrsToModify.get(k);
                attributes.put(attr.getAttributeName(), attr.getCurrentValue() != null ? new AttrValue(attr.getCurrentValue()) : null);
            }
            if (attributes.isEmpty()) continue;
            this.authorAccess.getDocumentController().setMultipleAttributes(commonAncestor.getStartOffset(), offsets, attributes);
        }
    }

    private EditedTablePropertiesInfo showDialog(EditedTablePropertiesInfo editedTablePropertiesInfo) {
        EditedTablePropertiesInfo tableInfo = null;
        Platform platform = this.authorAccess.getWorkspaceAccess().getPlatform();
        if (platform == Platform.STANDALONE) {
            Frame parentFrame = (Frame)this.authorAccess.getWorkspaceAccess().getParentFrame();
            SATablePropertiesCustomizerDialog saTablePropertiesCustomizer = new SATablePropertiesCustomizerDialog(parentFrame, this.authorAccess.getAuthorResourceBundle(), (ColorThemeUtilities)this.authorAccess.getWorkspaceAccess()){

                public String getHelpPageID() {
                    return ShowTablePropertiesBaseOperation.this.getHelpPageID();
                }
            };
            tableInfo = saTablePropertiesCustomizer.getTablePropertiesInformation(editedTablePropertiesInfo);
        } else if (platform == Platform.ECLIPSE) {
            ECTablePropertiesCustomizerDialog ecTablePropertiesCustomizer = new ECTablePropertiesCustomizerDialog((Shell)this.authorAccess.getWorkspaceAccess().getParentFrame(), this.authorAccess.getAuthorResourceBundle(), (ColorThemeUtilities)this.authorAccess.getWorkspaceAccess(), this.getHelpPageID());
            tableInfo = ecTablePropertiesCustomizer.getTablePropertiesInformation(editedTablePropertiesInfo);
        }
        return tableInfo;
    }

    private List<Integer[]> getSelections() throws AuthorOperationException {
        ArrayList<Integer[]> selections = new ArrayList<Integer[]>();
        if (this.authorAccess.getEditorAccess().hasSelection()) {
            List selectionIntervals = this.authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
            if (selectionIntervals != null && !selectionIntervals.isEmpty()) {
                for (int i = 0; i < selectionIntervals.size(); ++i) {
                    int startOffset = ((ContentInterval)selectionIntervals.get(i)).getStartOffset();
                    int endOffset = ((ContentInterval)selectionIntervals.get(i)).getEndOffset();
                    selections.add(new Integer[]{startOffset, endOffset});
                }
            }
        } else {
            int caretOffset = this.authorAccess.getEditorAccess().getCaretOffset();
            selections.add(new Integer[]{caretOffset, caretOffset});
        }
        List<AuthorElement> tableElements = TableOperationsUtil.getTableElementsOfType(this.authorAccess, selections, 5, this.tableHelper);
        int tableElementsNumber = 0;
        for (int i = 0; i < tableElements.size() && tableElementsNumber < 2; ++i) {
            if (this.tableHelper.isNodeOfType(tableElements.get(i), 4)) continue;
            ++tableElementsNumber;
        }
        if (tableElementsNumber > 1) {
            throw new AuthorOperationException(this.authorAccess.getAuthorResourceBundle().getMessage("Cannot_perform_table_properties_operation"));
        }
        return selections;
    }

    protected List<TabInfo> getElementsWithModifiedAttributes(EditedTablePropertiesInfo tableInfo) {
        ArrayList<TabInfo> toModify = new ArrayList<TabInfo>();
        List<TabInfo> categories = tableInfo.getCategories();
        for (int i = 0; i < categories.size(); ++i) {
            ArrayList<TableProperty> attrs = new ArrayList<TableProperty>();
            TabInfo tabInfo = categories.get(i);
            List<TableProperty> props = tabInfo.getProperties();
            for (int j = 0; j < props.size(); ++j) {
                TableProperty prop = props.get(j);
                if (!prop.isAttribute() || "<preserve>".equals(prop.getCurrentValue())) continue;
                if ("<not set>".equals(prop.getCurrentValue())) {
                    prop.setCurrentValue(null);
                }
                attrs.add(prop);
            }
            toModify.add(new TabInfo(tabInfo.getTabKey(), attrs, tabInfo.getNodes()));
        }
        return toModify;
    }

    protected boolean checkRowSpans(List<AuthorElement> collectedRows, int parentType) {
        boolean toReturn = true;
        block0: for (int i = 0; i < collectedRows.size(); ++i) {
            ArrayList<AuthorElement> children = new ArrayList<AuthorElement>();
            AuthorElement currentRow = collectedRows.get(i);
            TableOperationsUtil.getChildElements(currentRow, 6, children, this.tableHelper);
            for (int j = 0; j < children.size(); ++j) {
                AuthorElement tgroup;
                int[] tableRowSpanIndices = this.authorAccess.getTableAccess().getTableRowSpanIndices((AuthorElement)children.get(j));
                if (tableRowSpanIndices == null || tableRowSpanIndices[1] - tableRowSpanIndices[0] <= 0 || (tgroup = TableOperationsUtil.getElementAncestor((AuthorNode)currentRow, parentType, this.tableHelper)) == null) continue;
                ArrayList<AuthorElement> rows = new ArrayList<AuthorElement>();
                TableOperationsUtil.getChildElements(tgroup, 0, rows, this.tableHelper);
                List subList = rows.subList(tableRowSpanIndices[0], tableRowSpanIndices[1] + 1);
                int elementType = this.tableHelper.getElementType((AuthorElement)((AuthorElement)subList.get(0)).getParent());
                for (int k = 1; k < subList.size(); ++k) {
                    if (elementType == this.tableHelper.getElementType((AuthorElement)((AuthorElement)subList.get(k)).getParent())) continue;
                    toReturn = false;
                    break block0;
                }
                if (collectedRows.containsAll(subList)) continue;
                toReturn = false;
                break block0;
            }
        }
        return toReturn;
    }

    public String getDescription() {
        return null;
    }

    protected List<TabInfo> getFragmentsAndOffsetsToInsert(EditedTablePropertiesInfo tableInfo) throws AuthorOperationException {
        List<TabInfo> tabsInfo = tableInfo.getCategories();
        ArrayList<TabInfo> modifications = new ArrayList<TabInfo>();
        for (int i = 0; i < tabsInfo.size(); ++i) {
            ArrayList<AuthorDocumentFragment> fragments = new ArrayList<AuthorDocumentFragment>();
            ArrayList<Position> offsets = new ArrayList<Position>();
            TabInfo tabInfo = tabsInfo.get(i);
            TabInfo modification = null;
            ArrayList<AuthorElement> nodesToModify = new ArrayList<AuthorElement>();
            List<TableProperty> props = tabInfo.getProperties();
            for (int j = 0; j < props.size(); ++j) {
                TableProperty prop = props.get(j);
                if (prop.isAttribute()) continue;
                modification = new TabInfo(tabInfo.getTabKey(), tabInfo.getProperties(), null);
                String currentValue = prop.getCurrentValue();
                if ("rowType".equals(prop.getAttributeName())) {
                    for (int k = 0; k < tabInfo.getNodes().size(); ++k) {
                        boolean deleteParent = false;
                        AuthorElement currentNode = tabInfo.getNodes().get(k);
                        deleteParent = "Body".equals(currentValue) ? this.computeFragmentsToMoveInsideBody(fragments, offsets, tabInfo, nodesToModify, currentNode) : ("Header".equals(currentValue) ? this.computeFragmentMoveInsideHeader(fragments, offsets, tabInfo, nodesToModify, currentNode) : this.computeFragmentsToMoveInsideFooter(fragments, offsets, tabInfo, nodesToModify, currentNode));
                        if (!deleteParent || nodesToModify.contains(currentNode.getParentElement())) continue;
                        nodesToModify.add(0, (AuthorElement)currentNode.getParentElement());
                    }
                    modification.setNodes(nodesToModify);
                    modification.setFragmentsToInsert(fragments);
                    modification.setInsertOffsets(offsets.toArray(new Position[0]));
                }
                modifications.add(modification);
            }
        }
        return modifications;
    }

    protected TabInfo getTableInformation(List<Integer[]> selections) {
        TabInfo tabInfo = null;
        List<AuthorElement> tableElements = TableOperationsUtil.getTableElementsOfType(this.authorAccess, selections, 5, this.tableHelper);
        if (!tableElements.isEmpty()) {
            int i;
            ArrayList<TableProperty> tableProperties = new ArrayList<TableProperty>();
            ArrayList<AuthorElement> nodes = new ArrayList<AuthorElement>();
            HashMap<TableProperty, String> commonValues = new HashMap<TableProperty, String>();
            nodes.addAll(tableElements);
            List<TableProperty> attributes = this.getTableAttribute();
            for (i = 0; i < tableElements.size(); ++i) {
                AuthorElement currentElement = tableElements.get(i);
                for (int j = 0; j < attributes.size(); ++j) {
                    if (i == 0) {
                        commonValues.put(attributes.get(j), "Not computed");
                    }
                    String commonValue = this.getCommonValue(currentElement, attributes.get(j).getAttributeName(), (String)commonValues.get(attributes.get(j)));
                    commonValues.put(attributes.get(j), commonValue);
                }
            }
            for (i = 0; i < attributes.size(); ++i) {
                TableProperty currentAttribute = attributes.get(i);
                TableProperty tb = this.getAttrProperty(tableElements, (String)commonValues.get(currentAttribute), currentAttribute);
                if (tb == null) continue;
                tableProperties.add(tb);
            }
            tabInfo = new TabInfo("Table", tableProperties, nodes);
        }
        return tabInfo;
    }

    protected TableProperty getAttrProperty(List<AuthorElement> collectedElements, String detectedAttributeValue, TableProperty currentAttribute) {
        TableProperty tableProperty = null;
        ArrayList<String> attrValues = new ArrayList<String>();
        HashMap<String, String> icons = new HashMap<String, String>();
        if (!collectedElements.isEmpty()) {
            if (currentAttribute.getValues() != null) {
                attrValues.addAll(currentAttribute.getValues());
            }
            for (int i = 0; i < attrValues.size(); ++i) {
                String value = (String)attrValues.get(i);
                if (value.equalsIgnoreCase("left")) {
                    icons.put(value, "/images/table-properties/HalignLeft.png");
                    continue;
                }
                if (value.equalsIgnoreCase("right")) {
                    icons.put(value, "/images/table-properties/HalignRight.png");
                    continue;
                }
                if (value.equalsIgnoreCase("center")) {
                    icons.put(value, "/images/table-properties/HalignCenter.png");
                    continue;
                }
                if (value.equalsIgnoreCase("justify")) {
                    icons.put(value, "/images/table-properties/HalignJustify.png");
                    continue;
                }
                if (value.equalsIgnoreCase("top")) {
                    icons.put(value, "/images/table-properties/ValignTop.png");
                    continue;
                }
                if (value.equalsIgnoreCase("middle")) {
                    icons.put(value, "/images/table-properties/ValignMiddle.png");
                    continue;
                }
                if (value.equalsIgnoreCase("bottom")) {
                    icons.put(value, "/images/table-properties/ValignBottom.png");
                    continue;
                }
                icons.put(value, "/images/table-properties/EmptyIcon.png");
            }
            if (currentAttribute.getIcons() != null) {
                icons.putAll(currentAttribute.getIcons());
            }
            String currentValue = null;
            if (collectedElements.size() > 1) {
                if (detectedAttributeValue == null || "Not computed".equals(detectedAttributeValue)) {
                    currentValue = "<not set>";
                } else if (!attrValues.contains(detectedAttributeValue)) {
                    currentValue = "<preserve>";
                    attrValues.add("<preserve>");
                    icons.put("<preserve>", "/images/table-properties/EmptyIcon.png");
                } else {
                    currentValue = detectedAttributeValue;
                }
            } else if (collectedElements.size() == 1) {
                currentValue = "<not set>";
                AttrValue attribute = collectedElements.get(0).getAttribute(currentAttribute.getAttributeName());
                if (attribute != null && !attrValues.contains(currentValue = attribute.getValue())) {
                    currentValue = "<preserve>";
                    attrValues.add("<preserve>");
                    icons.put("<preserve>", "/images/table-properties/EmptyIcon.png");
                }
            }
            attrValues.add("<not set>");
            icons.put("<not set>", "/images/table-properties/EmptyIcon.png");
            tableProperty = new TableProperty(currentAttribute.getAttributeName(), currentAttribute.getAttributeRenderString(), attrValues, currentValue, true);
            tableProperty.setGuiType(currentAttribute.getGuiType());
            tableProperty.setParentGroup(currentAttribute.getParentGroup());
            tableProperty.setIcons(icons);
        }
        return tableProperty;
    }

    protected String getCommonValue(AuthorElement currentElem, String attrQname, String currentValue) {
        AttrValue attribute;
        boolean notAllowed;
        String computedValue = currentValue;
        boolean addPreserve = !this.tableHelper.isTable(currentElem);
        boolean isTableElement = this.tableHelper.isTable(currentElem) && !this.tableHelper.isTableGroup(currentElem);
        boolean bl = notAllowed = "align".equals(attrQname) && isTableElement;
        if (!notAllowed && !isTableElement) {
            AttrValue attribute2 = currentElem.getAttribute(attrQname);
            if (attribute2 != null) {
                String currentVal = attribute2.getValue();
                if ("Not computed".equals(computedValue)) {
                    computedValue = currentVal;
                } else if (computedValue == null && addPreserve || computedValue != null && !computedValue.equals(currentVal) && !computedValue.equals("<not set>") && !computedValue.equals("<preserve>") && addPreserve) {
                    computedValue = "<preserve>";
                }
            } else if (computedValue != null && !computedValue.equals("Not computed") && !computedValue.equals("<preserve>") && addPreserve) {
                computedValue = "<preserve>";
            } else if ("Not computed".equals(computedValue)) {
                computedValue = null;
            }
        } else if (isTableElement && (attribute = currentElem.getAttribute(attrQname)) != null) {
            String currentVal;
            computedValue = currentVal = attribute.getValue();
        }
        return computedValue;
    }

    protected EditedTablePropertiesInfo.TAB_TYPE getSelectedTab(List<Integer[]> selections) {
        EditedTablePropertiesInfo.TAB_TYPE tab;
        block20: {
            tab = EditedTablePropertiesInfo.TAB_TYPE.TABLE_TAB;
            try {
                AuthorEditorAccess editorAccess = this.authorAccess.getEditorAccess();
                SelectionInterpretationMode selectionInterpretationMode = editorAccess.getAuthorSelectionModel().getSelectionInterpretationMode();
                if (selectionInterpretationMode != null) {
                    if (selectionInterpretationMode == SelectionInterpretationMode.TABLE_COLUMN) {
                        tab = EditedTablePropertiesInfo.TAB_TYPE.COLUMN_TAB;
                    } else if (selectionInterpretationMode == SelectionInterpretationMode.TABLE_ROW) {
                        tab = EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB;
                    }
                    break block20;
                }
                if (selections.size() == 1 && selections.get(0)[0].intValue() == selections.get(0)[1].intValue()) {
                    AuthorNode nodeAtOffset = this.authorAccess.getDocumentController().getNodeAtOffset(selections.get(0)[0].intValue());
                    if (nodeAtOffset instanceof AuthorElement) {
                        if (this.tableHelper.isTableCell((AuthorElement)nodeAtOffset)) {
                            tab = EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB;
                        } else if (this.tableHelper.isTableRow((AuthorElement)nodeAtOffset)) {
                            tab = EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB;
                        }
                    }
                    break block20;
                }
                for (int i = 0; i < selections.size(); ++i) {
                    Integer[] currentSel = selections.get(i);
                    AuthorNode fullySelectedNode = editorAccess.getFullySelectedNode(editorAccess.getBalancedSelection(currentSel[0].intValue(), currentSel[1].intValue())[0], editorAccess.getBalancedSelection(currentSel[0].intValue(), currentSel[1].intValue())[1]);
                    if (fullySelectedNode instanceof AuthorElement) {
                        tab = this.getTabType((AuthorElement)fullySelectedNode);
                        if (tab != EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB) continue;
                        break;
                    }
                    List nodesToSelect = this.authorAccess.getDocumentController().getNodesToSelect(editorAccess.getBalancedSelection(currentSel[0].intValue(), currentSel[1].intValue())[0], editorAccess.getBalancedSelection(currentSel[0].intValue(), currentSel[1].intValue())[1]);
                    for (int j = 0; j < nodesToSelect.size(); ++j) {
                        AuthorNode authorNode = (AuthorNode)nodesToSelect.get(j);
                        if (!(authorNode instanceof AuthorElement)) continue;
                        AuthorElement authorElement = (AuthorElement)authorNode;
                        tab = this.getTabType(authorElement);
                        if (tab == EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB) break block20;
                        ArrayList<Object> rowchildren = new ArrayList<AuthorElement>();
                        if (tab != EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB) {
                            ArrayList<AuthorElement> selectedRowChildren = new ArrayList<AuthorElement>();
                            AuthorElement tableElement = TableOperationsUtil.getElementAncestor((AuthorNode)authorElement, 5, this.tableHelper);
                            TableOperationsUtil.getChildElements(tableElement, 0, rowchildren, this.tableHelper);
                            TableOperationsUtil.computeElementsList(selectedRowChildren, tableElement, editorAccess.getBalancedSelection(currentSel[0].intValue(), currentSel[1].intValue())[0], editorAccess.getBalancedSelection(currentSel[0].intValue(), currentSel[1].intValue())[1], 0, true, this.tableHelper);
                            if (rowchildren.size() > selectedRowChildren.size()) {
                                tab = EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB;
                                rowchildren = new ArrayList();
                                TableOperationsUtil.computeElementsList(rowchildren, tableElement, currentSel[0], currentSel[1], 0, false, this.tableHelper);
                            }
                        }
                        if (!rowchildren.isEmpty()) {
                            for (int k = 0; k < rowchildren.size(); ++k) {
                                AuthorElement selectedRow = (AuthorElement)rowchildren.get(k);
                                tab = this.checkForCellTab(selectedRow, currentSel[0], currentSel[1], tab);
                                if (tab != EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB) {
                                    continue;
                                }
                                break block20;
                            }
                            continue;
                        }
                        tab = this.checkForCellTab(authorElement, currentSel[0], currentSel[1], tab);
                        if (tab != EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB) {
                            continue;
                        }
                        break block20;
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.debug(e.getMessage(), e);
            }
        }
        return tab;
    }

    private EditedTablePropertiesInfo.TAB_TYPE checkForCellTab(AuthorElement element, int selStart, int selEnd, EditedTablePropertiesInfo.TAB_TYPE currentTab) {
        ArrayList<AuthorElement> children = new ArrayList<AuthorElement>();
        TableOperationsUtil.getChildElements(element, 6, children, this.tableHelper);
        ArrayList<AuthorElement> selectedCellChildren = new ArrayList<AuthorElement>();
        TableOperationsUtil.computeElementsList(selectedCellChildren, element, selStart, selEnd, 6, true, this.tableHelper);
        if (!selectedCellChildren.isEmpty() && children.size() > selectedCellChildren.size()) {
            currentTab = EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB;
        }
        return currentTab;
    }

    private EditedTablePropertiesInfo.TAB_TYPE getTabType(AuthorElement element) {
        EditedTablePropertiesInfo.TAB_TYPE tab = EditedTablePropertiesInfo.TAB_TYPE.TABLE_TAB;
        if (this.tableHelper.isNodeOfType(element, 6)) {
            tab = EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB;
        } else if (this.tableHelper.isNodeOfType(element, 0)) {
            tab = EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB;
        }
        return tab;
    }

    protected abstract List<TabInfo> getCategoriesAndProperties(List<Integer[]> var1);

    protected abstract List<TableProperty> getTableAttribute();

    protected abstract boolean computeFragmentsToMoveInsideFooter(List<AuthorDocumentFragment> var1, List<Position> var2, TabInfo var3, List<AuthorElement> var4, AuthorElement var5) throws AuthorOperationException;

    protected abstract boolean computeFragmentMoveInsideHeader(List<AuthorDocumentFragment> var1, List<Position> var2, TabInfo var3, List<AuthorElement> var4, AuthorElement var5) throws AuthorOperationException;

    protected abstract boolean computeFragmentsToMoveInsideBody(List<AuthorDocumentFragment> var1, List<Position> var2, TabInfo var3, List<AuthorElement> var4, AuthorElement var5) throws AuthorOperationException;

    protected String getHelpPageID() {
        return null;
    }
}

