/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class ExecuteMultipleActionsOperation
implements AuthorOperation {
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[1];
    public static final String ACTION_IDS = "actionIDs";

    public ExecuteMultipleActionsOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ACTION_IDS, 0, "The IDs of the actions that will be executed in sequence, separated either by new lines or by commas.");
    }

    public String getDescription() {
        return "Run a sequence of actions defined in the associated document type.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object actionIDs = args.getArgumentValue(ACTION_IDS);
        List<Object> actions = this.getActions(authorAccess, actionIDs);
        for (Object action : actions) {
            authorAccess.getEditorAccess().getActionsProvider().invokeAction(action);
        }
    }

    public List<Object> getActions(AuthorAccess authorAccess, Object actionIDs) throws AuthorOperationException {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (actionIDs != null) {
            String ids = (String)actionIDs;
            String[] allIds = ids.contains(",") ? ids.split(",") : ids.split("\n");
            Map authorExtensionActions = authorAccess.getEditorAccess().getActionsProvider().getAuthorExtensionActions();
            Map authorCommonActions = authorAccess.getEditorAccess().getActionsProvider().getAuthorCommonActions();
            for (int i = 0; i < allIds.length; ++i) {
                Object action;
                String id = allIds[i].trim();
                if (id.isEmpty()) continue;
                boolean actionFound = false;
                if (authorExtensionActions != null && (action = authorExtensionActions.get(id)) != null) {
                    actionFound = true;
                    actions.add(action);
                }
                if (!actionFound && authorCommonActions != null && (action = authorCommonActions.get(id)) != null) {
                    actionFound = true;
                    actions.add(action);
                }
                if (actionFound) continue;
                throw new AuthorOperationException("Could not find an extension action with the ID: '" + id + "'");
            }
        } else {
            throw new AuthorOperationException("The actions IDs were not specified as a parameter.");
        }
        return actions;
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

